/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.dialog;

import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.performance.composite.tree.CollectorBasicScopeComposite;
import com.clustercontrol.performance.composite.tree.CollectorRuleComposite;
import com.clustercontrol.performance.composite.tree.CollectorTreeComposite;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performanceMGR.bean.CollectorProperty;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RecordSetDialog
extends CommonDialog {
    public static final int WIDTH_TITLE = 3;
    public static final int WIDTH_VALUE = 2;
    private CollectorProperty inputData = null;
    private ValidateResult validateResult = null;
    private CollectorBasicScopeComposite m_collectorBasic = null;
    private CollectorRuleComposite m_collectorRule = null;
    private Composite periodComposite = null;
    private Label periodLabel = null;
    private Text hourText = null;
    private Label hourLabel = null;
    private Text minText = null;
    private Label minLabel = null;
    private Text dayText = null;
    private Label dayLabel = null;
    private boolean enabled = true;
    private Button limitButton = null;
    private Button unlimitButton = null;
    private Label presaveLabel = null;
    private Text presaveText = null;
    private Label dayLabel2 = null;
    private CollectorTreeComposite itemTreeComposite;

    public RecordSetDialog(Shell parent) {
        super(parent);
    }

    public RecordSetDialog(Shell parent, CollectorProperty property, boolean enabled) {
        super(parent);
        this.inputData = property;
        this.enabled = enabled;
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        if (this.enabled) {
            shell.setText(com.clustercontrol.util.Messages.getString((String)com.clustercontrol.util.Messages.getString((String)"dialog.performance.collector.create")));
        } else {
            shell.setText(com.clustercontrol.util.Messages.getString((String)com.clustercontrol.util.Messages.getString((String)"dialog.performance.collector.property")));
        }
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        this.m_collectorBasic = new CollectorBasicScopeComposite(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_collectorBasic.setLayoutData(gridData);
        if (this.inputData != null) {
            this.m_collectorBasic.setInputData(this.inputData.getCollectorData());
        }
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(com.clustercontrol.util.Messages.getString((String)"collection.setting")) + " : ");
        Group groupRule = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupRule.setLayoutData((Object)gridData);
        this.m_collectorRule = new CollectorRuleComposite((Composite)groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_collectorRule.setLayoutData(gridData);
        if (this.inputData != null) {
            this.m_collectorRule.setInputData(this.inputData.getCollectorData());
        }
        this.createPeriodGroup((Composite)groupRule);
        label = new Label((Composite)groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(com.clustercontrol.util.Messages.getString((String)"collection.item")) + " : ");
        String collectorId = null;
        if (this.inputData != null) {
            collectorId = this.inputData.getCollectorData().getCollectorID();
        }
        this.itemTreeComposite = new CollectorTreeComposite((Composite)groupRule, 0, this.m_collectorBasic.getFacilityId(), collectorId);
        this.m_collectorBasic.setUpdateComposite(this.itemTreeComposite);
        gridData = new GridData();
        gridData.horizontalSpan = 150;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 300;
        this.itemTreeComposite.setLayoutData(gridData);
        if (this.inputData != null) {
            this.itemTreeComposite.setItemList(this.inputData.getItemList());
        }
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        this.setEnabled(this.enabled);
    }

    private void createPeriodGroup(Composite parent) {
        this.periodComposite = new Composite(parent, 0);
        GridLayout compLayout = new GridLayout(8, false);
        compLayout.marginWidth = 0;
        compLayout.marginHeight = 0;
        this.periodComposite.setLayout((Layout)compLayout);
        GridData labelData = new GridData(1040);
        labelData.verticalSpan = 2;
        GridData limitRadioData = new GridData();
        GridData preiodDayTextData = new GridData();
        GridData periodDayData = new GridData();
        GridData periodHoutTextData = new GridData();
        GridData periodHourData = new GridData();
        GridData periodMinTextData = new GridData();
        GridData periodMinData = new GridData();
        GridData unlimitRadioData = new GridData();
        GridData presaveLabelData = new GridData(768);
        GridData presaveTextData = new GridData();
        GridData presaveDay2Data = new GridData();
        PositiveNumberVerifyListener verifyListener = new PositiveNumberVerifyListener();
        this.periodLabel = new Label(this.periodComposite, 0);
        this.periodLabel.setText(String.valueOf(com.clustercontrol.util.Messages.getString((String)"collection.period")) + " : ");
        this.periodLabel.setLayoutData((Object)labelData);
        this.limitButton = new Button(this.periodComposite, 16);
        this.limitButton.setText(String.valueOf(Messages.getString("PERIOD_SETTING")) + "  ");
        this.limitButton.setLayoutData((Object)limitRadioData);
        this.limitButton.setSelection(true);
        this.limitButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RecordSetDialog.this.dayText.setEnabled(true);
                RecordSetDialog.this.hourText.setEnabled(true);
                RecordSetDialog.this.minText.setEnabled(true);
                RecordSetDialog.this.presaveText.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dayText = new Text(this.periodComposite, 2048);
        this.dayText.addVerifyListener((VerifyListener)verifyListener);
        this.dayText.setLayoutData((Object)preiodDayTextData);
        this.dayText.setText("0   ");
        this.dayLabel = new Label(this.periodComposite, 0);
        this.dayLabel.setText(String.valueOf(Messages.getString("DAY")) + "   ");
        this.dayLabel.setLayoutData((Object)periodDayData);
        this.hourText = new Text(this.periodComposite, 2048);
        this.hourText.addVerifyListener((VerifyListener)verifyListener);
        this.hourText.setLayoutData((Object)periodHoutTextData);
        this.hourText.setText("0   ");
        this.hourLabel = new Label(this.periodComposite, 0);
        this.hourLabel.setText("  " + Messages.getString("HOUR") + "   ");
        this.hourLabel.setLayoutData((Object)periodHourData);
        this.minText = new Text(this.periodComposite, 2048);
        this.minText.addVerifyListener((VerifyListener)verifyListener);
        this.minText.setLayoutData((Object)periodMinTextData);
        this.minText.setText("10  ");
        this.minLabel = new Label(this.periodComposite, 0);
        this.minLabel.setText("  " + Messages.getString("MINUTE") + "   ");
        this.minLabel.setLayoutData((Object)periodMinData);
        this.unlimitButton = new Button(this.periodComposite, 16);
        this.unlimitButton.setText(String.valueOf(Messages.getString("UNLIMIT_COLLECT")) + "   ");
        this.unlimitButton.setLayoutData((Object)unlimitRadioData);
        this.unlimitButton.setSelection(false);
        this.unlimitButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RecordSetDialog.this.dayText.setEnabled(false);
                RecordSetDialog.this.hourText.setEnabled(false);
                RecordSetDialog.this.minText.setEnabled(false);
                RecordSetDialog.this.presaveText.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.presaveLabel = new Label(this.periodComposite, 0);
        this.presaveLabel.setText(Messages.getString("PRESAVE_PERIOD"));
        this.presaveLabel.setLayoutData((Object)presaveLabelData);
        this.presaveText = new Text(this.periodComposite, 2048);
        this.presaveText.addVerifyListener((VerifyListener)verifyListener);
        this.presaveText.setText("30  ");
        this.presaveText.setLayoutData((Object)presaveTextData);
        this.dayLabel2 = new Label(this.periodComposite, 0);
        this.dayLabel2.setText("  " + Messages.getString("DAY"));
        this.dayLabel2.setLayoutData((Object)presaveDay2Data);
        if (this.inputData != null) {
            this.setPeriod(this.inputData.getCollectorData().getPeriod());
        }
    }

    private void setPresave(int presave) {
        String prev = Integer.toString(presave);
        int i = 0;
        while (i <= 4 - prev.length()) {
            prev = String.valueOf(prev) + " ";
            ++i;
        }
        this.presaveText.setText(prev);
    }

    private int getPresave() {
        int presaveInt;
        String presave = this.presaveText.getText();
        try {
            presaveInt = Integer.parseInt(presave.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return -2;
        }
        return presaveInt;
    }

    private int getPeriod() {
        int period;
        try {
            period = Integer.parseInt(this.dayText.getText().trim()) * 24 * 60 + Integer.parseInt(this.hourText.getText().trim()) * 60 + Integer.parseInt(this.minText.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.setValidateResult(com.clustercontrol.util.Messages.getString((String)"INPUT_ERROR"), com.clustercontrol.util.Messages.getString((String)"MSG_SPECIFY_NUM_COLLECTION_PERIOD"));
            return -2;
        }
        return period;
    }

    private void setPeriod(int period) {
        if (period != -1) {
            String day = Integer.toString(period / 60 / 24);
            String hour = Integer.toString(period / 60 % 24);
            String min = Integer.toString(period % 60);
            int i = 0;
            while (i <= 4 - day.length()) {
                day = String.valueOf(day) + " ";
                ++i;
            }
            i = 0;
            while (i <= 4 - hour.length()) {
                hour = String.valueOf(hour) + " ";
                ++i;
            }
            i = 0;
            while (i <= 4 - min.length()) {
                min = String.valueOf(min) + " ";
                ++i;
            }
            this.dayText.setText(day);
            this.hourText.setText(hour);
            this.minText.setText(min);
            this.setPresave(0);
        } else {
            this.limitButton.setSelection(false);
            this.unlimitButton.setSelection(true);
            this.setPresave(this.inputData.getCollectorData().getPresavePeriod());
            this.minText.setText("0   ");
        }
    }

    public CollectorProperty getInputData() {
        return this.inputData;
    }

    private void setInputData(CollectorProperty property) {
        this.inputData = property;
    }

    protected CollectorProperty createInputData() {
        CollectorProperty info = new CollectorProperty();
        RecordCollectorData collectorData = new RecordCollectorData();
        info.setCollectorData(collectorData);
        this.validateResult = this.m_collectorBasic.createInputData(info.getCollectorData());
        if (this.validateResult != null) {
            return null;
        }
        info.getCollectorData().setCollectorType(2);
        this.validateResult = this.m_collectorRule.createInputData(info.getCollectorData());
        if (this.validateResult != null) {
            return null;
        }
        if (this.limitButton.getSelection()) {
            if (this.getPeriod() == 0) {
                this.validateResult = new ValidateResult();
                this.validateResult.setMessage(Messages.getString("MSG_SPECIFY_COLLECTION_PERIOD"));
                this.validateResult.setValid(false);
                return null;
            }
            if (this.getPeriod() == -2) {
                this.setValidateResult(Messages.getString("INPUT_ERROR"), Messages.getString("MSG_SPECIFY_NUM_COLLECTION_PERIOD"));
                return null;
            }
            info.getCollectorData().setPeriod(this.getPeriod());
            info.getCollectorData().setPresavePeriod(0);
        } else {
            if (this.getPresave() == 0) {
                this.validateResult = new ValidateResult();
                this.validateResult.setMessage(Messages.getString("SET_PRESAVE_PERIOD"));
                this.validateResult.setValid(false);
                return null;
            }
            if (this.getPresave() == -2) {
                this.setValidateResult(Messages.getString("INPUT_ERROR"), Messages.getString("MSG_SPECIFY_NUM_COLLECTION_PERIOD"));
                return null;
            }
            info.getCollectorData().setPresavePeriod(this.getPresave());
            info.getCollectorData().setPeriod(-1);
        }
        ArrayList itemList = this.itemTreeComposite.getItemList();
        if (itemList.size() == 0) {
            this.validateResult = new ValidateResult();
            this.validateResult.setValid(false);
            this.validateResult.setMessage(Messages.getString("MSG_SPECIFY_COLLECTION_ITEM"));
            return null;
        }
        info.setItemList(itemList);
        return info;
    }

    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    protected String getOkButtonText() {
        return com.clustercontrol.util.Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return com.clustercontrol.util.Messages.getString((String)"cancel");
    }

    private void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }

    public void setEnabled(boolean enabled) {
        this.m_collectorBasic.setEnabled(enabled);
        this.m_collectorRule.setEnabled(enabled);
        this.dayText.setEnabled(enabled);
        this.hourText.setEnabled(enabled);
        this.minText.setEnabled(enabled);
        this.limitButton.setEnabled(enabled);
        this.unlimitButton.setEnabled(enabled);
        this.presaveText.setEnabled(false);
        this.itemTreeComposite.setEnabled(enabled);
    }
}

