/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.repository.dialog;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.repository.composite.NodeFilterComposite;
import com.clustercontrol.repository.dialog.NodeFilterDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NodeAssignDialog
extends CommonDialog {
    private String facilityId = "";
    private NodeFilterComposite nodeList = null;
    private String[] filterItems = null;

    public NodeAssignDialog(Shell parent, String facilityId) {
        super(parent);
        this.facilityId = facilityId;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.repository.select.nodes"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        this.nodeList = new NodeFilterComposite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.nodeList.setLayoutData(gridData);
        this.nodeList.update();
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 11, Messages.getString((String)"filter"), false);
        this.getButton(11).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeFilterDialog dialog = new NodeFilterDialog(NodeAssignDialog.this.getShell());
                if (dialog.open() == 0) {
                    NodeAssignDialog.this.nodeList.update(dialog.getInputData());
                }
            }
        });
        super.createButtonsForButtonBar(parent);
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        StructuredSelection selection = (StructuredSelection)this.nodeList.getTableViewer().getSelection();
        Object[] items = selection.toArray();
        if (items == null || items.length == 0) {
            result = new ValidateResult();
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.repository.2"));
            result.setValid(false);
        } else {
            int size = items.length;
            this.filterItems = new String[size];
            int i = 0;
            while (i < size) {
                this.filterItems[i] = (String)((ArrayList)items[i]).get(0);
                ++i;
            }
        }
        return result;
    }

    public String getScopeId() {
        return this.facilityId;
    }

    public String[] getFilterItems() {
        return this.filterItems;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"assign");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }
}

