/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.about;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.about.AboutData;

public class AboutBundleGroupData
extends AboutData {
    private IBundleGroup bundleGroup;
    private URL licenseUrl;
    private URL featureImageUrl;
    private Long featureImageCrc;
    private ImageDescriptor featureImage;

    public AboutBundleGroupData(IBundleGroup bundleGroup) {
        super(bundleGroup.getProviderName(), bundleGroup.getName(), bundleGroup.getVersion(), bundleGroup.getIdentifier());
        this.bundleGroup = bundleGroup;
    }

    public IBundleGroup getBundleGroup() {
        return this.bundleGroup;
    }

    public URL getLicenseUrl() {
        if (this.licenseUrl == null) {
            this.licenseUrl = AboutBundleGroupData.getURL(this.bundleGroup.getProperty("licenseHref"));
        }
        return this.licenseUrl;
    }

    public URL getFeatureImageUrl() {
        if (this.featureImageUrl == null) {
            this.featureImageUrl = AboutBundleGroupData.getURL(this.bundleGroup.getProperty("featureImage"));
        }
        return this.featureImageUrl;
    }

    public ImageDescriptor getFeatureImage() {
        if (this.featureImage == null) {
            this.featureImage = AboutBundleGroupData.getImage(this.getFeatureImageUrl());
        }
        return this.featureImage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getFeatureImageCrc() {
        Long l;
        if (this.featureImageCrc != null) {
            return this.featureImageCrc;
        }
        URL url = this.getFeatureImageUrl();
        if (url == null) {
            return null;
        }
        InputStream in = null;
        try {
            try {
                CRC32 checksum = new CRC32();
                in = new CheckedInputStream(url.openStream(), checksum);
                byte[] sink = new byte[1024];
                while (in.read(sink) > 0) {
                }
                l = this.featureImageCrc = new Long(checksum.getValue());
                Object var5_7 = null;
                if (in == null) return l;
            }
            catch (IOException iOException) {
                Long l2 = null;
                Object var5_8 = null;
                if (in == null) return l2;
                try {
                    in.close();
                    return l2;
                }
                catch (IOException iOException2) {}
                return l2;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (in == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            in.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        in.close();
        return l;
    }

    public String getAboutText() {
        return this.bundleGroup.getProperty("aboutText");
    }
}

