/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.IThemeDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.themes.ITheme;

public class ViewsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button showTextOnPerspectiveBar;
    private Button showTraditionalStyleTabs;
    private Button enableAnimations;
    private Button editorTopButton;
    private Button editorBottomButton;
    private Button viewTopButton;
    private Button viewBottomButton;
    private Button perspLeftButton;
    private Button perspTopLeftButton;
    private Button perspTopRightButton;
    int editorAlignment;
    int viewAlignment;
    String perspBarLocation;
    static final String EDITORS_TITLE = WorkbenchMessages.ViewsPreference_editors;
    private static final String EDITORS_TOP_TITLE = WorkbenchMessages.ViewsPreference_editors_top;
    private static final String EDITORS_BOTTOM_TITLE = WorkbenchMessages.ViewsPreference_editors_bottom;
    private static final String VIEWS_TITLE = WorkbenchMessages.ViewsPreference_views;
    private static final String VIEWS_TOP_TITLE = WorkbenchMessages.ViewsPreference_views_top;
    private static final String VIEWS_BOTTOM_TITLE = WorkbenchMessages.ViewsPreference_views_bottom;
    private static final String PERSP_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar;
    private static final String PERSP_LEFT_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar_left;
    private static final String PERSP_TOP_LEFT_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar_topLeft;
    private static final String PERSP_TOP_RIGHT_TITLE = WorkbenchMessages.ViewsPreference_perspectiveBar_topRight;
    private static final String R21PRESENTATION_ID = "org.eclipse.ui.internal.r21presentationFactory";
    private static final String R30PRESENTATION_ID = "org.eclipse.ui.presentations.default";
    private Combo themeCombo;
    private Combo presentationCombo;
    private IConfigurationElement[] presentationFactories;
    private String currentPresentationFactoryId;

    private Group createButtonGroup(Composite composite, String title) {
        Group buttonComposite = new Group(composite, 0);
        buttonComposite.setText(title);
        buttonComposite.setFont(composite.getFont());
        FormLayout layout = new FormLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        buttonComposite.setLayoutData((Object)data);
        return buttonComposite;
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.views_preference_page_context");
        IPreferenceStore internalStore = PrefUtil.getInternalPreferenceStore();
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.editorAlignment = internalStore.getInt("EDITOR_TAB_POSITION");
        this.viewAlignment = internalStore.getInt("VIEW_TAB_POSITION");
        this.perspBarLocation = apiStore.getString("DOCK_PERSPECTIVE_BAR");
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(font);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createEditorTabButtonGroup(composite);
        this.createViewTabButtonGroup(composite);
        this.createPerspBarTabButtonGroup(composite);
        this.createPresentationCombo(composite);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        Label label = new Label(composite, 0);
        label.setText(WorkbenchMessages.ViewsPreference_currentTheme);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)data);
        data = new GridData(256);
        data.horizontalSpan = 2;
        this.themeCombo = new Combo(composite, 8);
        this.themeCombo.setLayoutData((Object)data);
        this.themeCombo.setFont(parent.getFont());
        this.refreshThemeCombo();
        this.createShowTextOnPerspectiveBarPref(composite);
        this.createShowTraditionalStyleTabsPref(composite);
        this.createEnableAnimationsPref(composite);
        return composite;
    }

    private void createPresentationCombo(Composite parent) {
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        Label label = new Label(parent, 0);
        label.setText(WorkbenchMessages.ViewsPreference_currentPresentation);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)data);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.presentationCombo = new Combo(parent, 8);
        this.presentationCombo.setFont(parent.getFont());
        this.presentationCombo.setLayoutData((Object)data);
        this.refreshPresentationCombo();
    }

    private void attachControls(Control leftControl, Control rightControl) {
        FormData leftData = new FormData();
        leftData.left = new FormAttachment(0, 0);
        FormData rightData = new FormData();
        rightData.left = new FormAttachment(leftControl, 5);
        leftControl.setLayoutData((Object)leftData);
        rightControl.setLayoutData((Object)rightData);
    }

    private void createEditorTabButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = this.createButtonGroup(composite, EDITORS_TITLE);
        this.editorTopButton = new Button((Composite)buttonComposite, 16);
        this.editorTopButton.setText(EDITORS_TOP_TITLE);
        this.editorTopButton.setSelection(this.editorAlignment == 128);
        this.editorTopButton.setFont(font);
        this.editorTopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.editorAlignment = 128;
            }
        });
        this.editorTopButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = EDITORS_TITLE;
            }
        });
        this.editorBottomButton = new Button((Composite)buttonComposite, 16);
        this.editorBottomButton.setText(EDITORS_BOTTOM_TITLE);
        this.editorBottomButton.setSelection(this.editorAlignment == 1024);
        this.editorBottomButton.setFont(font);
        this.editorBottomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.editorAlignment = 1024;
            }
        });
        this.attachControls((Control)this.editorTopButton, (Control)this.editorBottomButton);
    }

    private void createViewTabButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = this.createButtonGroup(composite, VIEWS_TITLE);
        buttonComposite.setFont(font);
        this.viewTopButton = new Button((Composite)buttonComposite, 16);
        this.viewTopButton.setText(VIEWS_TOP_TITLE);
        this.viewTopButton.setSelection(this.viewAlignment == 128);
        this.viewTopButton.setFont(font);
        this.viewTopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.viewAlignment = 128;
            }
        });
        this.viewBottomButton = new Button((Composite)buttonComposite, 16);
        this.viewBottomButton.setText(VIEWS_BOTTOM_TITLE);
        this.viewBottomButton.setSelection(this.viewAlignment == 1024);
        this.viewBottomButton.setFont(font);
        this.viewBottomButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.viewAlignment = 1024;
            }
        });
        this.attachControls((Control)this.viewTopButton, (Control)this.viewBottomButton);
    }

    private void createPerspBarTabButtonGroup(Composite composite) {
        Font font = composite.getFont();
        Group buttonComposite = this.createButtonGroup(composite, PERSP_TITLE);
        buttonComposite.setFont(font);
        this.perspLeftButton = new Button((Composite)buttonComposite, 16);
        this.perspLeftButton.setText(PERSP_LEFT_TITLE);
        this.perspLeftButton.setSelection("left".equals(this.perspBarLocation));
        this.perspLeftButton.setFont(font);
        this.perspLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.perspBarLocation = "left";
            }
        });
        this.perspTopLeftButton = new Button((Composite)buttonComposite, 16);
        this.perspTopLeftButton.setText(PERSP_TOP_LEFT_TITLE);
        this.perspTopLeftButton.setSelection("topLeft".equals(this.perspBarLocation));
        this.perspTopLeftButton.setFont(font);
        this.perspTopLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.perspBarLocation = "topLeft";
            }
        });
        this.perspTopRightButton = new Button((Composite)buttonComposite, 16);
        this.perspTopRightButton.setText(PERSP_TOP_RIGHT_TITLE);
        this.perspTopRightButton.setSelection("topRight".equals(this.perspBarLocation));
        this.perspTopRightButton.setFont(font);
        this.perspTopRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewsPreferencePage.this.perspBarLocation = "topRight";
            }
        });
        FormData leftData = new FormData();
        leftData.left = new FormAttachment(0, 5);
        FormData topLeftData = new FormData();
        topLeftData.left = new FormAttachment((Control)this.perspLeftButton, 5);
        FormData topRightData = new FormData();
        topRightData.left = new FormAttachment((Control)this.perspTopLeftButton, 0);
        this.perspLeftButton.setLayoutData((Object)leftData);
        this.perspTopLeftButton.setLayoutData((Object)topLeftData);
        this.perspTopRightButton.setLayoutData((Object)topRightData);
    }

    private void refreshPresentationCombo() {
        this.presentationCombo.removeAll();
        this.refreshPresentationFactories();
        int selection = -1;
        int i = 0;
        while (i < this.presentationFactories.length) {
            IConfigurationElement el = this.presentationFactories[i];
            String name = el.getAttribute("name");
            if (!this.currentPresentationFactoryId.equals(el.getAttribute("id"))) {
                this.presentationCombo.add(name);
            } else {
                selection = i;
                this.presentationCombo.add(NLS.bind((String)WorkbenchMessages.ViewsPreference_currentPresentationFormat, (Object)name));
            }
            ++i;
        }
        if (selection != -1) {
            this.presentationCombo.select(selection);
        }
    }

    private void refreshPresentationFactories() {
        this.currentPresentationFactoryId = Workbench.getInstance().getPresentationId();
        this.presentationFactories = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "presentationFactories");
        Arrays.sort(this.presentationFactories, new Comparator(){
            Collator collator = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                IConfigurationElement el1 = (IConfigurationElement)a;
                IConfigurationElement el2 = (IConfigurationElement)b;
                return this.collator.compare(el1.getAttribute("name"), el2.getAttribute("name"));
            }
        });
    }

    private void updatePresentationPreferences() {
        if (this.presentationCombo == null) {
            return;
        }
        int selection = this.presentationCombo.getSelectionIndex();
        if (selection < 0 || selection >= this.presentationFactories.length) {
            return;
        }
        IConfigurationElement element = this.presentationFactories[selection];
        String id = element.getAttribute("id");
        if (id.equals(this.currentPresentationFactoryId)) {
            return;
        }
        int really = new MessageDialog(this.getShell(), WorkbenchMessages.ViewsPreference_presentationConfirm_title, null, WorkbenchMessages.ViewsPreference_presentationConfirm_message, 3, new String[]{WorkbenchMessages.ViewsPreference_presentationConfirm_yes, WorkbenchMessages.ViewsPreference_presentationConfirm_no}, 1).open();
        if (really != 0) {
            return;
        }
        this.currentPresentationFactoryId = id;
        if (R21PRESENTATION_ID.equals(id)) {
            this.setR21Preferences();
        } else if (R30PRESENTATION_ID.equals(id)) {
            this.setR30Preferences();
        }
        PrefUtil.getAPIPreferenceStore().setValue("presentationFactoryId", id);
    }

    private void setR30Preferences() {
        IPreferenceStore internalStore = PrefUtil.getInternalPreferenceStore();
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        internalStore.setToDefault("VIEW_TAB_POSITION");
        this.viewAlignment = internalStore.getInt("VIEW_TAB_POSITION");
        this.viewTopButton.setSelection(this.viewAlignment == 128);
        this.viewBottomButton.setSelection(this.viewAlignment == 1024);
        apiStore.setToDefault("DOCK_PERSPECTIVE_BAR");
        this.perspBarLocation = apiStore.getString("DOCK_PERSPECTIVE_BAR");
        this.perspLeftButton.setSelection("left".equals(this.perspBarLocation));
        this.perspTopLeftButton.setSelection("topLeft".equals(this.perspBarLocation));
        this.perspTopRightButton.setSelection("topRight".equals(this.perspBarLocation));
        apiStore.setToDefault("SHOW_TEXT_ON_PERSPECTIVE_BAR");
        this.showTextOnPerspectiveBar.setSelection(apiStore.getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        apiStore.setToDefault("initialFastViewBarLocation");
    }

    private void setR21Preferences() {
        this.viewAlignment = 1024;
        this.viewTopButton.setSelection(false);
        this.viewBottomButton.setSelection(true);
        this.perspBarLocation = "left";
        this.perspLeftButton.setSelection(true);
        this.perspTopLeftButton.setSelection(false);
        this.perspTopRightButton.setSelection(false);
        this.showTextOnPerspectiveBar.setSelection(false);
        PrefUtil.getAPIPreferenceStore().setValue("initialFastViewBarLocation", "left");
    }

    private void refreshThemeCombo() {
        this.themeCombo.removeAll();
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        IThemeDescriptor[] descs = WorkbenchPlugin.getDefault().getThemeRegistry().getThemes();
        int selection = 0;
        String themeString = PlatformUI.getWorkbench().getThemeManager().getTheme("org.eclipse.ui.defaultTheme").getLabel();
        if (currentTheme.getId().equals("org.eclipse.ui.defaultTheme")) {
            themeString = MessageFormat.format(WorkbenchMessages.ViewsPreference_currentThemeFormat, themeString);
        }
        this.themeCombo.add(themeString);
        int i = 0;
        while (i < descs.length) {
            themeString = descs[i].getName();
            if (descs[i].getId().equals(currentTheme.getId())) {
                themeString = MessageFormat.format(WorkbenchMessages.ViewsPreference_currentThemeFormat, themeString);
                selection = i + 1;
            }
            this.themeCombo.add(themeString);
            ++i;
        }
        this.themeCombo.select(selection);
    }

    protected void createShowTextOnPerspectiveBarPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.showTextOnPerspectiveBar = new Button(composite, 32);
        this.showTextOnPerspectiveBar.setText(WorkbenchMessages.WorkbenchPreference_showTextOnPerspectiveBar);
        this.showTextOnPerspectiveBar.setFont(composite.getFont());
        this.showTextOnPerspectiveBar.setSelection(apiStore.getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        this.setButtonLayoutData(this.showTextOnPerspectiveBar);
    }

    protected void createShowTraditionalStyleTabsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.showTraditionalStyleTabs = new Button(composite, 32);
        this.showTraditionalStyleTabs.setText(WorkbenchMessages.ViewsPreference_traditionalTabs);
        this.showTraditionalStyleTabs.setFont(composite.getFont());
        this.showTraditionalStyleTabs.setSelection(apiStore.getBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        this.setButtonLayoutData(this.showTraditionalStyleTabs);
    }

    protected void createEnableAnimationsPref(Composite composite) {
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations = new Button(composite, 32);
        this.enableAnimations.setText(WorkbenchMessages.ViewsPreference_enableAnimations);
        this.enableAnimations.setFont(composite.getFont());
        this.enableAnimations.setSelection(apiStore.getBoolean("ENABLE_ANIMATIONS"));
        this.setButtonLayoutData(this.enableAnimations);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return WorkbenchPlugin.getDefault().getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.showTextOnPerspectiveBar.setSelection(apiStore.getDefaultBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
        this.showTraditionalStyleTabs.setSelection(apiStore.getDefaultBoolean("SHOW_TRADITIONAL_STYLE_TABS"));
        this.enableAnimations.setSelection(apiStore.getDefaultBoolean("ENABLE_ANIMATIONS"));
        int editorTopValue = store.getDefaultInt("EDITOR_TAB_POSITION");
        this.editorTopButton.setSelection(editorTopValue == 128);
        this.editorBottomButton.setSelection(editorTopValue == 1024);
        this.editorAlignment = editorTopValue;
        int viewTopValue = store.getDefaultInt("VIEW_TAB_POSITION");
        this.viewTopButton.setSelection(viewTopValue == 128);
        this.viewBottomButton.setSelection(viewTopValue == 1024);
        this.viewAlignment = viewTopValue;
        this.perspBarLocation = apiStore.getDefaultString("DOCK_PERSPECTIVE_BAR");
        this.perspLeftButton.setSelection("left".equals(this.perspBarLocation));
        this.perspTopLeftButton.setSelection("topLeft".equals(this.perspBarLocation));
        this.perspTopRightButton.setSelection("topRight".equals(this.perspBarLocation));
        WorkbenchPlugin.getDefault().savePluginPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        IPreferenceStore apiStore = PrefUtil.getAPIPreferenceStore();
        this.updatePresentationPreferences();
        apiStore.setValue("SHOW_TEXT_ON_PERSPECTIVE_BAR", this.showTextOnPerspectiveBar.getSelection());
        apiStore.setValue("SHOW_TRADITIONAL_STYLE_TABS", this.showTraditionalStyleTabs.getSelection());
        apiStore.setValue("ENABLE_ANIMATIONS", this.enableAnimations.getSelection());
        store.setValue("EDITOR_TAB_POSITION", this.editorAlignment);
        store.setValue("VIEW_TAB_POSITION", this.viewAlignment);
        apiStore.setValue("DOCK_PERSPECTIVE_BAR", this.perspBarLocation);
        int idx = this.themeCombo.getSelectionIndex();
        if (idx == 0) {
            Workbench.getInstance().getThemeManager().setCurrentTheme("org.eclipse.ui.defaultTheme");
        } else {
            Workbench.getInstance().getThemeManager().setCurrentTheme(WorkbenchPlugin.getDefault().getThemeRegistry().getThemes()[idx - 1].getId());
        }
        this.refreshThemeCombo();
        return true;
    }
}

