/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.factory;

import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobEndInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoData;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobNoticeInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartInfoUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoUtil;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateFileJob {
    protected static Log m_log = LogFactory.getLog(CreateFileJob.class);
    protected static final String FILE_LIST = "_FILE_LIST";
    protected static final String GET_KEY = "_GET_KEY";
    protected static final String ADD_KEY = "_ADD_KEY";
    protected static final String DEL_KEY = "_DEL_KEY";
    protected static final String GET_CHECKSUM = "_GET_CS";
    protected static final String CHECK_CHECKSUM = "_CHECK_CS";
    protected static final String FORWARD = "_FORWARD";
    protected static final int NORMAL = 0;
    protected static final int WARNING = 1;
    protected static final int ABNORMAL = -1;
    protected static final String COMMAND_SCP = "scp";

    public void createGetFileListJob(JobMasterLocal job, String sessionId) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        JobFileMasterLocal file = job.getJobFileMaster();
        String jobId = job.getJob_id() + FILE_LIST;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(sessionId, jobId, null, new Integer(0), null, null, null, null, null, new Integer(0), new Integer(0));
        JobRelationInfoUtil.getLocalHome().create(sessionId, jobId, job.getJob_id());
        JobInfoUtil.getLocalHome().create(sessionId, jobId, "", "", new Integer(2), job.getReg_date(), job.getUpdate_date(), job.getReg_user(), job.getUpdate_user());
        JobStartInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(-1), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        JobCommandInfoUtil.getLocalHome().create(sessionId, jobId, file.getSrc_facility_id(), new Integer(0), "getFileList", "", file.getEffective_user(), new Integer(1), new Integer(-1), null, file.getSrc_file());
        sessionJob.setScope_text(repository.getFacilityPath(file.getSrc_facility_id(), null));
        ArrayList<String> Attribute2 = new ArrayList<String>();
        Attribute2.add("cn");
        HashMap map = repository.getNodeDetail(file.getSrc_facility_id(), Attribute2);
        JobSessionNodeUtil.getLocalHome().create(sessionId, jobId, file.getSrc_facility_id(), (String)map.get("cn"), new Integer(0), null, null, null, null, null, null, new Integer(0), null, null);
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 3, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 0, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 1, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 2, new Integer(0), "");
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(1), new Integer(1), new Integer(1), new Integer(1));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(2), new Integer(-1), new Integer(-1), new Integer(-1));
    }

    public void createFileJobNet(String sessionId, String jobId, List<String> fileList) throws FinderException, NamingException {
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
        JobRelationInfoLocal relation = sessionJob.getJobRelationInfo();
        String parentJobId = relation.getParent_job_id();
        JobSessionJobLocal parentSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, parentJobId));
        JobInfoLocal job = parentSessionJob.getJobInfo();
        JobFileInfoLocal file = job.getJobFileInfo();
        JobFileInfoData fileData = file.getJobFileInfoData();
        file = null;
        job = null;
        parentSessionJob = null;
        relation = null;
        sessionJob = null;
        InitialContext context = new InitialContext();
        TransactionManager tm = (TransactionManager)context.lookup("java:/TransactionManager");
        try {
            Transaction tx = null;
            Transaction oldtx = null;
            if (tm.getTransaction() != null) {
                oldtx = tm.suspend();
            }
            tm.begin();
            tx = tm.getTransaction();
            try {
                this.createNodeJobNet(sessionId, parentJobId, jobId, fileData, fileList);
            }
            catch (Exception e) {
                tx.rollback();
            }
            tx.commit();
            if (oldtx != null) {
                tm.resume(oldtx);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void createNodeJobNet(String sessionId, String parentJobId, String waitJobId, JobFileInfoData file, List<String> fileList) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        ArrayList nodeIdList = null;
        if (repository.isNode(file.getDest_facility_id())) {
            nodeIdList = new ArrayList();
            nodeIdList.add(file.getDest_facility_id());
        } else {
            nodeIdList = repository.getNodeFacilityIdList(file.getDest_facility_id(), 0);
        }
        for (int i = 0; i < nodeIdList.size(); ++i) {
            String nodeJobId = parentJobId + "_" + (String)nodeIdList.get(i);
            JobSessionJobLocal nodeSessionJob = JobSessionJobUtil.getLocalHome().create(sessionId, nodeJobId, null, new Integer(0), null, null, null, null, null, new Integer(1), new Integer(0));
            JobRelationInfoUtil.getLocalHome().create(sessionId, nodeJobId, parentJobId);
            JobInfoUtil.getLocalHome().create(sessionId, nodeJobId, (String)nodeIdList.get(i), "", new Integer(1), new Date(), new Date(), "", "");
            if (file.getProcess_mode() == 0) {
                if (i == 0) {
                    JobStartInfoUtil.getLocalHome().create(sessionId, nodeJobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(-1), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
                    JobStartJobInfoUtil.getLocalHome().create(sessionId, nodeJobId, waitJobId, new Integer(0), new Integer(0));
                } else {
                    JobStartInfoUtil.getLocalHome().create(sessionId, nodeJobId, new Integer(1), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(0), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
                    JobStartJobInfoUtil.getLocalHome().create(sessionId, nodeJobId, waitJobId, new Integer(0), new Integer(0));
                    JobStartJobInfoUtil.getLocalHome().create(sessionId, nodeJobId, waitJobId, new Integer(0), new Integer(1));
                    JobStartJobInfoUtil.getLocalHome().create(sessionId, nodeJobId, waitJobId, new Integer(0), new Integer(2));
                }
            } else if (i == 0) {
                JobStartInfoUtil.getLocalHome().create(sessionId, nodeJobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(-1), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
                JobStartJobInfoUtil.getLocalHome().create(sessionId, nodeJobId, waitJobId, new Integer(0), new Integer(0));
            } else {
                JobStartInfoUtil.getLocalHome().create(sessionId, nodeJobId, new Integer(1), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(0), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
                JobStartJobInfoUtil.getLocalHome().create(sessionId, nodeJobId, waitJobId, new Integer(0), new Integer(1));
                JobStartJobInfoUtil.getLocalHome().create(sessionId, nodeJobId, waitJobId, new Integer(0), new Integer(2));
            }
            nodeSessionJob.setScope_text(repository.getFacilityPath((String)nodeIdList.get(i), null));
            JobNoticeInfoUtil.getLocalHome().create(sessionId, nodeJobId, 3, new Integer(0), "");
            JobNoticeInfoUtil.getLocalHome().create(sessionId, nodeJobId, 0, new Integer(0), "");
            JobNoticeInfoUtil.getLocalHome().create(sessionId, nodeJobId, 1, new Integer(0), "");
            JobNoticeInfoUtil.getLocalHome().create(sessionId, nodeJobId, 2, new Integer(0), "");
            JobEndInfoUtil.getLocalHome().create(sessionId, nodeJobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0));
            JobEndInfoUtil.getLocalHome().create(sessionId, nodeJobId, new Integer(1), new Integer(1), new Integer(1), new Integer(1));
            JobEndInfoUtil.getLocalHome().create(sessionId, nodeJobId, new Integer(2), new Integer(9), new Integer(-1), new Integer(-1));
            this.createForwardFileJobNet(sessionId, nodeJobId, (String)nodeIdList.get(i), file, fileList);
            if (file.getProcess_mode() != 1) continue;
            waitJobId = nodeJobId;
        }
    }

    protected void createForwardFileJobNet(String sessionId, String parentJobId, String destFacilityId, JobFileInfoData fileInfo, List<String> fileList) throws CreateException, FinderException, NamingException {
        String getKeyJobId = this.createGetKeyJob(sessionId, parentJobId, null, destFacilityId, fileInfo);
        String waitJobId = this.createAddKeyJob(sessionId, parentJobId, getKeyJobId, getKeyJobId, fileInfo);
        for (int i = 0; i < fileList.size(); ++i) {
            String getCheckSumJobId = null;
            if (fileInfo.getCheck_flg() == 1) {
                getCheckSumJobId = waitJobId = this.createGetCheckSumJob(sessionId, parentJobId, waitJobId, fileList.get(i), String.valueOf(i + 1), fileInfo);
            }
            waitJobId = this.createForwardFileJob(sessionId, parentJobId, waitJobId, destFacilityId, fileList.get(i), String.valueOf(i + 1), fileInfo);
            if (fileInfo.getCheck_flg() != 1) continue;
            waitJobId = this.createCheckCheckSumJob(sessionId, parentJobId, waitJobId, destFacilityId, getCheckSumJobId, fileList.get(i), String.valueOf(i + 1), fileInfo);
        }
        this.createDeleteKeyJob(sessionId, parentJobId, waitJobId, getKeyJobId, fileInfo);
    }

    protected String createForwardFileJob(String sessionId, String parentJobId, String waitJobId, String destFacilityId, String filePath, String idCount, JobFileInfoData fileInfo) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        String jobId = parentJobId + "_" + idCount + FORWARD;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(sessionId, jobId, null, new Integer(0), null, null, null, null, null, new Integer(0), new Integer(0));
        JobRelationInfoUtil.getLocalHome().create(sessionId, jobId, parentJobId);
        JobInfoUtil.getLocalHome().create(sessionId, jobId, "", "", new Integer(2), new Date(), new Date(), "", "");
        JobStartInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(1), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(-1), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        if (fileInfo.getCheck_flg() == 1) {
            JobStartJobInfoUtil.getLocalHome().create(sessionId, jobId, waitJobId, new Integer(0), new Integer(0));
        } else {
            JobStartJobInfoUtil.getLocalHome().create(sessionId, jobId, waitJobId, new Integer(0), new Integer(0));
        }
        ArrayList<String> Attribute2 = new ArrayList<String>();
        Attribute2.add("ipNetworkNumber");
        HashMap map = repository.getNodeDetail(fileInfo.getSrc_facility_id(), Attribute2);
        StringBuilder command = new StringBuilder();
        command.append(COMMAND_SCP);
        command.append(" ");
        if (fileInfo.getCompression_flg() == 1) {
            command.append("-C ");
        }
        command.append(map.get("ipNetworkNumber"));
        command.append(":");
        command.append(filePath);
        command.append(" ");
        command.append(fileInfo.getDest_directory());
        JobCommandInfoUtil.getLocalHome().create(sessionId, jobId, destFacilityId, new Integer(0), command.toString(), "", fileInfo.getEffective_user(), new Integer(1), new Integer(-1), null, filePath);
        sessionJob.setScope_text(repository.getFacilityPath(destFacilityId, null));
        Attribute2.add("cn");
        map = repository.getNodeDetail(destFacilityId, Attribute2);
        JobSessionNodeUtil.getLocalHome().create(sessionId, jobId, destFacilityId, (String)map.get("cn"), new Integer(0), null, null, null, null, null, null, new Integer(0), null, null);
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 3, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 0, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 1, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 2, new Integer(0), "");
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(1), new Integer(1), new Integer(0), new Integer(0));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(2), new Integer(-1), new Integer(-1), new Integer(-1));
        return jobId;
    }

    protected String createGetCheckSumJob(String sessionId, String parentJobId, String waitJobId, String filePath, String idCount, JobFileInfoData fileInfo) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        String jobId = parentJobId + "_" + idCount + GET_CHECKSUM;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(sessionId, jobId, null, new Integer(0), null, null, null, null, null, new Integer(0), new Integer(0));
        JobRelationInfoUtil.getLocalHome().create(sessionId, jobId, parentJobId);
        JobInfoUtil.getLocalHome().create(sessionId, jobId, "", "", new Integer(2), new Date(), new Date(), "", "");
        JobStartInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(1), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(-1), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        JobStartJobInfoUtil.getLocalHome().create(sessionId, jobId, waitJobId, new Integer(0), new Integer(0));
        JobCommandInfoUtil.getLocalHome().create(sessionId, jobId, fileInfo.getSrc_facility_id(), new Integer(0), "getCheckSum", "", fileInfo.getEffective_user(), new Integer(1), new Integer(-1), null, filePath);
        sessionJob.setScope_text(repository.getFacilityPath(fileInfo.getSrc_facility_id(), null));
        ArrayList<String> Attribute2 = new ArrayList<String>();
        Attribute2.add("cn");
        HashMap map = repository.getNodeDetail(fileInfo.getSrc_facility_id(), Attribute2);
        JobSessionNodeUtil.getLocalHome().create(sessionId, jobId, fileInfo.getSrc_facility_id(), (String)map.get("cn"), new Integer(0), null, null, null, null, null, null, new Integer(0), null, null);
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 3, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 0, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 1, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 2, new Integer(0), "");
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(1), new Integer(1), new Integer(1), new Integer(1));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(2), new Integer(-1), new Integer(-1), new Integer(-1));
        return jobId;
    }

    protected String createCheckCheckSumJob(String sessionId, String parentJobId, String waitJobId, String destFacilityId, String argumentJobId, String filePath, String idCount, JobFileInfoData fileInfo) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        String jobId = parentJobId + "_" + idCount + CHECK_CHECKSUM;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(sessionId, jobId, null, new Integer(0), null, null, null, null, null, new Integer(0), new Integer(0));
        JobRelationInfoUtil.getLocalHome().create(sessionId, jobId, parentJobId);
        JobInfoUtil.getLocalHome().create(sessionId, jobId, "", "", new Integer(2), new Date(), new Date(), "", "");
        JobStartInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(-1), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        JobStartJobInfoUtil.getLocalHome().create(sessionId, jobId, waitJobId, new Integer(0), new Integer(0));
        int index = filePath.lastIndexOf("/");
        String fileName = null;
        Pattern p = Pattern.compile(".*/");
        Matcher m = p.matcher(fileInfo.getDest_directory());
        fileName = m.matches() ? fileInfo.getDest_directory() + filePath.substring(index + 1) : fileInfo.getDest_directory() + "/" + filePath.substring(index + 1);
        JobCommandInfoUtil.getLocalHome().create(sessionId, jobId, destFacilityId, new Integer(0), "checkCheckSum", "", fileInfo.getEffective_user(), new Integer(1), new Integer(-1), argumentJobId, fileName);
        sessionJob.setScope_text(repository.getFacilityPath(destFacilityId, null));
        ArrayList<String> Attribute2 = new ArrayList<String>();
        Attribute2.add("cn");
        HashMap map = repository.getNodeDetail(destFacilityId, Attribute2);
        JobSessionNodeUtil.getLocalHome().create(sessionId, jobId, destFacilityId, (String)map.get("cn"), new Integer(0), null, null, null, null, null, null, new Integer(0), null, null);
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 3, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 0, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 1, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 2, new Integer(0), "");
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(1), new Integer(1), new Integer(1), new Integer(1));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(2), new Integer(-1), new Integer(-1), new Integer(-1));
        return jobId;
    }

    protected String createGetKeyJob(String sessionId, String parentJobId, String waitJobId, String destFacilityId, JobFileInfoData fileInfo) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        String jobId = parentJobId + GET_KEY;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(sessionId, jobId, null, new Integer(0), null, null, null, null, null, new Integer(0), new Integer(0));
        JobRelationInfoUtil.getLocalHome().create(sessionId, jobId, parentJobId);
        JobInfoUtil.getLocalHome().create(sessionId, jobId, "", "", new Integer(2), new Date(), new Date(), "", "");
        JobStartInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(-1), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        if (waitJobId != null && waitJobId.length() > 0) {
            JobStartJobInfoUtil.getLocalHome().create(sessionId, jobId, waitJobId, new Integer(0), new Integer(0));
        }
        JobCommandInfoUtil.getLocalHome().create(sessionId, jobId, destFacilityId, new Integer(0), "getPublicKey", "", fileInfo.getEffective_user(), new Integer(1), new Integer(-1), null, null);
        sessionJob.setScope_text(repository.getFacilityPath(destFacilityId, null));
        ArrayList<String> Attribute2 = new ArrayList<String>();
        Attribute2.add("cn");
        HashMap map = repository.getNodeDetail(destFacilityId, Attribute2);
        JobSessionNodeUtil.getLocalHome().create(sessionId, jobId, destFacilityId, (String)map.get("cn"), new Integer(0), null, null, null, null, null, null, new Integer(0), null, null);
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 3, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 0, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 1, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 2, new Integer(0), "");
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(1), new Integer(1), new Integer(1), new Integer(1));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(2), new Integer(-1), new Integer(-1), new Integer(-1));
        return jobId;
    }

    protected String createAddKeyJob(String sessionId, String parentJobId, String waitJobId, String argumentJobId, JobFileInfoData fileInfo) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        String jobId = parentJobId + ADD_KEY;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(sessionId, jobId, null, new Integer(0), null, null, null, null, null, new Integer(0), new Integer(0));
        JobRelationInfoUtil.getLocalHome().create(sessionId, jobId, parentJobId);
        JobInfoUtil.getLocalHome().create(sessionId, jobId, "", "", new Integer(2), new Date(), new Date(), "", "");
        JobStartInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(-1), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        if (waitJobId != null && waitJobId.length() > 0) {
            JobStartJobInfoUtil.getLocalHome().create(sessionId, jobId, waitJobId, new Integer(0), new Integer(0));
        }
        JobCommandInfoUtil.getLocalHome().create(sessionId, jobId, fileInfo.getSrc_facility_id(), new Integer(0), "addPublicKey", "", fileInfo.getEffective_user(), new Integer(1), new Integer(-1), argumentJobId, null);
        sessionJob.setScope_text(repository.getFacilityPath(fileInfo.getSrc_facility_id(), null));
        ArrayList<String> Attribute2 = new ArrayList<String>();
        Attribute2.add("cn");
        HashMap map = repository.getNodeDetail(fileInfo.getSrc_facility_id(), Attribute2);
        JobSessionNodeUtil.getLocalHome().create(sessionId, jobId, fileInfo.getSrc_facility_id(), (String)map.get("cn"), new Integer(0), null, null, null, null, null, null, new Integer(0), null, null);
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 3, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 0, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 1, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 2, new Integer(0), "");
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(1), new Integer(1), new Integer(1), new Integer(1));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(2), new Integer(-1), new Integer(-1), new Integer(-1));
        return jobId;
    }

    protected String createDeleteKeyJob(String sessionId, String parentJobId, String waitJobId, String argumentJobId, JobFileInfoData fileInfo) throws CreateException, FinderException, NamingException {
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        String jobId = parentJobId + DEL_KEY;
        JobSessionJobLocal sessionJob = JobSessionJobUtil.getLocalHome().create(sessionId, jobId, null, new Integer(0), null, null, null, null, null, new Integer(0), new Integer(0));
        JobRelationInfoUtil.getLocalHome().create(sessionId, jobId, parentJobId);
        JobInfoUtil.getLocalHome().create(sessionId, jobId, "", "", new Integer(2), new Date(), new Date(), "", "");
        JobStartInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(1), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(-1), new Integer(0), "", new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(4), new Integer(0), new Integer(0), new Integer(0), new Integer(1), new Integer(0), new Integer(1), new Integer(0), null, new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
        if (waitJobId != null && waitJobId.length() > 0) {
            JobStartJobInfoUtil.getLocalHome().create(sessionId, jobId, waitJobId, new Integer(0), new Integer(0));
            JobStartJobInfoUtil.getLocalHome().create(sessionId, jobId, waitJobId, new Integer(0), new Integer(1));
            JobStartJobInfoUtil.getLocalHome().create(sessionId, jobId, waitJobId, new Integer(0), new Integer(2));
        }
        JobCommandInfoUtil.getLocalHome().create(sessionId, jobId, fileInfo.getSrc_facility_id(), new Integer(0), "deletePublicKey", "", fileInfo.getEffective_user(), new Integer(1), new Integer(-1), argumentJobId, null);
        sessionJob.setScope_text(repository.getFacilityPath(fileInfo.getSrc_facility_id(), null));
        ArrayList<String> Attribute2 = new ArrayList<String>();
        Attribute2.add("cn");
        HashMap map = repository.getNodeDetail(fileInfo.getSrc_facility_id(), Attribute2);
        JobSessionNodeUtil.getLocalHome().create(sessionId, jobId, fileInfo.getSrc_facility_id(), (String)map.get("cn"), new Integer(0), null, null, null, null, null, null, new Integer(0), null, null);
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 3, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 0, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 1, new Integer(0), "");
        JobNoticeInfoUtil.getLocalHome().create(sessionId, jobId, 2, new Integer(0), "");
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(0), new Integer(0), new Integer(-1), new Integer(1));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(1), new Integer(1), new Integer(1), new Integer(1));
        JobEndInfoUtil.getLocalHome().create(sessionId, jobId, new Integer(2), new Integer(-1), new Integer(-1), new Integer(-1));
        return jobId;
    }
}

