/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.LayoutComposite;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.internal.forms.widgets.FormsResources;

public class Form
extends Composite {
    private int TITLE_HMARGIN = 10;
    private int TITLE_VMARGIN = 5;
    private int TITLE_GAP = 5;
    private Image backgroundImage;
    private boolean backgroundImageTiled;
    private boolean backgroundImageClipped = true;
    private int backgroundImageAlignment = 16384;
    private GradientInfo gradientInfo;
    private String text;
    private Composite body;
    private ToolBarManager toolBarManager;
    private SizeCache bodyCache = new SizeCache();
    private SizeCache toolbarCache = new SizeCache();
    private FormText selectionText;
    private Rectangle titleRect;

    public Form(Composite parent, int style) {
        super(parent, 0x40000 | style);
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Form.this.onPaint(e.gc);
            }
        });
        super.setLayout((Layout)new FormLayout());
        this.body = new LayoutComposite(this, 0);
        this.body.setMenu(parent.getMenu());
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.body.setMenu(menu);
    }

    public final Point computeSize(int wHint, int hHint, boolean changed) {
        return ((FormLayout)this.getLayout()).computeSize(this, wHint, hHint, changed);
    }

    public final void setLayout(Layout layout) {
    }

    public String getText() {
        return this.text;
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.body.setForeground(fg);
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.body.setBackground(bg);
        if (this.toolBarManager != null) {
            this.toolBarManager.getControl().setBackground(bg);
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.toolBarManager != null) {
            this.toolBarManager.getControl().setVisible(text != null);
        }
        this.layout();
        this.redraw();
    }

    public void setTextBackground(Color[] gradientColors, int[] percents, boolean vertical) {
        this.gradientInfo = new GradientInfo();
        this.gradientInfo.gradientColors = gradientColors;
        this.gradientInfo.percents = percents;
        this.gradientInfo.vertical = vertical;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image backgroundImage) {
        this.backgroundImage = backgroundImage;
        this.redraw();
    }

    public IToolBarManager getToolBarManager() {
        if (this.toolBarManager == null) {
            this.toolBarManager = new ToolBarManager(0x800000);
            ToolBar toolbar = this.toolBarManager.createControl((Composite)this);
            toolbar.setBackground(this.getBackground());
            toolbar.setForeground(this.getForeground());
            toolbar.setCursor(FormsResources.getHandCursor());
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (Form.this.toolBarManager != null) {
                        Form.this.toolBarManager.dispose();
                        Form.this.toolBarManager = null;
                    }
                }
            });
        }
        return this.toolBarManager;
    }

    public void updateToolBar() {
        if (this.toolBarManager != null) {
            this.toolBarManager.update(false);
        }
    }

    public Composite getBody() {
        return this.body;
    }

    private void onPaint(GC gc) {
        ToolBar toolBar;
        if (this.text == null) {
            return;
        }
        Rectangle carea = this.getClientArea();
        gc.setFont(this.getFont());
        int theight = 0;
        theight = this.TITLE_VMARGIN + this.titleRect.height + this.TITLE_VMARGIN;
        if (this.toolBarManager != null && (toolBar = this.toolBarManager.getControl()) != null) {
            Point tbsize = toolBar.getSize();
            theight = Math.max(theight, tbsize.y);
        }
        if (this.backgroundImage != null && !this.backgroundImageClipped) {
            theight = Math.max(theight, this.backgroundImage.getBounds().height);
        }
        Image buffer = new Image((Device)this.getDisplay(), carea.width, theight);
        GC bufferGC = new GC((Drawable)buffer, gc.getStyle());
        bufferGC.setBackground(this.getBackground());
        bufferGC.setForeground(this.getForeground());
        bufferGC.setFont(this.getFont());
        bufferGC.fillRectangle(0, 0, carea.width, theight);
        if (this.backgroundImage != null) {
            this.drawBackgroundImage(bufferGC, carea.width, this.TITLE_VMARGIN + this.titleRect.height + this.TITLE_VMARGIN);
        } else if (this.gradientInfo != null) {
            this.drawTextGradient(bufferGC, carea.width, this.TITLE_VMARGIN + this.titleRect.height + this.TITLE_VMARGIN);
        }
        FormUtil.paintWrapText(bufferGC, this.text, this.titleRect);
        gc.drawImage(buffer, 0, 0);
        bufferGC.dispose();
        buffer.dispose();
    }

    private void drawBackgroundImage(GC gc, int width, int height) {
        Rectangle ibounds = this.backgroundImage.getBounds();
        if (this.backgroundImageTiled) {
            int x = 0;
            int y = 0;
            while (true) {
                gc.drawImage(this.backgroundImage, x, y);
                if ((x += ibounds.width) <= width) continue;
                x = 0;
                if ((y += ibounds.height) > height) break;
            }
        } else {
            switch (this.backgroundImageAlignment) {
                case 16384: {
                    gc.drawImage(this.backgroundImage, 0, 0);
                    break;
                }
                case 131072: {
                    gc.drawImage(this.backgroundImage, width - ibounds.width, 0);
                }
            }
        }
    }

    private void drawTextGradient(GC gc, int width, int height) {
        Color oldBackground = gc.getBackground();
        if (this.gradientInfo.gradientColors.length == 1) {
            if (this.gradientInfo.gradientColors[0] != null) {
                gc.setBackground(this.gradientInfo.gradientColors[0]);
            }
            gc.fillRectangle(0, 0, width, height);
        } else {
            Color oldForeground = gc.getForeground();
            Color lastColor = this.gradientInfo.gradientColors[0];
            if (lastColor == null) {
                lastColor = oldBackground;
            }
            int pos = 0;
            int i = 0;
            while (i < this.gradientInfo.percents.length) {
                gc.setForeground(lastColor);
                lastColor = this.gradientInfo.gradientColors[i + 1];
                if (lastColor == null) {
                    lastColor = oldBackground;
                }
                gc.setBackground(lastColor);
                if (this.gradientInfo.vertical) {
                    int gradientHeight = this.gradientInfo.percents[i] * height / 100 - pos;
                    gc.fillGradientRectangle(0, pos, width, gradientHeight, true);
                    pos += gradientHeight;
                } else {
                    int gradientWidth = this.gradientInfo.percents[i] * width / 100 - pos;
                    gc.fillGradientRectangle(pos, 0, gradientWidth, height, false);
                    pos += gradientWidth;
                }
                ++i;
            }
            if (this.gradientInfo.vertical && pos < height) {
                gc.setBackground(this.getBackground());
                gc.fillRectangle(0, pos, width, height - pos);
            }
            if (!this.gradientInfo.vertical && pos < width) {
                gc.setBackground(this.getBackground());
                gc.fillRectangle(pos, 0, width - pos, height);
            }
            gc.setForeground(oldForeground);
        }
    }

    public boolean isBackgroundImageTiled() {
        return this.backgroundImageTiled;
    }

    public void setBackgroundImageTiled(boolean backgroundImageTiled) {
        this.backgroundImageTiled = backgroundImageTiled;
        if (this.isVisible()) {
            this.redraw();
        }
    }

    public int getBackgroundImageAlignment() {
        return this.backgroundImageAlignment;
    }

    public void setBackgroundImageAlignment(int backgroundImageAlignment) {
        this.backgroundImageAlignment = backgroundImageAlignment;
        if (this.isVisible()) {
            this.redraw();
        }
    }

    public boolean isBackgroundImageClipped() {
        return this.backgroundImageClipped;
    }

    public void setBackgroundImageClipped(boolean backgroundImageClipped) {
        this.backgroundImageClipped = backgroundImageClipped;
    }

    void setSelectionText(FormText text) {
        if (this.selectionText != null && this.selectionText != text) {
            this.selectionText.clearSelection();
        }
        this.selectionText = text;
    }

    private class GradientInfo {
        Color[] gradientColors;
        int[] percents;
        boolean vertical;

        GradientInfo() {
        }
    }

    private class FormLayout
    extends Layout
    implements ILayoutExtension {
        FormLayout() {
        }

        public int computeMinimumWidth(Composite composite, boolean flushCache) {
            return this.computeSize((Composite)composite, (int)5, (int)-1, (boolean)flushCache).x;
        }

        public int computeMaximumWidth(Composite composite, boolean flushCache) {
            return this.computeSize((Composite)composite, (int)-1, (int)-1, (boolean)flushCache).x;
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int ihHint;
            ToolBar toolBar;
            if (flushCache) {
                Form.this.bodyCache.flush();
                Form.this.toolbarCache.flush();
            }
            Form.this.bodyCache.setControl((Control)Form.this.body);
            int width = 0;
            int height = 0;
            if (Form.this.toolBarManager != null && (toolBar = Form.this.toolBarManager.getControl()) != null) {
                Form.this.toolbarCache.setControl((Control)toolBar);
                Point tbsize = Form.this.toolbarCache.computeSize(-1, -1);
                if (Form.this.text != null) {
                    width += Form.this.TITLE_GAP;
                }
                width += tbsize.x;
                height = tbsize.y;
            }
            if (Form.this.text != null) {
                GC gc = new GC((Drawable)composite);
                gc.setFont(Form.this.getFont());
                if (wHint != -1) {
                    int twHint = wHint - width;
                    Point wsize = FormUtil.computeWrapSize(gc, Form.this.text, twHint);
                    width += wsize.x;
                    height = Math.max(wsize.y, height);
                } else {
                    Point extent = gc.textExtent(Form.this.text);
                    width += extent.x;
                    height = Math.max(extent.y, height);
                }
                gc.dispose();
            }
            if (Form.this.backgroundImage != null && !Form.this.backgroundImageClipped) {
                Rectangle ibounds = Form.this.backgroundImage.getBounds();
                if (height < ibounds.height) {
                    height = ibounds.height;
                }
            }
            if (height != 0) {
                height += Form.this.TITLE_VMARGIN * 2;
            }
            if (width != 0) {
                width += Form.this.TITLE_HMARGIN * 2;
            }
            if ((ihHint = hHint) > 0 && ihHint != -1) {
                ihHint -= height;
            }
            Point bsize = Form.this.bodyCache.computeSize(FormUtil.getWidthHint(wHint, (Control)Form.this.body), FormUtil.getHeightHint(ihHint, (Control)Form.this.body));
            width = Math.max(bsize.x, width);
            return new Point(width, height += bsize.y);
        }

        protected void layout(Composite composite, boolean flushCache) {
            ToolBar toolBar;
            if (flushCache) {
                Form.this.bodyCache.flush();
                Form.this.toolbarCache.flush();
            }
            Form.this.bodyCache.setControl((Control)Form.this.body);
            Rectangle carea = composite.getClientArea();
            int height = 0;
            Point tbsize = null;
            int twidth = carea.width - Form.this.TITLE_HMARGIN * 2;
            if (Form.this.text != null && Form.this.toolBarManager != null && (toolBar = Form.this.toolBarManager.getControl()) != null) {
                Form.this.toolbarCache.setControl((Control)toolBar);
                tbsize = Form.this.toolbarCache.computeSize(-1, -1);
                Form.this.toolbarCache.setBounds(carea.width - 1 - Form.this.TITLE_HMARGIN - tbsize.x, Form.this.TITLE_VMARGIN, tbsize.x, tbsize.y);
                height = tbsize.y;
            }
            if (tbsize != null) {
                twidth -= tbsize.x + Form.this.TITLE_GAP;
            }
            if (Form.this.text != null) {
                GC gc = new GC((Drawable)composite);
                gc.setFont(Form.this.getFont());
                height = FormUtil.computeWrapSize((GC)gc, (String)((Form)Form.this).text, (int)twidth).y;
                gc.dispose();
                if (tbsize != null) {
                    height = Math.max(tbsize.y, height);
                }
                Form.this.titleRect = new Rectangle(Form.this.TITLE_HMARGIN, Form.this.TITLE_VMARGIN, twidth, height);
            }
            if (Form.this.backgroundImage != null && !Form.this.backgroundImageClipped) {
                Rectangle ibounds = Form.this.backgroundImage.getBounds();
                if (height < ibounds.height) {
                    height = ibounds.height;
                }
            }
            if (height > 0) {
                height += Form.this.TITLE_VMARGIN * 2;
            }
            Form.this.bodyCache.setBounds(0, height, carea.width, carea.height - height);
        }
    }
}

