/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.composite;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.snmptrap.action.GetMaster;
import com.clustercontrol.snmptrap.action.GetMasterTableDefine;
import com.clustercontrol.snmptrap.bean.MonitorSnmpTrapOidInfo;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterListComposite
extends Composite {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private CommonTableViewer tableViewer = null;
    private ArrayList<SnmpTrapMasterInfo> masterList = null;
    private ArrayList<MonitorSnmpTrapOidInfo> oidList = null;
    private Combo comboMib = null;
    private Text textFilter = null;
    private Button buttonClearFilter = null;
    private Button buttonShowTable = null;

    public MasterListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        Label label = null;
        Group groupFilter = new Group((Composite)this, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupFilter.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupFilter.setLayoutData((Object)gridData);
        groupFilter.setText(String.valueOf(Messages.getString((String)"filter")) + " : ");
        label = new Label((Composite)groupFilter, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"mib")) + " : ");
        this.comboMib = new Combo((Composite)groupFilter, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboMib.setLayoutData((Object)gridData);
        this.comboMib.setVisibleItemCount(10);
        ArrayList mibList = new GetMaster().getMibList();
        int i = 0;
        while (i < mibList.size()) {
            this.comboMib.add((String)mibList.get(i));
            ++i;
        }
        this.comboMib.select(0);
        this.comboMib.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MasterListComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = new Label((Composite)groupFilter, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupFilter, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"trap.name")) + " : ");
        this.textFilter = new Text((Composite)groupFilter, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textFilter.setLayoutData((Object)gridData);
        this.buttonClearFilter = new Button((Composite)groupFilter, 0);
        this.buttonClearFilter.setText(Messages.getString((String)"clear"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonClearFilter.setLayoutData((Object)gridData);
        this.buttonClearFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MasterListComposite.this.textFilter.setText("");
            }
        });
        this.buttonShowTable = new Button((Composite)groupFilter, 0);
        this.buttonShowTable.setText(Messages.getString((String)"show"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.buttonShowTable.setLayoutData((Object)gridData);
        this.buttonShowTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MasterListComposite.this.update();
            }
        });
        Table table = new Table((Composite)this, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.minimumHeight = 200;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetMasterTableDefine.get(), 1, 1);
        this.update();
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void update() {
        this.masterList = new GetMaster().getMasterList(this.comboMib.getText());
        ArrayList list = this.collectionToArray(this.masterList);
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean select = true;
                ArrayList info = (ArrayList)element;
                String mib = (String)info.get(0);
                String trapName = (String)info.get(1);
                if (MasterListComposite.this.oidList != null) {
                    String trapOid = (String)info.get(2);
                    Integer genericId = (Integer)info.get(3);
                    Integer specificId = (Integer)info.get(4);
                    int i = 0;
                    while (i < MasterListComposite.this.oidList.size()) {
                        MonitorSnmpTrapOidInfo oidInfo = (MonitorSnmpTrapOidInfo)MasterListComposite.this.oidList.get(i);
                        if (mib.equals(oidInfo.getMib()) && trapOid.equals(oidInfo.getTrapOid()) && genericId.equals(oidInfo.getGenericId()) && specificId.equals(oidInfo.getSpecificId())) {
                            select = false;
                        }
                        ++i;
                    }
                }
                if (!MasterListComposite.this.comboMib.getText().equals("") && !mib.equals(MasterListComposite.this.comboMib.getText())) {
                    select = false;
                }
                if (!MasterListComposite.this.textFilter.getText().equals("") && !trapName.matches(MasterListComposite.this.textFilter.getText())) {
                    select = false;
                }
                return select;
            }
        });
        this.tableViewer.setInput((Object)list);
    }

    public ArrayList<SnmpTrapMasterInfo> getSelectMaster() {
        ArrayList<SnmpTrapMasterInfo> data = new ArrayList<SnmpTrapMasterInfo>();
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        List list = selection.toList();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                ArrayList info = (ArrayList)list.get(index);
                if (info != null && info.size() > 0) {
                    String mib = (String)info.get(0);
                    String oid = (String)info.get(2);
                    Integer genericId = (Integer)info.get(3);
                    Integer specificId = (Integer)info.get(4);
                    if (this.masterList != null) {
                        int i = 0;
                        while (i < this.masterList.size()) {
                            SnmpTrapMasterInfo master = this.masterList.get(i);
                            if (mib.equals(master.getMib()) && oid.equals(master.getTrapOid()) && genericId.equals(master.getGenericId()) && specificId.equals(master.getSpecificId())) {
                                data.add(master);
                                break;
                            }
                            ++i;
                        }
                    }
                }
                ++index;
            }
        }
        return data;
    }

    public ArrayList collectionToArray(ArrayList<SnmpTrapMasterInfo> masterList) {
        ArrayList list = new ArrayList();
        if (masterList != null) {
            for (SnmpTrapMasterInfo master : masterList) {
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(master.getMib());
                info.add(master.getUei());
                info.add(master.getTrapOid());
                info.add(new Integer(master.getGenericId()));
                info.add(new Integer(master.getSpecificId()));
                info.add(new Integer(master.getPriority()));
                info.add(master.getLogmsg());
                list.add(info);
            }
        }
        return list;
    }

    public ArrayList<MonitorSnmpTrapOidInfo> getOidList() {
        return this.oidList;
    }

    public void setOidList(ArrayList<MonitorSnmpTrapOidInfo> oidList) {
        this.oidList = oidList;
    }
}

