/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.bean.EndStatusColorConstant;
import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.bean.JobNotificationsInfo;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NotificationsComposite
extends Composite {
    protected Combo m_normalPriority = null;
    protected Combo m_warningPriority = null;
    protected Combo m_abnormalPriority = null;
    protected Combo m_startPriority = null;
    protected NotifyIdListComposite m_notifyId = null;
    protected ArrayList m_notifications = null;

    public NotificationsComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        this.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label dummy = new Label(composite, 0);
        dummy.setLayoutData((Object)new RowData(40, 15));
        Label importanceDegreeTitle = new Label(composite, 0x1000000);
        importanceDegreeTitle.setText(Messages.getString((String)"priority"));
        importanceDegreeTitle.setLayoutData((Object)new RowData(80, 15));
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label beginningTitle = new Label(composite, 0x1000000);
        beginningTitle.setText(String.valueOf(EndStatusConstant.STRING_BEGINNING) + " : ");
        beginningTitle.setLayoutData((Object)new RowData(50, 15));
        this.m_startPriority = new Combo(composite, 0x1000008);
        this.m_startPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_startPriority.add(PriorityConstant.STRING_INFO);
        this.m_startPriority.add(PriorityConstant.STRING_WARNING);
        this.m_startPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_startPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_startPriority.add("");
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label normalTitle = new Label(composite, 0x1000000);
        normalTitle.setText(String.valueOf(EndStatusConstant.STRING_NORMAL) + " : ");
        normalTitle.setLayoutData((Object)new RowData(50, 15));
        normalTitle.setBackground(EndStatusColorConstant.COLOR_NORMAL);
        this.m_normalPriority = new Combo(composite, 0x1000008);
        this.m_normalPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_normalPriority.add(PriorityConstant.STRING_INFO);
        this.m_normalPriority.add(PriorityConstant.STRING_WARNING);
        this.m_normalPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_normalPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_normalPriority.add("");
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label warningTitle = new Label(composite, 0x1000000);
        warningTitle.setText(String.valueOf(EndStatusConstant.STRING_WARNING) + " : ");
        warningTitle.setLayoutData((Object)new RowData(50, 15));
        warningTitle.setBackground(EndStatusColorConstant.COLOR_WARNING);
        this.m_warningPriority = new Combo(composite, 0x1000008);
        this.m_warningPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_warningPriority.add(PriorityConstant.STRING_INFO);
        this.m_warningPriority.add(PriorityConstant.STRING_WARNING);
        this.m_warningPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_warningPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_warningPriority.add("");
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label abnormalTitle = new Label(composite, 0x1000000);
        abnormalTitle.setText(String.valueOf(EndStatusConstant.STRING_ABNORMAL) + " : ");
        abnormalTitle.setLayoutData((Object)new RowData(50, 15));
        abnormalTitle.setBackground(EndStatusColorConstant.COLOR_ABNORMAL);
        this.m_abnormalPriority = new Combo(composite, 0x1000008);
        this.m_abnormalPriority.setLayoutData((Object)new RowData(100, 20));
        this.m_abnormalPriority.add(PriorityConstant.STRING_INFO);
        this.m_abnormalPriority.add(PriorityConstant.STRING_WARNING);
        this.m_abnormalPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_abnormalPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_abnormalPriority.add("");
        composite = new Composite((Composite)this, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginHeight = 2;
        composite.setLayout((Layout)rowLayout);
        Label notifyIdTitle = new Label(composite, 0x1000000);
        notifyIdTitle.setText(String.valueOf(Messages.getString((String)"notify.id")) + " : ");
        notifyIdTitle.setLayoutData((Object)new RowData(50, 15));
        this.m_notifyId = new NotifyIdListComposite(composite, 0, false);
        this.m_notifyId.setLayoutData((Object)new RowData(250, 27));
    }

    public void reflectNotificationsInfo() {
        if (this.m_notifications instanceof ArrayList) {
            JobNotificationsInfo infoNormal = null;
            JobNotificationsInfo infoWarning = null;
            JobNotificationsInfo infoAbnormal = null;
            JobNotificationsInfo infoStart = null;
            int i = 0;
            while (i < this.m_notifications.size()) {
                if (((JobNotificationsInfo)this.m_notifications.get(i)).getType() == 3) {
                    infoStart = (JobNotificationsInfo)this.m_notifications.get(i);
                } else if (((JobNotificationsInfo)this.m_notifications.get(i)).getType() == 0) {
                    infoNormal = (JobNotificationsInfo)this.m_notifications.get(i);
                } else if (((JobNotificationsInfo)this.m_notifications.get(i)).getType() == 1) {
                    infoWarning = (JobNotificationsInfo)this.m_notifications.get(i);
                } else if (((JobNotificationsInfo)this.m_notifications.get(i)).getType() == 2) {
                    infoAbnormal = (JobNotificationsInfo)this.m_notifications.get(i);
                }
                ++i;
            }
            if (infoNormal instanceof JobNotificationsInfo) {
                this.setSelectPriority(this.m_normalPriority, infoNormal.getPriority());
                if (infoNormal.getNotify_id() != null && infoNormal.getNotify_id().length() > 0) {
                    this.m_notifyId.setText(infoNormal.getNotify_id());
                }
            }
            if (infoWarning instanceof JobNotificationsInfo) {
                this.setSelectPriority(this.m_warningPriority, infoWarning.getPriority());
                if (infoWarning.getNotify_id() != null && infoWarning.getNotify_id().length() > 0) {
                    this.m_notifyId.setText(infoNormal.getNotify_id());
                }
            }
            if (infoAbnormal instanceof JobNotificationsInfo) {
                this.setSelectPriority(this.m_abnormalPriority, infoAbnormal.getPriority());
                if (infoAbnormal.getNotify_id() != null && infoAbnormal.getNotify_id().length() > 0) {
                    this.m_notifyId.setText(infoNormal.getNotify_id());
                }
            }
            if (infoStart instanceof JobNotificationsInfo) {
                this.setSelectPriority(this.m_startPriority, infoStart.getPriority());
                if (infoStart.getNotify_id() != null && infoStart.getNotify_id().length() > 0) {
                    this.m_notifyId.setText(infoNormal.getNotify_id());
                }
            }
        } else {
            this.m_normalPriority.select(0);
            this.m_warningPriority.select(0);
            this.m_abnormalPriority.select(0);
            this.m_startPriority.select(0);
            this.m_notifyId.setText("");
        }
    }

    public void setNotificationsInfo(ArrayList notifications) {
        this.m_notifications = notifications;
    }

    public ArrayList getNotificationsInfo() {
        return this.m_notifications;
    }

    public ValidateResult createNotificationsInfo() {
        JobNotificationsInfo infoNormal = null;
        JobNotificationsInfo infoWarning = null;
        JobNotificationsInfo infoAbnormal = null;
        JobNotificationsInfo infoStart = null;
        this.m_notifications = new ArrayList();
        infoStart = new JobNotificationsInfo();
        infoStart.setType(3);
        this.m_notifications.add(infoStart);
        infoNormal = new JobNotificationsInfo();
        infoNormal.setType(0);
        this.m_notifications.add(infoNormal);
        infoWarning = new JobNotificationsInfo();
        infoWarning.setType(1);
        this.m_notifications.add(infoWarning);
        infoAbnormal = new JobNotificationsInfo();
        infoAbnormal.setType(2);
        this.m_notifications.add(infoAbnormal);
        infoNormal.setPriority(this.getSelectPriority(this.m_normalPriority));
        if (this.m_notifyId.getText().length() > 0) {
            infoNormal.setNotify_id(this.m_notifyId.getText());
        } else {
            infoStart.setNotify_id("");
        }
        infoWarning.setPriority(this.getSelectPriority(this.m_warningPriority));
        if (this.m_notifyId.getText().length() > 0) {
            infoWarning.setNotify_id(this.m_notifyId.getText());
        } else {
            infoWarning.setNotify_id("");
        }
        infoAbnormal.setPriority(this.getSelectPriority(this.m_abnormalPriority));
        if (this.m_notifyId.getText().length() > 0) {
            infoAbnormal.setNotify_id(this.m_notifyId.getText());
        } else {
            infoAbnormal.setNotify_id("");
        }
        infoStart.setPriority(this.getSelectPriority(this.m_startPriority));
        if (this.m_notifyId.getText().length() > 0) {
            infoStart.setNotify_id(this.m_notifyId.getText());
        } else {
            infoStart.setNotify_id("");
        }
        return null;
    }

    public void setSelectPriority(Combo combo, int priority) {
        String select = "";
        if (priority == 0) {
            select = PriorityConstant.STRING_CRITICAL;
        } else if (priority == 2) {
            select = PriorityConstant.STRING_WARNING;
        } else if (priority == 3) {
            select = PriorityConstant.STRING_INFO;
        } else if (priority == 1) {
            select = PriorityConstant.STRING_UNKNOWN;
        } else if (priority == 4) {
            select = "";
        }
        combo.select(0);
        int i = 0;
        while (i < combo.getItemCount()) {
            if (select.equals(combo.getItem(i))) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    public int getSelectPriority(Combo combo) {
        String select = combo.getText();
        if (select.equals(PriorityConstant.STRING_CRITICAL)) {
            return 0;
        }
        if (select.equals(PriorityConstant.STRING_WARNING)) {
            return 2;
        }
        if (select.equals(PriorityConstant.STRING_INFO)) {
            return 3;
        }
        if (select.equals(PriorityConstant.STRING_UNKNOWN)) {
            return 1;
        }
        if (select.equals("")) {
            return 4;
        }
        return -1;
    }
}

