/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dialog;

import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Schedule;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.composite.ComboModifyListener;
import com.clustercontrol.composite.NumberKeyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.CreateSchedule;
import com.clustercontrol.jobmanagement.action.GetCalendarIdList;
import com.clustercontrol.jobmanagement.action.ModifySchedule;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.bean.ScheduleInfo;
import com.clustercontrol.jobmanagement.dialog.JobTreeDialog;
import com.clustercontrol.util.Messages;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ScheduleDialog
extends CommonDialog {
    protected Text m_scheduleId = null;
    protected Text m_scheduleName = null;
    protected Text m_jobId = null;
    protected Text m_jobName = null;
    protected Combo m_calendarId = null;
    protected Button m_jobSelect = null;
    protected Button m_type1 = null;
    protected Button m_type2 = null;
    protected Button m_valid = null;
    protected Button m_invalid = null;
    protected Combo m_comboMonth = null;
    protected Combo m_comboDay = null;
    protected Combo m_comboHours1 = null;
    protected Combo m_comboMinutes1 = null;
    protected Combo m_comboDayOfWeek = null;
    protected Combo m_comboHours2 = null;
    protected Combo m_comboMinutes2 = null;
    protected Label m_labelDummy1 = null;
    protected Label m_labelDummy2 = null;
    protected Shell m_shell = null;
    protected ArrayList m_schedule = null;

    public ScheduleDialog(Shell parent) {
        super(parent);
    }

    protected void customizeDialog(Composite parent) {
        this.m_shell = this.getShell();
        parent.getShell().setText(Messages.getString((String)"dialog.job.add.modify.schedule"));
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 10;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.fill = true;
        parent.setLayout((Layout)layout);
        Composite composite = null;
        RowLayout rowLayout = null;
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label labelScheduleId = new Label(composite, 0);
        labelScheduleId.setText(String.valueOf(Messages.getString((String)"schedule.id")) + " : ");
        labelScheduleId.setLayoutData((Object)new RowData(120, 15));
        this.m_scheduleId = this.m_schedule instanceof ArrayList ? new Text(composite, 2056) : new Text(composite, 2048);
        this.m_scheduleId.setLayoutData((Object)new RowData(150, 15));
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label labelScheduleName = new Label(composite, 0);
        labelScheduleName.setText(String.valueOf(Messages.getString((String)"schedule.name")) + " : ");
        labelScheduleName.setLayoutData((Object)new RowData(120, 15));
        this.m_scheduleName = new Text(composite, 2048);
        this.m_scheduleName.setLayoutData((Object)new RowData(150, 15));
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label labelJobId = new Label(composite, 0);
        labelJobId.setText(String.valueOf(Messages.getString((String)"job.id")) + " : ");
        labelJobId.setLayoutData((Object)new RowData(120, 15));
        this.m_jobId = new Text(composite, 2056);
        this.m_jobId.setLayoutData((Object)new RowData(150, 15));
        this.m_jobSelect = new Button(composite, 0);
        this.m_jobSelect.setText(Messages.getString((String)"refer"));
        this.m_jobSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobTreeDialog dialog = new JobTreeDialog(ScheduleDialog.this.m_shell, true);
                if (dialog.open() == 0) {
                    JobTreeItem selectItem = dialog.getSelectItem();
                    if (selectItem.getData().getType() != -1) {
                        ScheduleDialog.this.m_jobId.setText(selectItem.getData().getId());
                        ScheduleDialog.this.m_jobName.setText(selectItem.getData().getName());
                    } else {
                        ScheduleDialog.this.m_jobId.setText("");
                        ScheduleDialog.this.m_jobName.setText("");
                    }
                }
            }
        });
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label labelJobName = new Label(composite, 0);
        labelJobName.setText(String.valueOf(Messages.getString((String)"job.name")) + " : ");
        labelJobName.setLayoutData((Object)new RowData(120, 15));
        this.m_jobName = new Text(composite, 2056);
        this.m_jobName.setLayoutData((Object)new RowData(150, 15));
        composite = new Composite(parent, 0);
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        composite.setLayout((Layout)rowLayout);
        Label labelCalendarId = new Label(composite, 0);
        labelCalendarId.setText(String.valueOf(Messages.getString((String)"calendar.id")) + " : ");
        labelCalendarId.setLayoutData((Object)new RowData(120, 15));
        this.m_calendarId = new Combo(composite, 16392);
        this.m_calendarId.setLayoutData((Object)new RowData(150, 20));
        ArrayList idList = new GetCalendarIdList().getCalendarIdList();
        if (idList != null) {
            this.m_calendarId.add("");
            int i = 0;
            while (i < idList.size()) {
                this.m_calendarId.add((String)idList.get(i));
                ++i;
            }
        }
        Group group1 = new Group(parent, 0);
        group1.setText(Messages.getString((String)"schedule"));
        GridLayout gridLayout = new GridLayout(9, true);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        group1.setLayout((Layout)gridLayout);
        this.createType1(group1);
        this.createType2(group1);
        Group group2 = new Group(parent, 0);
        group2.setText(String.valueOf(Messages.getString((String)"valid")) + "/" + Messages.getString((String)"invalid"));
        rowLayout = new RowLayout();
        rowLayout.type = 256;
        rowLayout.spacing = 10;
        rowLayout.marginWidth = 10;
        rowLayout.marginHeight = 10;
        group2.setLayout((Layout)rowLayout);
        this.m_valid = new Button((Composite)group2, 0x1000010);
        this.m_valid.setText(ValidConstant.STRING_VALID);
        this.m_valid.setLayoutData((Object)new RowData(60, 22));
        this.m_valid.setSelection(true);
        this.m_invalid = new Button((Composite)group2, 0x1000010);
        this.m_invalid.setText(ValidConstant.STRING_INVALID);
        this.m_invalid.setLayoutData((Object)new RowData(60, 22));
        new Label(parent, 258);
        Display display = this.m_shell.getDisplay();
        this.m_shell.setLocation((display.getBounds().width - this.m_shell.getSize().x) / 2, (display.getBounds().height - this.m_shell.getSize().y) / 2);
        this.reflectScheduleInfo();
    }

    protected void createType1(Group parent) {
        this.m_type1 = new Button((Composite)parent, 16);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_type1.setLayoutData((Object)gridData);
        this.m_type1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    ScheduleDialog.this.m_type2.setSelection(false);
                    ScheduleDialog.this.m_comboMonth.setEnabled(true);
                    ScheduleDialog.this.m_comboDay.setEnabled(true);
                    ScheduleDialog.this.m_comboHours1.setEnabled(true);
                    ScheduleDialog.this.m_comboMinutes1.setEnabled(true);
                    ScheduleDialog.this.m_comboDayOfWeek.setEnabled(false);
                    ScheduleDialog.this.m_comboHours2.setEnabled(false);
                    ScheduleDialog.this.m_comboMinutes2.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.m_comboMonth = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMonth.setLayoutData((Object)gridData);
        this.m_comboMonth.setTextLimit(2);
        this.m_comboMonth.setVisibleItemCount(10);
        this.m_comboMonth.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboMonth.addModifyListener((ModifyListener)new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        this.m_comboMonth.add("");
        int month = 1;
        while (month <= 12) {
            this.m_comboMonth.add(format.format(month));
            ++month;
        }
        Label labelMonth = new Label((Composite)parent, 0);
        labelMonth.setText(Messages.getString((String)"month"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMonth.setLayoutData((Object)gridData);
        this.m_comboDay = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboDay.setLayoutData((Object)gridData);
        this.m_comboDay.setTextLimit(2);
        this.m_comboDay.setVisibleItemCount(10);
        this.m_comboDay.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboDay.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboDay.add("");
        int day = 1;
        while (day <= 31) {
            this.m_comboDay.add(format.format(day));
            ++day;
        }
        Label labelDay = new Label((Composite)parent, 0);
        labelDay.setText(Messages.getString((String)"monthday"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelDay.setLayoutData((Object)gridData);
        this.m_comboHours1 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboHours1.setLayoutData((Object)gridData);
        this.m_comboHours1.setTextLimit(2);
        this.m_comboHours1.setVisibleItemCount(10);
        this.m_comboHours1.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboHours1.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboHours1.add("");
        int hour = 0;
        while (hour < 24) {
            this.m_comboHours1.add(format.format(hour));
            ++hour;
        }
        Label labelHours = new Label((Composite)parent, 0);
        labelHours.setText(Messages.getString((String)"hour"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData((Object)gridData);
        this.m_comboMinutes1 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMinutes1.setLayoutData((Object)gridData);
        this.m_comboMinutes1.setTextLimit(2);
        this.m_comboMinutes1.setVisibleItemCount(10);
        this.m_comboMinutes1.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboMinutes1.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboMinutes1.add("");
        int minutes = 0;
        while (minutes < 60) {
            this.m_comboMinutes1.add(format.format(minutes));
            ++minutes;
        }
        Label labelMinutes = new Label((Composite)parent, 0);
        labelMinutes.setText(Messages.getString((String)"minute"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData((Object)gridData);
    }

    protected void createType2(Group parent) {
        this.m_type2 = new Button((Composite)parent, 16);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_type2.setLayoutData((Object)gridData);
        this.m_type2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button check = (Button)e.getSource();
                if (check.getSelection()) {
                    ScheduleDialog.this.m_type1.setSelection(false);
                    ScheduleDialog.this.m_comboMonth.setEnabled(false);
                    ScheduleDialog.this.m_comboDay.setEnabled(false);
                    ScheduleDialog.this.m_comboHours1.setEnabled(false);
                    ScheduleDialog.this.m_comboMinutes1.setEnabled(false);
                    ScheduleDialog.this.m_comboDayOfWeek.setEnabled(true);
                    ScheduleDialog.this.m_comboHours2.setEnabled(true);
                    ScheduleDialog.this.m_comboMinutes2.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labelDayOfWeek = new Label((Composite)parent, 0);
        labelDayOfWeek.setText(Messages.getString((String)"weekday"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelDayOfWeek.setLayoutData((Object)gridData);
        this.m_comboDayOfWeek = new Combo((Composite)parent, 8);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        this.m_comboDayOfWeek.setLayoutData((Object)gridData);
        this.m_comboDayOfWeek.setTextLimit(3);
        this.m_comboDayOfWeek.setVisibleItemCount(10);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_SUNDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_MONDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_TUESDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_WEDNESDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_THURSDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_FRIDAY);
        this.m_comboDayOfWeek.add(DayOfWeekConstant.STRING_SATURDAY);
        Label labelDummy = new Label((Composite)parent, 0);
        labelDummy.setText("");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelDummy.setLayoutData((Object)gridData);
        this.m_comboHours2 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboHours2.setLayoutData((Object)gridData);
        this.m_comboHours2.setTextLimit(2);
        this.m_comboHours2.setVisibleItemCount(10);
        this.m_comboHours2.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboHours2.addModifyListener((ModifyListener)new ComboModifyListener());
        DecimalFormat format = new DecimalFormat("00");
        this.m_comboHours2.add("");
        int hour = 0;
        while (hour < 24) {
            this.m_comboHours2.add(format.format(hour));
            ++hour;
        }
        Label labelHours = new Label((Composite)parent, 0);
        labelHours.setText(Messages.getString((String)"hour"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelHours.setLayoutData((Object)gridData);
        this.m_comboMinutes2 = new Combo((Composite)parent, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboMinutes2.setLayoutData((Object)gridData);
        this.m_comboMinutes2.setTextLimit(2);
        this.m_comboMinutes2.setVisibleItemCount(10);
        this.m_comboMinutes2.addKeyListener((KeyListener)new NumberKeyListener());
        this.m_comboMinutes2.addModifyListener((ModifyListener)new ComboModifyListener());
        format = new DecimalFormat("00");
        this.m_comboMinutes2.add("");
        int minutes = 0;
        while (minutes < 60) {
            this.m_comboMinutes2.add(format.format(minutes));
            ++minutes;
        }
        Label labelMinutes = new Label((Composite)parent, 0);
        labelMinutes.setText(Messages.getString((String)"minute"));
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        labelMinutes.setLayoutData((Object)gridData);
    }

    public void setSchedule(ArrayList info) {
        this.m_schedule = info;
    }

    public ArrayList getSchedule() {
        return this.m_schedule;
    }

    protected void reflectScheduleInfo() {
        if (this.m_schedule instanceof ArrayList) {
            Schedule schedule;
            String scheduleId = (String)this.m_schedule.get(0);
            this.m_scheduleId.setText(scheduleId);
            String scheduleName = (String)this.m_schedule.get(1);
            this.m_scheduleName.setText(scheduleName);
            String jobId = (String)this.m_schedule.get(2);
            this.m_jobId.setText(jobId);
            String jobName = (String)this.m_schedule.get(3);
            this.m_jobName.setText(jobName);
            String calendarId = (String)this.m_schedule.get(4);
            if (calendarId != null && calendarId.length() > 0) {
                this.m_calendarId.select(0);
                int i = 0;
                while (i < this.m_calendarId.getItemCount()) {
                    if (calendarId.equals(this.m_calendarId.getItem(i))) {
                        this.m_calendarId.select(i);
                        break;
                    }
                    ++i;
                }
            }
            if ((schedule = (Schedule)this.m_schedule.get(5)).getDate() instanceof Date) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(schedule.getDate());
                DecimalFormat format = new DecimalFormat("00");
                this.m_comboMonth.select(0);
                int i = 0;
                while (i < this.m_comboMonth.getItemCount()) {
                    String month = format.format(calendar.get(2) + 1);
                    if (month.equals(this.m_comboMonth.getItem(i))) {
                        this.m_comboMonth.select(i);
                        break;
                    }
                    ++i;
                }
                this.m_comboDay.select(0);
                i = 0;
                while (i < this.m_comboDay.getItemCount()) {
                    String day = format.format(calendar.get(5));
                    if (day.equals(this.m_comboDay.getItem(i))) {
                        this.m_comboDay.select(i);
                        break;
                    }
                    ++i;
                }
                this.m_comboHours1.select(0);
                i = 0;
                while (i < this.m_comboHours1.getItemCount()) {
                    String hours = format.format(calendar.get(11));
                    if (hours.equals(this.m_comboHours1.getItem(i))) {
                        this.m_comboHours1.select(i);
                        this.m_comboHours2.select(i);
                        break;
                    }
                    ++i;
                }
                this.m_comboMinutes1.select(0);
                i = 0;
                while (i < this.m_comboMinutes1.getItemCount()) {
                    String minutes = format.format(calendar.get(12));
                    if (minutes.equals(this.m_comboMinutes1.getItem(i))) {
                        this.m_comboMinutes1.select(i);
                        this.m_comboMinutes2.select(i);
                        break;
                    }
                    ++i;
                }
                this.m_comboDayOfWeek.select(0);
                i = 0;
                while (i < this.m_comboDayOfWeek.getItemCount()) {
                    String dayOfWeek = DayOfWeekConstant.typeToString((int)schedule.getDayOfWeek());
                    if (dayOfWeek.equals(this.m_comboDayOfWeek.getItem(i))) {
                        this.m_comboDayOfWeek.select(i);
                        break;
                    }
                    ++i;
                }
            }
            this.m_comboMonth.setEnabled(true);
            this.m_comboDay.setEnabled(true);
            this.m_comboHours1.setEnabled(true);
            this.m_comboMinutes1.setEnabled(true);
            this.m_comboDayOfWeek.setEnabled(false);
            this.m_comboHours2.setEnabled(false);
            this.m_comboMinutes2.setEnabled(false);
            if (schedule.getType() == 0) {
                this.m_type1.setSelection(true);
            } else if (schedule.getType() == 1) {
                this.m_type1.setSelection(true);
                this.m_comboMonth.select(0);
            } else if (schedule.getType() == 2) {
                this.m_type1.setSelection(true);
                this.m_comboMonth.select(0);
                this.m_comboDay.select(0);
            } else if (schedule.getType() == 3) {
                this.m_type1.setSelection(true);
                this.m_comboMonth.select(0);
                this.m_comboDay.select(0);
                this.m_comboHours1.select(0);
            } else if (schedule.getType() == 4) {
                this.m_type2.setSelection(true);
                this.m_comboMonth.select(0);
                this.m_comboDay.select(0);
                this.m_comboMonth.setEnabled(false);
                this.m_comboDay.setEnabled(false);
                this.m_comboHours1.setEnabled(false);
                this.m_comboMinutes1.setEnabled(false);
                this.m_comboDayOfWeek.setEnabled(true);
                this.m_comboHours2.setEnabled(true);
                this.m_comboMinutes2.setEnabled(true);
            }
            Integer effective = (Integer)this.m_schedule.get(6);
            if (effective == 1) {
                this.m_valid.setSelection(true);
                this.m_invalid.setSelection(false);
            } else {
                this.m_valid.setSelection(false);
                this.m_invalid.setSelection(true);
            }
        } else {
            this.m_type1.setSelection(true);
            this.m_comboMonth.setEnabled(true);
            this.m_comboDay.setEnabled(true);
            this.m_comboHours1.setEnabled(true);
            this.m_comboMinutes1.setEnabled(true);
            this.m_comboDayOfWeek.setEnabled(false);
            this.m_comboHours2.setEnabled(false);
            this.m_comboMinutes2.setEnabled(false);
        }
    }

    protected ValidateResult createScheduleInfo() {
        ValidateResult result = null;
        ScheduleInfo info = new ScheduleInfo();
        if (this.m_scheduleId.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.24"));
            return result;
        }
        info.setId(this.m_scheduleId.getText());
        if (this.m_scheduleName.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.25"));
            return result;
        }
        info.setName(this.m_scheduleName.getText());
        if (this.m_jobId.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.22"));
            return result;
        }
        info.setJobId(this.m_jobId.getText());
        if (this.m_jobName.getText().length() <= 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.job.23"));
            return result;
        }
        info.setJobName(this.m_jobName.getText());
        if (this.m_calendarId.getText().length() > 0) {
            info.setCalendarId(this.m_calendarId.getText());
        } else {
            info.setCalendarId("");
        }
        Schedule schedule = new Schedule();
        Integer month = null;
        Integer day = null;
        Integer hours = null;
        Integer minutes = null;
        Integer week = null;
        if (this.m_type1.getSelection()) {
            if (this.m_comboMonth.getText().length() > 0) {
                month = new Integer(this.m_comboMonth.getText());
            }
            if (this.m_comboDay.getText().length() > 0) {
                day = new Integer(this.m_comboDay.getText());
            }
            if (this.m_comboHours1.getText().length() > 0) {
                hours = new Integer(this.m_comboHours1.getText());
            }
            if (this.m_comboMinutes1.getText().length() > 0) {
                minutes = new Integer(this.m_comboMinutes1.getText());
            }
            if (this.m_comboMonth.getText().length() == 0 && this.m_comboDay.getText().length() == 0 && this.m_comboHours1.getText().length() == 0) {
                schedule.setType(3);
            } else if (this.m_comboMonth.getText().length() == 0 && this.m_comboDay.getText().length() == 0) {
                schedule.setType(2);
            } else if (this.m_comboMonth.getText().length() == 0) {
                schedule.setType(1);
            } else {
                schedule.setType(0);
            }
            if (!(month instanceof Integer) && schedule.getType() == 0) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.26"));
                return result;
            }
            if (!(day instanceof Integer || schedule.getType() != 0 && schedule.getType() != 1)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.27"));
                return result;
            }
            if (!(hours instanceof Integer || schedule.getType() != 0 && schedule.getType() != 1 && schedule.getType() != 2)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.28"));
                return result;
            }
            if (!(minutes instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.29"));
                return result;
            }
        } else if (this.m_type2.getSelection()) {
            schedule.setType(4);
            if (this.m_comboDayOfWeek.getText().length() > 0) {
                week = new Integer(DayOfWeekConstant.stringToType((String)this.m_comboDayOfWeek.getText()));
            }
            if (this.m_comboHours2.getText().length() > 0) {
                hours = new Integer(this.m_comboHours2.getText());
            }
            if (this.m_comboMinutes2.getText().length() > 0) {
                minutes = new Integer(this.m_comboMinutes2.getText());
            }
            if (!(week instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.37"));
                return result;
            }
            if (!(hours instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.28"));
                return result;
            }
            if (!(minutes instanceof Integer)) {
                result = new ValidateResult();
                result.setValid(false);
                result.setID(Messages.getString((String)"message.hinemos.1"));
                result.setMessage(Messages.getString((String)"message.job.29"));
                return result;
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0);
        if (month instanceof Integer) {
            calendar.set(2, month - 1);
        }
        if (day instanceof Integer) {
            calendar.set(5, day);
        }
        if (hours instanceof Integer) {
            calendar.set(11, hours);
        }
        if (week instanceof Integer) {
            calendar.set(7, week);
            schedule.setDayOfWeek(week.intValue());
        }
        calendar.set(12, minutes);
        calendar.set(13, 0);
        schedule.setDate(calendar.getTime());
        info.setSchedule(schedule);
        if (this.m_valid.getSelection()) {
            info.setValid(1);
        } else {
            info.setValid(0);
        }
        if (result == null) {
            if (this.m_schedule instanceof ArrayList) {
                info.setCreateUser((String)this.m_schedule.get(7));
                info.setCreateTime((Date)this.m_schedule.get(8));
                info.setUpdateTime((Date)this.m_schedule.get(10));
                ModifySchedule update = new ModifySchedule();
                update.modifySchedule(info);
            } else {
                CreateSchedule add = new CreateSchedule();
                add.createSchedule(info);
            }
        }
        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"register");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createScheduleInfo();
        if (result != null) {
            return result;
        }
        return null;
    }
}

