/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.jobmanagement.dao.JobStartJobInfoDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartJobInfoPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobStartJobInfoDAOImpl
implements JobStartJobInfoDAO {
    protected static Log m_log = LogFactory.getLog(JobStartJobInfoDAOImpl.class);

    public void init() {
    }

    public void load(JobStartJobInfoPK pk, JobStartJobInfoBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_start_job_info WHERE session_id = ? AND job_id = ? AND target_job_id = ? AND target_job_type = ? AND target_job_end_value = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getSession_id());
                stmt.setString(2, pk.getJob_id());
                stmt.setString(3, pk.getTarget_job_id());
                stmt.setInt(4, pk.getTarget_job_type());
                stmt.setInt(5, pk.getTarget_job_end_value());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setSession_id(res.getString("session_id"));
                    ejb.setTarget_job_type(res.getInt("target_job_type"));
                    ejb.setTarget_job_end_value(res.getInt("target_job_end_value"));
                    ejb.setTarget_job_id(res.getString("target_job_id"));
                    break block13;
                }
                String msg = "JobStartJobInfo data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobStartJobInfoBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value()));
        m_log.debug((Object)("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value()));
    }

    public void remove(JobStartJobInfoPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_start_job_info WHERE session_id = ? AND job_id = ? AND target_job_id = ? AND target_job_type = ? AND target_job_end_value = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setString(3, pk.getTarget_job_id());
            stmt.setInt(4, pk.getTarget_job_type());
            stmt.setInt(5, pk.getTarget_job_end_value());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobStartJobInfoPK create(JobStartJobInfoBean ejb) throws CreateException, EJBException {
        JobStartJobInfoPK pk;
        m_log.debug((Object)("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_start_job_info (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("target_job_id, ");
                sql.append("target_job_type, ");
                sql.append("target_job_end_value) ");
                sql.append("VALUES (?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, ejb.getSession_id());
                stmt.setString(2, ejb.getJob_id());
                stmt.setString(3, ejb.getTarget_job_id());
                stmt.setInt(4, ejb.getTarget_job_type());
                stmt.setInt(5, ejb.getTarget_job_end_value());
                int row = stmt.executeUpdate();
                pk = new JobStartJobInfoPK(ejb.getSession_id(), ejb.getJob_id(), ejb.getTarget_job_id(), ejb.getTarget_job_type(), ejb.getTarget_job_end_value());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getTarget_job_id() + ", " + ejb.getTarget_job_type() + ", " + ejb.getTarget_job_end_value()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobStartJobInfoPK> ret = new ArrayList<JobStartJobInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_start_job_info";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobStartJobInfoPK pk = new JobStartJobInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("target_job_id"), res.getInt("target_job_type"), res.getInt("target_job_end_value"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobStartJobInfoPK findByPrimaryKey(JobStartJobInfoPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_start_job_info WHERE session_id = ? AND job_id = ? AND target_job_id = ? AND target_job_type = ? AND target_job_end_value = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getSession_id());
            stmt.setString(2, pk.getJob_id());
            stmt.setString(3, pk.getTarget_job_id());
            stmt.setInt(4, pk.getTarget_job_type());
            stmt.setInt(5, pk.getTarget_job_end_value());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobStartJobInfoPK jobStartJobInfoPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobStartJobInfoPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    public Collection findByTargetJobId(String session_id, String target_job_id) throws FinderException {
        m_log.debug((Object)("findByTargetJobId() start : " + session_id + ", " + target_job_id));
        ArrayList<JobStartJobInfoPK> ret = new ArrayList<JobStartJobInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_start_job_info WHERE session_id = ? AND target_job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, session_id);
            stmt.setString(2, target_job_id);
            res = stmt.executeQuery();
            while (res.next()) {
                JobStartJobInfoPK pk = new JobStartJobInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("target_job_id"), res.getInt("target_job_type"), res.getInt("target_job_end_value"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findByTargetJobId() error : " + session_id + ", " + target_job_id + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findByTargetJobId() error : " + session_id + ", " + target_job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findByTargetJobId() end : " + session_id + ", " + target_job_id));
        return ret;
    }

    public Collection findBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
        m_log.debug((Object)("findBySessionIdAndJobId() start : " + session_id + ", " + job_id));
        ArrayList<JobStartJobInfoPK> ret = new ArrayList<JobStartJobInfoPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_start_job_info WHERE session_id = ? AND job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, session_id);
            stmt.setString(2, job_id);
            res = stmt.executeQuery();
            while (res.next()) {
                JobStartJobInfoPK pk = new JobStartJobInfoPK(res.getString("session_id"), res.getString("job_id"), res.getString("target_job_id"), res.getInt("target_job_type"), res.getInt("target_job_end_value"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("findBySessionIdAndJobId() end : " + session_id + ", " + job_id));
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void makeSession(String sessionId, Collection jobs) throws CreateException {
        m_log.debug((Object)("makeSession() start : " + sessionId));
        Connection conn = null;
        Connection connMaster = null;
        Statement stmt = null;
        Statement stmtMaster = null;
        String jobId = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                connMaster = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_job_start_job_info (");
                sql.append("session_id, ");
                sql.append("job_id, ");
                sql.append("target_job_id, ");
                sql.append("target_job_type, ");
                sql.append("target_job_end_value) ");
                sql.append("VALUES (?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, sessionId);
                String sqlMaster = "SELECT * FROM cc_job_start_job_mst WHERE job_id = ?";
                stmtMaster = conn.prepareStatement(sqlMaster);
                for (Hashtable ht : jobs) {
                    jobId = (String)ht.get("jobId");
                    stmtMaster.setString(1, jobId);
                    ResultSet resMaster = stmtMaster.executeQuery();
                    while (resMaster.next()) {
                        stmt.setString(2, resMaster.getString("job_id"));
                        stmt.setString(3, resMaster.getString("target_job_id"));
                        stmt.setInt(4, resMaster.getInt("target_job_type"));
                        stmt.setInt(5, resMaster.getInt("target_job_end_value"));
                        int row = stmt.executeUpdate();
                        if (row == 1) continue;
                        String msg = "result row is not 1";
                        m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                        throw new EJBException(msg);
                    }
                    resMaster.close();
                }
                Object var16_16 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
                if (stmtMaster != null) {
                    stmtMaster.close();
                }
                if (connMaster == null) throw throwable;
                connMaster.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("makeSession() error : " + sessionId + ", " + jobId + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        if (stmtMaster != null) {
            stmtMaster.close();
        }
        if (connMaster != null) {
            connMaster.close();
        }
        m_log.debug((Object)("makeSession() end : " + sessionId));
    }
}

