/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.IDEExceptionHandler;
import org.eclipse.ui.internal.ide.IDEIdleHelper;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDEWorkbenchActivityHelper;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.IDEWorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ide.model.WorkbenchAdapterBuilder;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.update.core.SiteManager;
import org.osgi.framework.Bundle;

public class IDEWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String WORKBENCH_PREFERENCE_CATEGORY_ID = "org.eclipse.ui.preferencePages.Workbench";
    private static final String INSTALLED_FEATURES = "installedFeatures";
    private static IDEWorkbenchAdvisor workbenchAdvisor = null;
    private IDEExceptionHandler exceptionHandler = null;
    private String workspaceLocation = null;
    private Map newlyAddedBundleGroups;
    private AboutInfo[] welcomePerspectiveInfos = null;
    private IDEWorkbenchActivityHelper activityHelper = null;
    private IDEIdleHelper idleHelper;

    public IDEWorkbenchAdvisor() {
        if (workbenchAdvisor != null) {
            throw new IllegalStateException();
        }
        workbenchAdvisor = this;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        configurer.setSaveAndRestore(true);
        this.exceptionHandler = new IDEExceptionHandler(configurer);
        WorkbenchAdapterBuilder.registerAdapters();
        String[] cmdLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < cmdLineArgs.length) {
            if ("-showlocation".equalsIgnoreCase(cmdLineArgs[i])) {
                this.workspaceLocation = Platform.getLocation().toOSString();
                break;
            }
            ++i;
        }
        this.declareWorkbenchImages();
        this.activityHelper = IDEWorkbenchActivityHelper.getInstance();
        this.idleHelper = new IDEIdleHelper(configurer);
    }

    public void preStartup() {
        Platform.getJobManager().suspend();
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        ImageDescriptor newImage = IDEInternalWorkbenchImages.getImageDescriptor("IMG_ETOOL_BUILD_EXEC");
        service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_MANUAL_BUILD);
        service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void postStartup() {
        try {
            this.refreshFromLocal();
            this.checkUpdates();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            Platform.getJobManager().resume();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        Platform.getJobManager().resume();
    }

    public void postShutdown() {
        if (this.activityHelper != null) {
            this.activityHelper.shutdown();
            this.activityHelper = null;
        }
        if (this.idleHelper != null) {
            this.idleHelper.shutdown();
            this.idleHelper = null;
        }
        if (IDEWorkbenchPlugin.getPluginWorkspace() != null) {
            this.disconnectFromWorkspace();
        }
    }

    public void eventLoopException(Throwable exception) {
        super.eventLoopException(exception);
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handleException(exception);
        } else if (this.getWorkbenchConfigurer() != null) {
            this.getWorkbenchConfigurer().emergencyClose();
        }
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new IDEWorkbenchWindowAdvisor(this, configurer);
    }

    public boolean hasIntro() {
        return this.getWorkbenchConfigurer().getWorkbench().getIntroManager().hasIntro();
    }

    private void refreshFromLocal() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean refresh = store.getBoolean("REFRESH_WORKSPACE_ON_STARTUP");
        if (!refresh) {
            return;
        }
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-refresh")) {
                return;
            }
            ++i;
        }
        IWorkbenchWindow window = this.getWorkbenchConfigurer().getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window == null ? null : window.getShell();
        ProgressMonitorJobsDialog dlg = new ProgressMonitorJobsDialog(shell);
        final CoreException[] ex = new CoreException[1];
        try {
            dlg.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        root.refreshLocal(2, monitor);
                    }
                    catch (CoreException e) {
                        ex[0] = e;
                    }
                }
            });
            if (ex[0] != null) {
                ErrorDialog.openError((Shell)shell, (String)IDEWorkbenchMessages.Workspace_problemsTitle, (String)IDEWorkbenchMessages.Workspace_problemMessage, (IStatus)ex[0].getStatus());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            String msg = "InvocationTargetException refreshing from local on startup";
            IDEWorkbenchPlugin.log(msg, (IStatus)new Status(4, "org.eclipse.ui.ide", 0, msg, e.getTargetException()));
        }
    }

    private void disconnectFromWorkspace() {
        final MultiStatus status = new MultiStatus("org.eclipse.ui.ide", 1, IDEWorkbenchMessages.ProblemSavingWorkbench, null);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    status.merge(ResourcesPlugin.getWorkspace().save(true, monitor));
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(null).run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.InternalError, e.getTargetException()));
        }
        catch (InterruptedException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.InternalError, (Throwable)e));
        }
        ErrorDialog.openError(null, (String)IDEWorkbenchMessages.ProblemsSavingWorkspace, null, (IStatus)status, (int)6);
        if (!status.isOK()) {
            IDEWorkbenchPlugin.log(IDEWorkbenchMessages.ProblemsSavingWorkspace, (IStatus)status);
        }
    }

    private void checkUpdates() {
        boolean newUpdates = false;
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-newUpdates")) {
                newUpdates = true;
                break;
            }
            ++i;
        }
        if (newUpdates) {
            try {
                SiteManager.handleNewChanges();
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log("Problem opening update manager", e.getStatus());
            }
        }
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getInitialWindowPerspectiveId() {
        int index = PlatformUI.getWorkbench().getWorkbenchWindowCount() - 1;
        String perspectiveId = null;
        AboutInfo[] welcomeInfos = this.getWelcomePerspectiveInfos();
        if (index >= 0 && welcomeInfos != null && index < welcomeInfos.length) {
            perspectiveId = welcomeInfos[index].getWelcomePerspectiveId();
        }
        if (perspectiveId == null) {
            perspectiveId = "org.eclipse.ui.resourcePerspective";
        }
        return perspectiveId;
    }

    private Map computeBundleGroupMap() {
        TreeMap<String, AboutInfo> ids = new TreeMap<String, AboutInfo>();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        int i = 0;
        while (i < providers.length) {
            IBundleGroup[] groups = providers[i].getBundleGroups();
            int j = 0;
            while (j < groups.length) {
                IBundleGroup group = groups[j];
                AboutInfo info = new AboutInfo(group);
                String version = info.getVersionId();
                version = version == null ? "0.0.0" : new PluginVersionIdentifier(version).toString();
                String versionedFeature = String.valueOf(group.getIdentifier()) + ":" + version;
                ids.put(versionedFeature, info);
                ++j;
            }
            ++i;
        }
        return ids;
    }

    public Map getNewlyAddedBundleGroups() {
        if (this.newlyAddedBundleGroups == null) {
            this.newlyAddedBundleGroups = this.createNewBundleGroupsMap();
        }
        return this.newlyAddedBundleGroups;
    }

    private Map createNewBundleGroupsMap() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        String[] previousFeaturesArray = settings.getArray(INSTALLED_FEATURES);
        Map bundleGroups = this.computeBundleGroupMap();
        String[] currentFeaturesArray = new String[bundleGroups.size()];
        bundleGroups.keySet().toArray(currentFeaturesArray);
        settings.put(INSTALLED_FEATURES, currentFeaturesArray);
        if (previousFeaturesArray != null) {
            int i = 0;
            while (i < previousFeaturesArray.length) {
                bundleGroups.remove(previousFeaturesArray[i]);
                ++i;
            }
        }
        return bundleGroups;
    }

    private void declareWorkbenchImages() {
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_HOVER", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_DISABLED", "$nl$/icons/full/dtool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_HOVER", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_DISABLED", "$nl$/icons/full/dtool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_NEXT_NAV", "$nl$/icons/full/etool16/next_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PREVIOUS_NAV", "$nl$/icons/full/etool16/prev_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWPRJ_WIZ", "$nl$/icons/full/wizban/newprj_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFOLDER_WIZ", "$nl$/icons/full/wizban/newfolder_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFILE_WIZ", "$nl$/icons/full/wizban/newfile_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTDIR_WIZ", "$nl$/icons/full/wizban/importdir_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTZIP_WIZ", "$nl$/icons/full/wizban/importzip_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTDIR_WIZ", "$nl$/icons/full/wizban/exportdir_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/exportzip_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/workset_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_SAVEAS_DLG", "$nl$/icons/full/wizban/saveas_wiz.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT_CLOSED", "$nl$/icons/full/obj16/cprj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OPEN_MARKER", "$nl$/icons/full/elcl16/gotoobj_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_TASK_TSK", "$nl$/icons/full/obj16/taskmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_BKMRK_TSK", "$nl$/icons/full/obj16/bkmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_COMPLETE_TSK", "$nl$/icons/full/obj16/complete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INCOMPLETE_TSK", "$nl$/icons/full/obj16/incomplete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_ITEM", "$nl$/icons/full/obj16/welcome_item.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_BANNER", "$nl$/icons/full/obj16/welcome_banner.gif", true);
    }

    private void declareWorkbenchImage(Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = Platform.find((Bundle)ideBundle, (IPath)new Path(path));
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getWorkbenchConfigurer().declareImage(symbolicName, desc, shared);
    }

    public String getMainPreferencePageId() {
        return WORKBENCH_PREFERENCE_CATEGORY_ID;
    }

    public String getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public AboutInfo[] getWelcomePerspectiveInfos() {
        if (this.welcomePerspectiveInfos == null && !this.hasIntro()) {
            Map m = this.getNewlyAddedBundleGroups();
            ArrayList<AboutInfo> list = new ArrayList<AboutInfo>(m.size());
            Iterator i = m.values().iterator();
            while (i.hasNext()) {
                AboutInfo info = (AboutInfo)i.next();
                if (info == null || info.getWelcomePerspectiveId() == null || info.getWelcomePageURL() == null) continue;
                list.add(info);
            }
            this.welcomePerspectiveInfos = new AboutInfo[list.size()];
            list.toArray(this.welcomePerspectiveInfos);
        }
        return this.welcomePerspectiveInfos;
    }
}

