/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.action.GetParameterProperty;
import com.clustercontrol.collectiverun.action.GetType;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.util.Messages;
import java.rmi.AccessException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ParameterViewComposite
extends Composite {
    protected PropertySheet propertySheet = null;
    protected Combo type = null;
    protected HashMap<String, String> typeMap = null;
    protected List<String> typeList = null;
    private boolean openAccessInformation = false;

    public ParameterViewComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData;
        block6: {
            GetType getType;
            block5: {
                GridLayout layout = new GridLayout(1, true);
                this.setLayout((Layout)layout);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                Composite composite = new Composite((Composite)this, 0);
                RowLayout compositeLayout = new RowLayout(256);
                composite.setLayout((Layout)compositeLayout);
                compositeLayout.marginHeight = 0;
                compositeLayout.marginWidth = 0;
                gridData = new GridData();
                gridData.horizontalAlignment = 4;
                gridData.verticalAlignment = 4;
                composite.setLayoutData((Object)gridData);
                Label management = new Label(composite, 16384);
                management.setText(String.valueOf(Messages.getString((String)"type")) + " : ");
                RowData rowData = new RowData();
                management.setLayoutData((Object)rowData);
                this.type = new Combo(composite, 8);
                rowData = new RowData(160, 20);
                this.type.setLayoutData((Object)rowData);
                getType = new GetType();
                try {
                    this.typeMap = getType.getTypeHashMap();
                }
                catch (AccessException accessException) {
                    if (this.openAccessInformation) break block5;
                    this.openAccessInformation = true;
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
            }
            try {
                this.typeList = getType.getTypeStringList();
            }
            catch (AccessException accessException) {
                if (this.openAccessInformation) break block6;
                this.openAccessInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
        }
        int i = 0;
        while (this.typeList != null && i < this.typeList.size()) {
            this.type.add(this.typeList.get(i));
            ++i;
        }
        this.type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParameterViewComposite.this.update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.type.select(0);
        TableTree table = new TableTree((Composite)this, 66306);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.propertySheet = new PropertySheet(table);
        this.update();
    }

    public void update() {
        Property data;
        block3: {
            String typeId = this.getTypeId();
            data = null;
            try {
                data = new GetParameterProperty().getProperty(typeId);
            }
            catch (AccessException accessException) {
                if (this.openAccessInformation) break block3;
                this.openAccessInformation = true;
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
        }
        if (data == null) {
            data = new Property(null, null, "");
        }
        this.propertySheet.setInput(data);
        this.propertySheet.expandAll();
    }

    public void update(String sessionId) {
        GetParameterProperty parameter = new GetParameterProperty();
        if (sessionId != null && sessionId.length() > 0) {
            String typeId;
            block7: {
                typeId = null;
                try {
                    typeId = parameter.getTypeId(sessionId);
                }
                catch (AccessException accessException) {
                    if (this.openAccessInformation) break block7;
                    this.openAccessInformation = true;
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                }
            }
            if (typeId != null) {
                Property data;
                block8: {
                    data = null;
                    try {
                        data = parameter.getPropertyBySessionId(sessionId);
                    }
                    catch (AccessException accessException) {
                        if (this.openAccessInformation) break block8;
                        this.openAccessInformation = true;
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                }
                if (data == null) {
                    data = new Property(null, null, "");
                }
                this.propertySheet.setInput(data);
                this.propertySheet.expandAll();
                this.type.setText(this.getTypeString(typeId));
            }
        }
    }

    public Property getInputData() {
        return (Property)this.propertySheet.getInput();
    }

    public void setInputData(Property data) {
        this.propertySheet.setInput(data);
        this.propertySheet.expandAll();
    }

    public String getTypeId() {
        if (this.typeMap != null) {
            return this.typeMap.get(this.type.getText());
        }
        return null;
    }

    public String getTypeString(String typeId) {
        if (this.typeMap != null) {
            return this.typeMap.get(typeId);
        }
        return null;
    }

    public TableTree getTableTree() {
        return this.propertySheet.getTableTree();
    }
}

