/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.dialog;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.syslogng.action.LogManager;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.composite.LogListComposite;
import com.clustercontrol.syslogng.dialog.LogCreateDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LogListDialog
extends CommonDialog {
    private LogListComposite logList = null;
    private Button buttonAdd = null;
    private Button buttonModify = null;
    private Button buttonDelete = null;
    private Button buttonUp = null;
    private Button buttonDown = null;
    private Button buttonValid = null;
    private Button buttonInvalid = null;

    public LogListDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        return new Point(800, 420);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.syslog-ng.list"));
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout((Layout)layout);
        this.logList = new LogListComposite(parent, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.logList.setLayoutData(gridData);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData((Object)gridData);
        this.buttonAdd = this.createButton(composite, Messages.getString((String)"add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogCreateDialog dialog = new LogCreateDialog(LogListDialog.this.getParentShell());
                if (dialog.open() == 0) {
                    LogManager.getInstance().add(dialog.getInputData());
                    LogListDialog.this.logList.update();
                }
            }
        });
        new Label(composite, 0);
        this.buttonModify = this.createButton(composite, Messages.getString((String)"modify"));
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String logId = LogListDialog.this.getSelectLogId();
                if (logId != null) {
                    LogCreateDialog dialog = new LogCreateDialog(LogListDialog.this.getParentShell(), logId);
                    if (dialog.open() == 0) {
                        Table table = LogListDialog.this.logList.getTableViewer().getTable();
                        int selectIndex = table.getSelectionIndex();
                        LogManager.getInstance().modify(dialog.getInputData());
                        LogListDialog.this.logList.update();
                        table.setSelection(selectIndex);
                    }
                } else {
                    MessageBox box = new MessageBox(LogListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.1"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        this.buttonDelete = this.createButton(composite, Messages.getString((String)"delete"));
        this.buttonDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogFilterInfo filterInfo = LogListDialog.this.logList.getFilterItem();
                if (filterInfo != null) {
                    String monitorId = filterInfo.getMonitorId();
                    MessageBox box = new MessageBox(LogListDialog.this.getShell(), 296);
                    box.setText(Messages.getString((String)"confirmed"));
                    Object[] args = new String[]{monitorId};
                    String message = Messages.getString((String)"message.monitor.39", (Object[])args);
                    box.setMessage(message);
                    if (box.open() == 32) {
                        LogManager.getInstance().delete(LogListDialog.this.getSelectLogId());
                        LogListDialog.this.logList.update();
                    }
                } else {
                    MessageBox box = new MessageBox(LogListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.1"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        new Label(composite, 0);
        this.buttonUp = this.createButton(composite, Messages.getString((String)"up"));
        this.buttonUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String logId = LogListDialog.this.getSelectLogId();
                if (logId != null) {
                    if (LogManager.getInstance().upOrder(logId)) {
                        LogListDialog.this.logList.update();
                        LogListDialog.this.selectItem(logId);
                    }
                } else {
                    MessageBox box = new MessageBox(LogListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.1"));
                    box.open();
                }
            }
        });
        this.buttonDown = this.createButton(composite, Messages.getString((String)"down"));
        this.buttonDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String logId = LogListDialog.this.getSelectLogId();
                if (logId != null) {
                    if (LogManager.getInstance().downOrder(LogListDialog.this.getSelectLogId())) {
                        LogListDialog.this.logList.update();
                        LogListDialog.this.selectItem(logId);
                    }
                } else {
                    MessageBox box = new MessageBox(LogListDialog.this.getShell(), 40);
                    box.setText(Messages.getString((String)"warning"));
                    box.setMessage(Messages.getString((String)"message.monitor.1"));
                    box.open();
                }
            }
        });
        new Label(composite, 0);
        this.buttonValid = this.createButton(composite, Messages.getString((String)"valid"));
        this.buttonValid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogListDialog.this.setValid(1);
            }
        });
        this.buttonInvalid = this.createButton(composite, Messages.getString((String)"invalid"));
        this.buttonInvalid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogListDialog.this.setValid(0);
            }
        });
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        return super.validate();
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"register");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(label);
        return button;
    }

    private String getSelectLogId() {
        StructuredSelection selection = (StructuredSelection)this.logList.getTableViewer().getSelection();
        if (selection.getFirstElement() instanceof LogFilterInfo) {
            LogFilterInfo filterInfo = (LogFilterInfo)selection.getFirstElement();
            return filterInfo.getLogId();
        }
        return null;
    }

    private void selectItem(String logId) {
        Table table = this.logList.getTableViewer().getTable();
        TableItem[] items = table.getItems();
        if (items == null || logId == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            LogFilterInfo filterInfo;
            if (items[i].getData() instanceof LogFilterInfo && logId.equals((filterInfo = (LogFilterInfo)items[i].getData()).getLogId())) {
                table.select(i);
                return;
            }
            ++i;
        }
    }

    public void setValid(int valid) {
        ArrayList<LogFilterInfo> list = this.logList.getSelectionData();
        if (list != null && list.size() > 0) {
            StringBuilder logIds = new StringBuilder();
            int i = 0;
            while (i < list.size()) {
                LogFilterInfo info;
                if (logIds.length() > 0) {
                    logIds.append(", ");
                }
                if ((info = list.get(i)) instanceof LogFilterInfo) {
                    logIds.append(info.getMonitorId());
                }
                ++i;
            }
            MessageBox confirmBox = new MessageBox(this.getShell(), 296);
            confirmBox.setText(Messages.getString((String)"confirmed"));
            Object[] confirmArgs = new String[]{logIds.toString()};
            if (valid == 1) {
                confirmBox.setMessage(Messages.getString((String)"message.monitor.47", (Object[])confirmArgs));
            } else {
                confirmBox.setMessage(Messages.getString((String)"message.monitor.48", (Object[])confirmArgs));
            }
            if (confirmBox.open() == 256) {
                return;
            }
            int i2 = 0;
            while (i2 < list.size()) {
                String logId = null;
                if (list.get(i2) instanceof LogFilterInfo) {
                    logId = list.get(i2).getLogId();
                }
                if (logId != null && !logId.equals("")) {
                    LogFilterInfo info = LogManager.getInstance().get(logId);
                    info.setValidFlg(YesNoConstant.typeToBoolean((int)valid));
                    boolean result = LogManager.getInstance().modify(info);
                    if (!result) {
                        MessageBox box = new MessageBox(this.getShell(), 33);
                        box.setText(Messages.getString((String)"failed"));
                        Object[] args = new String[]{logId};
                        box.setMessage(Messages.getString((String)"message.monitor.36", (Object[])args));
                        box.open();
                    }
                }
                ++i2;
            }
            int selectIndex = this.logList.getTableViewer().getTable().getSelectionIndex();
            this.logList.update();
            this.logList.getTableViewer().getTable().setSelection(selectIndex);
        } else {
            MessageBox box = new MessageBox(this.getShell(), 40);
            box.setText(Messages.getString((String)"warning"));
            box.setMessage(Messages.getString((String)"message.monitor.1"));
            box.open();
        }
    }
}

