/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.IArchiveReference;
import org.eclipse.update.core.SiteContentProvider;
import org.eclipse.update.internal.core.UpdateCore;

public class SiteURLContentProvider
extends SiteContentProvider {
    public static final String SITE_TYPE = "org.eclipse.update.core.http";

    public SiteURLContentProvider(URL url) {
        super(url);
    }

    public URL getArchiveReference(String archiveId) throws CoreException {
        URL contentURL = null;
        contentURL = this.getArchiveURLfor(archiveId);
        if (contentURL == null) {
            return super.getArchiveReference(archiveId);
        }
        return contentURL;
    }

    private URL getArchiveURLfor(String archiveId) {
        URL result = null;
        boolean found = false;
        IArchiveReference[] siteArchives = this.getSite().getArchives();
        if (siteArchives.length > 0) {
            int i = 0;
            while (i < siteArchives.length && !found) {
                if (UpdateCore.DEBUG && UpdateCore.DEBUG_SHOW_INSTALL) {
                    UpdateCore.debug("GetArchiveURL for:" + archiveId + " compare to " + siteArchives[i].getPath());
                }
                if (archiveId.trim().equalsIgnoreCase(siteArchives[i].getPath())) {
                    result = siteArchives[i].getURL();
                    found = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

