/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.factory;

import com.clustercontrol.calendar.bean.RunConstant;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoUtil;
import com.clustercontrol.calendar.ejb.entity.CalendarInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarInfoUtil;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoUtil;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.ejb.FinderException;
import javax.naming.NamingException;

public class SelectCalendar {
    public ArrayList getCalendarList() throws FinderException, NamingException {
        ArrayList list = new ArrayList();
        Collection ct = CalendarInfoUtil.getLocalHome().findAll();
        if (ct != null) {
            for (CalendarInfoLocal cal : ct) {
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(cal.getCalendar_id());
                info.add(cal.getCalendar_name());
                info.add(cal.getValid_time_from());
                info.add(cal.getValid_time_to());
                info.add(cal.getDescription());
                info.add(cal.getReg_user());
                info.add(cal.getReg_date());
                info.add(cal.getUpdate_user());
                info.add(cal.getUpdate_date());
                info.add(new Boolean(true));
                list.add(info);
            }
        }
        return list;
    }

    public ArrayList getWeekdayList(String id) throws FinderException, NamingException {
        ArrayList list = new ArrayList();
        Collection ct = CalendarWeekdayInfoUtil.getLocalHome().findByCalendarId(id);
        if (ct != null) {
            for (CalendarWeekdayInfoLocal cal : ct) {
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(cal.getWeekday());
                info.add(cal.getTime_from());
                info.add(cal.getTime_to());
                info.add(cal.getDescription());
                info.add(cal.getReg_user());
                info.add(cal.getReg_date());
                info.add(cal.getUpdate_user());
                info.add(cal.getUpdate_date());
                list.add(info);
            }
        }
        return list;
    }

    public ArrayList getAddList(String id) throws FinderException, NamingException {
        ArrayList list = new ArrayList();
        Collection ct = CalendarAddInfoUtil.getLocalHome().findByCalendarId(id);
        if (ct != null) {
            for (CalendarAddInfoLocal cal : ct) {
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(new Boolean(RunConstant.typeToBoolean(cal.getExecute_flg())));
                info.add(cal.getTime_from());
                info.add(cal.getTime_to());
                info.add(cal.getDescription());
                info.add(cal.getReg_user());
                info.add(cal.getReg_date());
                info.add(cal.getUpdate_user());
                info.add(cal.getUpdate_date());
                list.add(info);
            }
        }
        return list;
    }

    public ArrayList getSchedule(Date base) throws FinderException, NamingException {
        ArrayList list = new ArrayList();
        Collection ct = CalendarInfoUtil.getLocalHome().findAll();
        if (ct != null) {
            for (CalendarInfoLocal cal : ct) {
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(cal.getCalendar_id());
                for (int i = 0; i < 28; ++i) {
                    Calendar baseCalendar = Calendar.getInstance();
                    baseCalendar.setTime(base);
                    baseCalendar.add(5, i);
                    Date work = baseCalendar.getTime();
                    if (this.isSchedule(cal.getCalendar_id(), work).booleanValue()) {
                        info.add(work);
                        continue;
                    }
                    info.add(null);
                }
                list.add(info);
            }
        }
        return list;
    }

    public Boolean isRun(String id, Date checkTimestamp) throws FinderException, NamingException {
        Boolean run = new Boolean(false);
        CalendarInfoLocal cal = CalendarInfoUtil.getLocalHome().findByPrimaryKey(id);
        if (cal != null && checkTimestamp.after(cal.getValid_time_from()) && checkTimestamp.before(cal.getValid_time_to())) {
            Collection ct = cal.getCalendarAddInfo();
            for (CalendarAddInfoLocal add : ct) {
                Boolean check = this.isRunByAddInfo(add, checkTimestamp);
                if (check == null) continue;
                run = check != false ? new Boolean(true) : new Boolean(false);
                return run;
            }
            ct = cal.getCalendarWeekdayInfo();
            for (CalendarWeekdayInfoLocal weekday : ct) {
                if (!this.isRunByWeekdayInfo(weekday, checkTimestamp).booleanValue()) continue;
                run = new Boolean(true);
                return run;
            }
        }
        return run;
    }

    protected Boolean isRunByAddInfo(CalendarAddInfoLocal add, Date checkTimestamp) {
        Boolean run = null;
        if (add != null && checkTimestamp.after(add.getTime_from()) && checkTimestamp.before(add.getTime_to())) {
            run = new Boolean(RunConstant.typeToBoolean(add.getExecute_flg()));
        }
        return run;
    }

    protected Boolean isRunByWeekdayInfo(CalendarWeekdayInfoLocal weekday, Date checkTimestamp) {
        Boolean run = new Boolean(false);
        Calendar work = Calendar.getInstance();
        work.setTime(checkTimestamp);
        int dayOfWeek = work.get(7);
        Calendar checkCalendar = Calendar.getInstance();
        checkCalendar.set(1, 1970);
        checkCalendar.set(2, 0);
        checkCalendar.set(5, 1);
        checkCalendar.set(11, work.get(11));
        checkCalendar.set(12, work.get(12));
        checkCalendar.set(13, work.get(13));
        Time checkTime = new Time(checkCalendar.getTime().getTime());
        if (weekday != null && dayOfWeek == weekday.getWeekday() && checkTime.after(weekday.getTime_from()) && checkTime.before(weekday.getTime_to())) {
            run = new Boolean(true);
        }
        return run;
    }

    public Boolean isSchedule(String id, Date checkTimestamp) throws FinderException, NamingException {
        Boolean run = new Boolean(false);
        CalendarInfoLocal cal = CalendarInfoUtil.getLocalHome().findByPrimaryKey(id);
        if (cal != null && checkTimestamp.after(cal.getValid_time_from()) && checkTimestamp.before(cal.getValid_time_to())) {
            if (this.isScheduleByAddInfo(id, checkTimestamp).booleanValue()) {
                run = new Boolean(true);
                return run;
            }
            if (this.isScheduleByWeekdayInfo(id, checkTimestamp).booleanValue()) {
                run = new Boolean(true);
                return run;
            }
        }
        return run;
    }

    protected Boolean isScheduleByAddInfo(String id, Date checkTimestamp) {
        Boolean run = new Boolean(false);
        try {
            Collection ct;
            if (id != null && id.length() > 0 && (ct = CalendarAddInfoUtil.getLocalHome().selectSchdule(id, checkTimestamp)).size() > 0) {
                run = new Boolean(true);
            }
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            // empty catch block
        }
        return run;
    }

    protected Boolean isScheduleByWeekdayInfo(String id, Date checkTimestamp) {
        Boolean run = new Boolean(false);
        Calendar work = Calendar.getInstance();
        work.setTime(checkTimestamp);
        int dayOfWeek = work.get(7);
        try {
            Collection ct;
            if (id != null && id.length() > 0 && (ct = CalendarWeekdayInfoUtil.getLocalHome().findByWeekday(id, new Integer(dayOfWeek))).size() > 0) {
                for (CalendarWeekdayInfoLocal weekday : ct) {
                    long timeFrom = weekday.getTime_from().getTime();
                    long timeTo = weekday.getTime_to().getTime();
                    Calendar baseCalendar = Calendar.getInstance();
                    baseCalendar.setTimeInMillis(timeFrom);
                    work.set(11, baseCalendar.get(11));
                    work.set(12, baseCalendar.get(12));
                    work.set(13, baseCalendar.get(13));
                    work.set(14, 0);
                    Date start = work.getTime();
                    baseCalendar.setTimeInMillis(timeTo);
                    work.set(11, baseCalendar.get(11));
                    work.set(12, baseCalendar.get(12));
                    work.set(13, baseCalendar.get(13));
                    work.set(14, 0);
                    Date end = work.getTime();
                    Collection ctNo = CalendarAddInfoUtil.getLocalHome().selectNoSchdule(id, start, end);
                    if (ctNo.size() > 0) continue;
                    run = new Boolean(true);
                    return run;
                }
            }
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            // empty catch block
        }
        return run;
    }

    public ArrayList getCalendarIdList() throws FinderException, NamingException {
        ArrayList<String> list = new ArrayList<String>();
        Collection ct = CalendarInfoUtil.getLocalHome().findAll();
        if (ct != null) {
            for (CalendarInfoLocal cal : ct) {
                list.add(cal.getCalendar_id());
            }
        }
        return list;
    }
}

