/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.dialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.logtransfer.action.LogTransferFileProperty;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LogTransferFileDialog
extends CommonDialog {
    protected PropertySheet m_propertySheet = null;
    private Shell m_shell = null;
    private ArrayList m_fileList = null;

    public LogTransferFileDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void customizeDialog(Composite parent) {
        this.m_shell = this.getShell();
        this.m_shell.setText(Messages.getString((String)"logtransfer.file"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"attribute")) + " : ");
        TableTree table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.m_propertySheet = new PropertySheet(table);
        this.m_propertySheet.setInput(new LogTransferFileProperty().getProperty());
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = this.m_shell.getDisplay();
        this.m_shell.setLocation((display.getBounds().width - this.m_shell.getSize().x) / 2, (display.getBounds().height - this.m_shell.getSize().y) / 2);
        this.reflectLogTransferFile();
        this.m_propertySheet.expandAll();
    }

    private void reflectLogTransferFile() {
        Property property = null;
        if (this.m_fileList instanceof ArrayList) {
            property = new LogTransferFileProperty().getProperty();
            ArrayList propertyList = PropertyUtil.getProperty(property, "filePath");
            String filePath = (String)this.m_fileList.get(0);
            ((Property)propertyList.get(0)).setValue((Object)filePath);
            propertyList = PropertyUtil.getProperty(property, "runInterval");
            Integer runInterval = (Integer)this.m_fileList.get(1);
            ((Property)propertyList.get(0)).setValue((Object)runInterval);
            propertyList = PropertyUtil.getProperty(property, "existenceFlg");
            Boolean existenceFlg = (Boolean)this.m_fileList.get(2);
            ((Property)propertyList.get(0)).setValue((Object)existenceFlg);
            propertyList = PropertyUtil.getProperty(property, "valid");
            Integer valid = (Integer)this.m_fileList.get(3);
            ((Property)propertyList.get(0)).setValue((Object)ValidConstant.typeToString((int)valid));
            this.m_propertySheet.setInput(property);
            this.m_propertySheet.refresh();
        }
    }

    private ValidateResult createLogTransferFile() {
        ValidateResult result = null;
        this.m_fileList = new ArrayList();
        Property property = (Property)this.m_propertySheet.getInput();
        String filePath = null;
        ArrayList values = PropertyUtil.getPropertyValue(property, "filePath");
        if (values.get(0) instanceof String) {
            filePath = (String)values.get(0);
        }
        if (filePath == null || filePath.length() == 0) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.logtransfer.12"));
            return result;
        }
        this.m_fileList.add(filePath);
        Integer runInterval = null;
        values = PropertyUtil.getPropertyValue(property, "runInterval");
        if (values.get(0) instanceof Integer) {
            runInterval = (Integer)values.get(0);
        }
        if (runInterval == null) {
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString((String)"message.hinemos.1"));
            result.setMessage(Messages.getString((String)"message.logtransfer.13"));
            return result;
        }
        this.m_fileList.add(runInterval);
        Boolean existenceFlg = new Boolean(true);
        values = PropertyUtil.getPropertyValue(property, "existenceFlg");
        if (values.get(0) instanceof Boolean) {
            existenceFlg = (Boolean)values.get(0);
        }
        this.m_fileList.add(existenceFlg);
        Integer valid = 1;
        values = PropertyUtil.getPropertyValue(property, "valid");
        if (values.get(0) instanceof String) {
            valid = ValidConstant.stringToType((String)((String)values.get(0)));
        }
        this.m_fileList.add(valid);
        return null;
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    public void setInputData(ArrayList list) {
        this.m_fileList = list;
    }

    public ArrayList getInputData() {
        return this.m_fileList;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    protected ValidateResult validate() {
        ValidateResult result = null;
        result = this.createLogTransferFile();
        if (result != null) {
            return result;
        }
        return null;
    }
}

