/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.PriorityColorConstant;
import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.common.composite.JobIdSelectionListener;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorNumericValueInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NumericRunJobComposite
extends Composite {
    public static final int WIDTH_PRIORITY = 3;
    public static final int WIDTH_JOB_RUN = 1;
    public static final int WIDTH_JOB_ID = 4;
    public static final int WIDTH_REF_BTN = 2;
    public static final int WIDTH_INHIBITION_FLG = 3;
    public static final int WIDTH_FAILURE_PRIORITY = 2;
    private Button m_checkJobRunInfo = null;
    private Button m_checkJobRunWarning = null;
    private Button m_checkJobRunCritical = null;
    private Button m_checkJobRunUnknown = null;
    private Text m_textJobIdInfo = null;
    private Text m_textJobIdWarning = null;
    private Text m_textJobIdCritical = null;
    private Text m_textJobIdUnknown = null;
    private Button m_buttonReferInfo = null;
    private Button m_buttonReferWarning = null;
    private Button m_buttonReferCritical = null;
    private Button m_buttonReferUnknown = null;
    private Button m_checkInhibitionFlgInfo = null;
    private Button m_checkInhibitionFlgWarning = null;
    private Button m_checkInhibitionFlgCritical = null;
    private Button m_checkInhibitionFlgUnknown = null;
    private Combo m_comboFailurePriorityInfo = null;
    private Combo m_comboFailurePriorityWarning = null;
    private Combo m_comboFailurePriorityCritical = null;
    private Combo m_comboFailurePriorityUnknown = null;

    public NumericRunJobComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"priority"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"run"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"job.id"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"couple.with.notify.inhibition"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"failure.call.value"));
        label = this.getLabelPriority(this, Messages.getString((String)"info"), PriorityColorConstant.COLOR_INFO, 3);
        this.m_checkJobRunInfo = this.getCheckBox(this, 1);
        this.m_textJobIdInfo = this.getTextJobId(this, 4);
        this.m_buttonReferInfo = this.getButtonRefer(this, 2);
        this.m_checkInhibitionFlgInfo = this.getCheckBox(this, 3);
        this.m_comboFailurePriorityInfo = this.getComboPriority(this, 2);
        this.m_checkJobRunInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NumericRunJobComposite.this.setEnabled(NumericRunJobComposite.this.m_checkJobRunInfo.getSelection(), NumericRunJobComposite.this.m_textJobIdInfo, NumericRunJobComposite.this.m_buttonReferInfo, NumericRunJobComposite.this.m_checkInhibitionFlgInfo, NumericRunJobComposite.this.m_comboFailurePriorityInfo);
            }
        });
        this.m_buttonReferInfo.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobIdInfo));
        label = this.getLabelPriority(this, Messages.getString((String)"warning"), PriorityColorConstant.COLOR_WARNING, 3);
        this.m_checkJobRunWarning = this.getCheckBox(this, 1);
        this.m_textJobIdWarning = this.getTextJobId(this, 4);
        this.m_buttonReferWarning = this.getButtonRefer(this, 2);
        this.m_checkInhibitionFlgWarning = this.getCheckBox(this, 3);
        this.m_comboFailurePriorityWarning = this.getComboPriority(this, 2);
        this.m_checkJobRunWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NumericRunJobComposite.this.setEnabled(NumericRunJobComposite.this.m_checkJobRunWarning.getSelection(), NumericRunJobComposite.this.m_textJobIdWarning, NumericRunJobComposite.this.m_buttonReferWarning, NumericRunJobComposite.this.m_checkInhibitionFlgWarning, NumericRunJobComposite.this.m_comboFailurePriorityWarning);
            }
        });
        this.m_buttonReferWarning.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobIdWarning));
        label = this.getLabelPriority(this, Messages.getString((String)"critical"), PriorityColorConstant.COLOR_CRITICAL, 3);
        this.m_checkJobRunCritical = this.getCheckBox(this, 1);
        this.m_textJobIdCritical = this.getTextJobId(this, 4);
        this.m_buttonReferCritical = this.getButtonRefer(this, 2);
        this.m_checkInhibitionFlgCritical = this.getCheckBox(this, 3);
        this.m_comboFailurePriorityCritical = this.getComboPriority(this, 2);
        this.m_checkJobRunCritical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NumericRunJobComposite.this.setEnabled(NumericRunJobComposite.this.m_checkJobRunCritical.getSelection(), NumericRunJobComposite.this.m_textJobIdCritical, NumericRunJobComposite.this.m_buttonReferCritical, NumericRunJobComposite.this.m_checkInhibitionFlgCritical, NumericRunJobComposite.this.m_comboFailurePriorityCritical);
            }
        });
        this.m_buttonReferCritical.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobIdCritical));
        label = this.getLabelPriority(this, Messages.getString((String)"unknown"), PriorityColorConstant.COLOR_UNKNOWN, 3);
        this.m_checkJobRunUnknown = this.getCheckBox(this, 1);
        this.m_textJobIdUnknown = this.getTextJobId(this, 4);
        this.m_buttonReferUnknown = this.getButtonRefer(this, 2);
        this.m_checkInhibitionFlgUnknown = this.getCheckBox(this, 3);
        this.m_comboFailurePriorityUnknown = this.getComboPriority(this, 2);
        this.m_checkJobRunUnknown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NumericRunJobComposite.this.setEnabled(NumericRunJobComposite.this.m_checkJobRunUnknown.getSelection(), NumericRunJobComposite.this.m_textJobIdUnknown, NumericRunJobComposite.this.m_buttonReferUnknown, NumericRunJobComposite.this.m_checkInhibitionFlgUnknown, NumericRunJobComposite.this.m_comboFailurePriorityUnknown);
            }
        });
        this.m_buttonReferUnknown.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobIdUnknown));
    }

    public void setInputData(MonitorInfo info) {
        ArrayList list;
        if (info != null && (list = info.getJudgementInfo()) != null) {
            int index = 0;
            while (index < list.size()) {
                MonitorNumericValueInfo numericValueInfo = (MonitorNumericValueInfo)list.get(index);
                if (numericValueInfo != null) {
                    if (3 == numericValueInfo.getPriority()) {
                        this.m_checkJobRunInfo.setSelection(YesNoConstant.typeToBoolean((int)numericValueInfo.getJobRun()));
                        if (numericValueInfo.getJobId() != null) {
                            this.m_textJobIdInfo.setText(numericValueInfo.getJobId());
                        }
                        this.m_checkInhibitionFlgInfo.setSelection(YesNoConstant.typeToBoolean((int)numericValueInfo.getJobInhibitionFlg()));
                        this.m_comboFailurePriorityInfo.setText(PriorityConstant.typeToString((int)numericValueInfo.getJobFailurePriority()));
                    } else if (2 == numericValueInfo.getPriority()) {
                        this.m_checkJobRunWarning.setSelection(YesNoConstant.typeToBoolean((int)numericValueInfo.getJobRun()));
                        if (numericValueInfo.getJobId() != null) {
                            this.m_textJobIdWarning.setText(numericValueInfo.getJobId());
                        }
                        this.m_checkInhibitionFlgWarning.setSelection(YesNoConstant.typeToBoolean((int)numericValueInfo.getJobInhibitionFlg()));
                        this.m_comboFailurePriorityWarning.setText(PriorityConstant.typeToString((int)numericValueInfo.getJobFailurePriority()));
                    } else if (numericValueInfo.getPriority() == 0) {
                        this.m_checkJobRunCritical.setSelection(YesNoConstant.typeToBoolean((int)numericValueInfo.getJobRun()));
                        if (numericValueInfo.getJobId() != null) {
                            this.m_textJobIdCritical.setText(numericValueInfo.getJobId());
                        }
                        this.m_checkInhibitionFlgCritical.setSelection(YesNoConstant.typeToBoolean((int)numericValueInfo.getJobInhibitionFlg()));
                        this.m_comboFailurePriorityCritical.setText(PriorityConstant.typeToString((int)numericValueInfo.getJobFailurePriority()));
                    } else if (1 == numericValueInfo.getPriority()) {
                        this.m_checkJobRunUnknown.setSelection(YesNoConstant.typeToBoolean((int)numericValueInfo.getJobRun()));
                        if (numericValueInfo.getJobId() != null) {
                            this.m_textJobIdUnknown.setText(numericValueInfo.getJobId());
                        }
                        this.m_checkInhibitionFlgUnknown.setSelection(YesNoConstant.typeToBoolean((int)numericValueInfo.getJobInhibitionFlg()));
                        this.m_comboFailurePriorityUnknown.setText(PriorityConstant.typeToString((int)numericValueInfo.getJobFailurePriority()));
                    }
                }
                ++index;
            }
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        ValidateResult validateResult = null;
        validateResult = this.setMonitorNumericValueInfo(info, this.m_checkJobRunInfo, this.m_textJobIdInfo, this.m_checkInhibitionFlgInfo, this.m_comboFailurePriorityInfo, 3);
        if (validateResult != null) {
            return validateResult;
        }
        validateResult = this.setMonitorNumericValueInfo(info, this.m_checkJobRunWarning, this.m_textJobIdWarning, this.m_checkInhibitionFlgWarning, this.m_comboFailurePriorityWarning, 2);
        if (validateResult != null) {
            return validateResult;
        }
        validateResult = this.setMonitorNumericValueInfo(info, this.m_checkJobRunCritical, this.m_textJobIdCritical, this.m_checkInhibitionFlgCritical, this.m_comboFailurePriorityCritical, 0);
        if (validateResult != null) {
            return validateResult;
        }
        validateResult = this.setMonitorNumericValueInfo(info, this.m_checkJobRunUnknown, this.m_textJobIdUnknown, this.m_checkInhibitionFlgUnknown, this.m_comboFailurePriorityUnknown, 1);
        if (validateResult != null) {
            return validateResult;
        }
        return null;
    }

    public ValidateResult setMonitorNumericValueInfo(MonitorInfo info, Button checkRunJob, Text textJobId, Button checkInhibitionFlg, Combo comboFailurePriority, int priority) {
        Integer jobRun = YesNoConstant.booleanToType((boolean)checkRunJob.getSelection());
        String jobId = textJobId.getText();
        Integer jobInhibitionFlg = YesNoConstant.booleanToType((boolean)checkInhibitionFlg.getSelection());
        Integer jobFailurePriority = PriorityConstant.stringToType((String)comboFailurePriority.getText());
        boolean find = false;
        MonitorNumericValueInfo numericValueInfo = null;
        ArrayList list = info.getJudgementInfo();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                numericValueInfo = (MonitorNumericValueInfo)list.get(index);
                if (numericValueInfo != null && priority == numericValueInfo.getPriority()) {
                    find = true;
                    break;
                }
                ++index;
            }
        }
        if (!find) {
            numericValueInfo = new MonitorNumericValueInfo();
            numericValueInfo.setMonitorId(info.getMonitorId());
            numericValueInfo.setMonitorTypeId(info.getMonitorTypeId());
            numericValueInfo.setPriority(priority);
        }
        numericValueInfo.setJobRun(jobRun.intValue());
        if (jobId != null && !"".equals(jobId.trim())) {
            numericValueInfo.setJobId(jobId);
        } else if (info.getJobRun() == 1 && checkRunJob.getSelection()) {
            Object[] args = new String[]{"(" + PriorityConstant.typeToString((int)priority) + ")"};
            return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.25", (Object[])args));
        }
        numericValueInfo.setJobInhibitionFlg(jobInhibitionFlg.intValue());
        numericValueInfo.setJobFailurePriority(jobFailurePriority.intValue());
        if (!find) {
            list.add(numericValueInfo);
        }
        info.setJudgementInfo(list);
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, this.m_checkJobRunInfo, this.m_textJobIdInfo, this.m_buttonReferInfo, this.m_checkInhibitionFlgInfo, this.m_comboFailurePriorityInfo);
        this.setEnabled(enabled, this.m_checkJobRunWarning, this.m_textJobIdWarning, this.m_buttonReferWarning, this.m_checkInhibitionFlgWarning, this.m_comboFailurePriorityWarning);
        this.setEnabled(enabled, this.m_checkJobRunCritical, this.m_textJobIdCritical, this.m_buttonReferCritical, this.m_checkInhibitionFlgCritical, this.m_comboFailurePriorityCritical);
        this.setEnabled(enabled, this.m_checkJobRunUnknown, this.m_textJobIdUnknown, this.m_buttonReferUnknown, this.m_checkInhibitionFlgUnknown, this.m_comboFailurePriorityUnknown);
    }

    public void setEnabled(boolean enabled, Button checkJobRun, Text textJobId, Button buttonRefer, Button checkInhibitionFlg, Combo comboFailurePriority) {
        checkJobRun.setEnabled(enabled);
        if (enabled) {
            this.setEnabled(checkJobRun.getSelection(), textJobId, buttonRefer, checkInhibitionFlg, comboFailurePriority);
        } else {
            this.setEnabled(enabled, textJobId, buttonRefer, checkInhibitionFlg, comboFailurePriority);
        }
    }

    public void setEnabled(boolean enabled, Text textJobId, Button buttonRefer, Button checkInhibitionFlg, Combo comboFailurePriority) {
        textJobId.setEnabled(enabled);
        buttonRefer.setEnabled(enabled);
        checkInhibitionFlg.setEnabled(enabled);
        comboFailurePriority.setEnabled(enabled);
    }

    protected Label getLabelPriority(Composite parent, String text, Color background, int horizontalSpan) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan - 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(text) + " : ");
        label.setBackground(background);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Combo getComboPriority(Composite parent, int horizontalSpan) {
        Combo combo = new Combo((Composite)this, 12);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        combo.add(PriorityConstant.STRING_CRITICAL);
        combo.add(PriorityConstant.STRING_WARNING);
        combo.add(PriorityConstant.STRING_INFO);
        combo.add(PriorityConstant.STRING_UNKNOWN);
        combo.setText(PriorityConstant.STRING_UNKNOWN);
        return combo;
    }

    protected Button getCheckBox(Composite parent, int horizontalSpan) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected Text getTextJobId(Composite parent, int horizontalSpan) {
        Text text = new Text((Composite)this, 18440);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected Button getButtonRefer(Composite parent, int horizontalSpan) {
        Button button = new Button((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(Messages.getString((String)"refer"));
        return button;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

