/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.common.composite.JobIdSelectionListener;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TruthRunJobComposite
extends Composite {
    public static final int WIDTH_PRIORITY = 3;
    public static final int WIDTH_JOB_RUN = 1;
    public static final int WIDTH_JOB_ID = 4;
    public static final int WIDTH_REF_BTN = 2;
    public static final int WIDTH_INHIBITION_FLG = 3;
    public static final int WIDTH_FAILURE_PRIORITY = 2;
    private String m_itemTrue = null;
    private String m_itemFalse = null;
    private Button m_checkJobRunTrue = null;
    private Text m_textJobIdTrue = null;
    private Button m_buttonReferTrue = null;
    private Button m_checkInhibitionFlgTrue = null;
    private Combo m_comboFailurePriorityTrue = null;
    private Button m_checkJobRunFalse = null;
    private Text m_textJobIdFalse = null;
    private Button m_buttonReferFalse = null;
    private Button m_checkInhibitionFlgFalse = null;
    private Combo m_comboFailurePriorityFalse = null;

    public TruthRunJobComposite(Composite parent, int style, String itemTrue, String itemFalse) {
        super(parent, style);
        this.m_itemTrue = itemTrue;
        this.m_itemFalse = itemFalse;
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"value"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"run"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"job.id"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"couple.with.notify.inhibition"));
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString((String)"failure.call.value"));
        label = this.getLabelPriority(this, Messages.getString((String)this.m_itemTrue), 3);
        this.m_checkJobRunTrue = this.getCheckBox(this, 1);
        this.m_textJobIdTrue = this.getTextJobId(this, 4);
        this.m_buttonReferTrue = this.getButtonRefer(this, 2);
        this.m_checkInhibitionFlgTrue = this.getCheckBox(this, 3);
        this.m_comboFailurePriorityTrue = this.getComboPriority(this, 2);
        this.m_checkJobRunTrue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TruthRunJobComposite.this.setEnabled(TruthRunJobComposite.this.m_checkJobRunTrue.getSelection(), TruthRunJobComposite.this.m_textJobIdTrue, TruthRunJobComposite.this.m_buttonReferTrue, TruthRunJobComposite.this.m_checkInhibitionFlgTrue, TruthRunJobComposite.this.m_comboFailurePriorityTrue);
            }
        });
        this.m_buttonReferTrue.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobIdTrue));
        label = this.getLabelPriority(this, Messages.getString((String)this.m_itemFalse), 3);
        this.m_checkJobRunFalse = this.getCheckBox(this, 1);
        this.m_textJobIdFalse = this.getTextJobId(this, 4);
        this.m_buttonReferFalse = this.getButtonRefer(this, 2);
        this.m_checkInhibitionFlgFalse = this.getCheckBox(this, 3);
        this.m_comboFailurePriorityFalse = this.getComboPriority(this, 2);
        this.m_checkJobRunFalse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TruthRunJobComposite.this.setEnabled(TruthRunJobComposite.this.m_checkJobRunFalse.getSelection(), TruthRunJobComposite.this.m_textJobIdFalse, TruthRunJobComposite.this.m_buttonReferFalse, TruthRunJobComposite.this.m_checkInhibitionFlgFalse, TruthRunJobComposite.this.m_comboFailurePriorityFalse);
            }
        });
        this.m_buttonReferFalse.addSelectionListener((SelectionListener)new JobIdSelectionListener(this.m_textJobIdFalse));
    }

    public void setInputData(MonitorInfo info) {
        ArrayList list;
        if (info != null && (list = info.getJudgementInfo()) != null) {
            int index = 0;
            while (index < list.size()) {
                MonitorTruthValueInfo truthValueInfo = (MonitorTruthValueInfo)list.get(index);
                if (truthValueInfo != null) {
                    if (1 == truthValueInfo.getTruthValue()) {
                        this.m_checkJobRunTrue.setSelection(YesNoConstant.typeToBoolean((int)truthValueInfo.getJobRun()));
                        if (truthValueInfo.getJobId() != null) {
                            this.m_textJobIdTrue.setText(truthValueInfo.getJobId());
                        }
                        this.m_checkInhibitionFlgTrue.setSelection(YesNoConstant.typeToBoolean((int)truthValueInfo.getJobInhibitionFlg()));
                        this.m_comboFailurePriorityTrue.setText(PriorityConstant.typeToString((int)truthValueInfo.getJobFailurePriority()));
                    } else if (truthValueInfo.getTruthValue() == 0) {
                        this.m_checkJobRunFalse.setSelection(YesNoConstant.typeToBoolean((int)truthValueInfo.getJobRun()));
                        if (truthValueInfo.getJobId() != null) {
                            this.m_textJobIdFalse.setText(truthValueInfo.getJobId());
                        }
                        this.m_checkInhibitionFlgFalse.setSelection(YesNoConstant.typeToBoolean((int)truthValueInfo.getJobInhibitionFlg()));
                        this.m_comboFailurePriorityFalse.setText(PriorityConstant.typeToString((int)truthValueInfo.getJobFailurePriority()));
                    }
                }
                ++index;
            }
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        ValidateResult validateResult = null;
        validateResult = this.setMonitorTruthValueInfo(info, this.m_checkJobRunTrue, this.m_textJobIdTrue, this.m_checkInhibitionFlgTrue, this.m_comboFailurePriorityTrue, 1);
        if (validateResult != null) {
            return validateResult;
        }
        validateResult = this.setMonitorTruthValueInfo(info, this.m_checkJobRunFalse, this.m_textJobIdFalse, this.m_checkInhibitionFlgFalse, this.m_comboFailurePriorityFalse, 0);
        if (validateResult != null) {
            return validateResult;
        }
        return null;
    }

    public ValidateResult setMonitorTruthValueInfo(MonitorInfo info, Button checkRunJob, Text textJobId, Button checkInhibitionFlg, Combo comboFailurePriority, int truthValue) {
        Integer jobRun = YesNoConstant.booleanToType((boolean)checkRunJob.getSelection());
        String jobId = textJobId.getText();
        Integer jobInhibitionFlg = YesNoConstant.booleanToType((boolean)checkInhibitionFlg.getSelection());
        Integer jobFailurePriority = PriorityConstant.stringToType((String)comboFailurePriority.getText());
        boolean find = false;
        MonitorTruthValueInfo truthValueInfo = null;
        ArrayList list = info.getJudgementInfo();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                truthValueInfo = (MonitorTruthValueInfo)list.get(index);
                if (truthValueInfo != null && truthValue == truthValueInfo.getTruthValue()) {
                    find = true;
                    break;
                }
                ++index;
            }
        }
        if (!find) {
            truthValueInfo = new MonitorTruthValueInfo();
            truthValueInfo.setMonitorId(info.getMonitorId());
            truthValueInfo.setMonitorTypeId(info.getMonitorTypeId());
            truthValueInfo.setTruthValue(truthValue);
        }
        truthValueInfo.setJobRun(jobRun.intValue());
        if (jobId != null && !"".equals(jobId.trim())) {
            truthValueInfo.setJobId(jobId);
        } else if (info.getJobRun() == 1 && checkRunJob.getSelection()) {
            String tmp = null;
            if (truthValue == 1) {
                tmp = this.m_itemTrue;
            } else if (truthValue == 0) {
                tmp = this.m_itemFalse;
            }
            Object[] args = new String[]{"(" + tmp + ")"};
            return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.25", (Object[])args));
        }
        truthValueInfo.setJobInhibitionFlg(jobInhibitionFlg.intValue());
        truthValueInfo.setJobFailurePriority(jobFailurePriority.intValue());
        if (!find) {
            list.add(truthValueInfo);
        }
        info.setJudgementInfo(list);
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, this.m_checkJobRunTrue, this.m_textJobIdTrue, this.m_buttonReferTrue, this.m_checkInhibitionFlgTrue, this.m_comboFailurePriorityTrue);
        this.setEnabled(enabled, this.m_checkJobRunFalse, this.m_textJobIdFalse, this.m_buttonReferFalse, this.m_checkInhibitionFlgFalse, this.m_comboFailurePriorityFalse);
    }

    public void setEnabled(boolean enabled, Button checkJobRun, Text textJobId, Button buttonRefer, Button checkInhibitionFlg, Combo comboFailurePriority) {
        checkJobRun.setEnabled(enabled);
        if (enabled) {
            this.setEnabled(checkJobRun.getSelection(), textJobId, buttonRefer, checkInhibitionFlg, comboFailurePriority);
        } else {
            this.setEnabled(enabled, textJobId, buttonRefer, checkInhibitionFlg, comboFailurePriority);
        }
    }

    public void setEnabled(boolean enabled, Text textJobId, Button buttonRefer, Button checkInhibitionFlg, Combo comboFailurePriority) {
        textJobId.setEnabled(enabled);
        buttonRefer.setEnabled(enabled);
        checkInhibitionFlg.setEnabled(enabled);
        comboFailurePriority.setEnabled(enabled);
    }

    protected Label getLabelPriority(Composite parent, String text, int horizontalSpan) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(text) + " : ");
        return label;
    }

    protected Combo getComboPriority(Composite parent, int horizontalSpan) {
        Combo combo = new Combo((Composite)this, 12);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        combo.add(PriorityConstant.STRING_CRITICAL);
        combo.add(PriorityConstant.STRING_WARNING);
        combo.add(PriorityConstant.STRING_INFO);
        combo.add(PriorityConstant.STRING_UNKNOWN);
        combo.setText(PriorityConstant.STRING_UNKNOWN);
        return combo;
    }

    protected Button getCheckBox(Composite parent, int horizontalSpan) {
        Button button = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 2;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        return button;
    }

    protected Text getTextJobId(Composite parent, int horizontalSpan) {
        Text text = new Text((Composite)this, 18440);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        return text;
    }

    protected Button getButtonRefer(Composite parent, int horizontalSpan) {
        Button button = new Button((Composite)this, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = horizontalSpan;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)gridData);
        button.setText(Messages.getString((String)"refer"));
        return button;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

