/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.model.ConfiguredFeatureAdapter;
import org.eclipse.update.internal.ui.views.ConfigurationView;
import org.eclipse.update.operations.IUnconfigFeatureOperation;
import org.eclipse.update.operations.OperationsManager;

public class FeatureStateAction
extends Action {
    private ConfiguredFeatureAdapter adapter;
    private ConfigurationView parent;

    public FeatureStateAction(ConfigurationView parent) {
        this.parent = parent;
    }

    public void setFeature(ConfiguredFeatureAdapter adapter) {
        this.adapter = adapter;
        if (adapter.isConfigured()) {
            this.setText(UpdateUIMessages.FeatureStateAction_disable);
        } else {
            this.setText(UpdateUIMessages.FeatureStateAction_enable);
        }
    }

    public void run() {
        try {
            String message;
            if (this.adapter == null) {
                return;
            }
            IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
            if (status != null) {
                throw new CoreException(status);
            }
            boolean isConfigured = this.adapter.isConfigured();
            String string = message = isConfigured ? UpdateUIMessages.FeatureStateAction_disableQuestion : UpdateUIMessages.FeatureStateAction_EnableQuestion;
            if (!this.confirm(message)) {
                return;
            }
            if (OperationsManager.getValidator().validateCurrentState() != null && !this.confirm(UpdateUIMessages.Actions_brokenConfigQuestion)) {
                return;
            }
            IUnconfigFeatureOperation toggleOperation = isConfigured ? OperationsManager.getOperationFactory().createUnconfigOperation(this.adapter.getConfiguredSite(), this.adapter.getFeature(null)) : OperationsManager.getOperationFactory().createConfigOperation(this.adapter.getConfiguredSite(), this.adapter.getFeature(null));
            boolean restartNeeded = toggleOperation.execute(null, null);
            UpdateUI.requestRestart(restartNeeded);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.parent.getConfigurationWindow().getShell(), null, null, (IStatus)e.getStatus());
        }
        catch (InvocationTargetException e) {
            UpdateUtils.logException((Throwable)e.getTargetException());
        }
    }

    private boolean confirm(String message) {
        return MessageDialog.openConfirm((Shell)this.parent.getConfigurationWindow().getShell(), (String)UpdateUIMessages.FeatureStateAction_dialogTitle, (String)message);
    }
}

