/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.factory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.bean.ViewListInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.collectiverun.factory.SelectMaster;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SelectSession {
    protected static Log m_log = LogFactory.getLog(SelectSession.class);
    private static final int MAX_DISPLAY_NUMBER = 500;

    public ViewListInfo getHistoryList(Locale locale, int histories) throws FinderException, NamingException {
        ViewListInfo list = new ViewListInfo();
        ArrayList history = new ArrayList();
        int total = 0;
        if (histories <= 0) {
            histories = 500;
        }
        Integer limit = new Integer(histories + 1);
        Collection sessionList = CRunSessionUtil.getLocalHome().selectHistoryFilter(null, null, null, null, null, null, limit);
        if (sessionList != null) {
            if (sessionList.size() > histories) {
                Collection allHistory = CRunSessionUtil.getLocalHome().selectHistoryFilter(null, null, null, null, null, null, null);
                total = allHistory.size();
            } else {
                total = sessionList.size();
            }
            for (CRunSessionLocal session : sessionList) {
                CRunCmdMstLocal cmd = null;
                try {
                    cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
                }
                catch (FinderException e) {
                    // empty catch block
                }
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(session.getStatus());
                info.add(session.getSession_id());
                info.add(session.getStart_date());
                info.add(session.getEnd_date());
                String name = SelectMaster.typeIdToString(session.getType_id(), locale);
                if (name != null) {
                    info.add(name);
                } else {
                    info.add("");
                }
                if (cmd != null) {
                    info.add(Messages.getString((String)cmd.getName_id(), (Locale)locale));
                } else {
                    info.add("");
                }
                info.add(session.getFacility_id());
                info.add(session.getScope_text());
                info.add(session.getNode_cnt());
                info.add(session.getEnd_nomal_cnt());
                info.add(session.getEnd_warning_cnt());
                info.add(session.getEnd_abnomal_cnt());
                info.add(session.getWait_cnt());
                info.add(session.getRunning_cnt());
                history.add(info);
                if (history.size() < histories) continue;
                break;
            }
        }
        list.setTotal(total);
        list.setList(history);
        return list;
    }

    public ViewListInfo getHistoryList(Property property, Locale locale, int histories) throws FinderException, NamingException {
        Collection sessionList;
        ArrayList values = null;
        values = PropertyUtil.getPropertyValue((Property)property, (String)"startFromDate");
        Date startFromDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            startFromDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"startToDate");
        Date startToDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            startToDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"endFromDate");
        Date endFromDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            endFromDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"endToDate");
        Date endToDate = null;
        if (values.get(0) != null && values.get(0) instanceof Date) {
            endToDate = (Date)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"type");
        String type = null;
        if (values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            String typeString = (String)values.get(0);
            type = SelectMaster.stringToTypeId(typeString, locale);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"status");
        Integer status = null;
        if (values.get(0) instanceof String) {
            String statusString = (String)values.get(0);
            status = new Integer(StatusConstant.stringToType((String)statusString));
        }
        ViewListInfo list = new ViewListInfo();
        ArrayList history = new ArrayList();
        int total = 0;
        if (histories <= 0) {
            histories = 500;
        }
        if ((sessionList = CRunSessionUtil.getLocalHome().selectHistoryFilter(startFromDate, startToDate, endFromDate, endToDate, type, status, histories)) != null) {
            total = sessionList.size();
            for (CRunSessionLocal session : sessionList) {
                CRunCmdMstLocal cmd = null;
                try {
                    cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
                }
                catch (FinderException e) {
                    // empty catch block
                }
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(session.getStatus());
                info.add(session.getSession_id());
                info.add(session.getStart_date());
                info.add(session.getEnd_date());
                String name = SelectMaster.typeIdToString(session.getType_id(), locale);
                if (name != null) {
                    info.add(name);
                } else {
                    info.add("");
                }
                if (cmd != null) {
                    info.add(Messages.getString((String)cmd.getName_id(), (Locale)locale));
                } else {
                    info.add("");
                }
                info.add(session.getFacility_id());
                info.add(session.getScope_text());
                info.add(session.getNode_cnt());
                info.add(session.getEnd_nomal_cnt());
                info.add(session.getEnd_warning_cnt());
                info.add(session.getEnd_abnomal_cnt());
                info.add(session.getWait_cnt());
                info.add(session.getRunning_cnt());
                history.add(info);
                if (history.size() < histories) continue;
                break;
            }
        }
        list.setTotal(total);
        list.setList(history);
        return list;
    }

    public ArrayList getDetailList(String sessionId, Locale locale) throws FinderException, NamingException {
        ArrayList list = new ArrayList();
        Collection detailList = CRunSessionDetailUtil.getLocalHome().findBySessionId(sessionId);
        if (detailList != null) {
            for (CRunSessionDetailLocal detail : detailList) {
                ArrayList<Object> info = new ArrayList<Object>();
                info.add(detail.getStatus());
                info.add(detail.getEnd_status());
                info.add(detail.getEnd_value());
                info.add(detail.getFacility_id());
                info.add(detail.getFacility_name());
                info.add(detail.getStart_date());
                info.add(detail.getEnd_date());
                StringBuffer message = new StringBuffer();
                if (detail.getMessage() != null) {
                    message.append(detail.getMessage());
                }
                if (detail.getError_message() != null) {
                    message.append(detail.getError_message());
                }
                info.add(message.toString());
                list.add(info);
            }
        }
        return list;
    }
}

