/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil2;

import java.io.IOException;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.Connection;
import org.jboss.mq.ConnectionToken;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.Subscription;
import org.jboss.mq.TransactionRequest;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.uil2.SocketManager;
import org.jboss.mq.il.uil2.msgs.AcknowledgementRequestMsg;
import org.jboss.mq.il.uil2.msgs.AddMsg;
import org.jboss.mq.il.uil2.msgs.BrowseMsg;
import org.jboss.mq.il.uil2.msgs.CheckIDMsg;
import org.jboss.mq.il.uil2.msgs.CheckUserMsg;
import org.jboss.mq.il.uil2.msgs.CloseMsg;
import org.jboss.mq.il.uil2.msgs.ConnectionTokenMsg;
import org.jboss.mq.il.uil2.msgs.CreateDestMsg;
import org.jboss.mq.il.uil2.msgs.DeleteSubscriptionMsg;
import org.jboss.mq.il.uil2.msgs.DeleteTemporaryDestMsg;
import org.jboss.mq.il.uil2.msgs.EnableConnectionMsg;
import org.jboss.mq.il.uil2.msgs.GetIDMsg;
import org.jboss.mq.il.uil2.msgs.MsgTypes;
import org.jboss.mq.il.uil2.msgs.PingMsg;
import org.jboss.mq.il.uil2.msgs.ReceiveMsg;
import org.jboss.mq.il.uil2.msgs.SubscribeMsg;
import org.jboss.mq.il.uil2.msgs.TemporaryDestMsg;
import org.jboss.mq.il.uil2.msgs.TransactMsg;
import org.jboss.mq.il.uil2.msgs.UnsubscribeMsg;

public class UILServerIL
implements Cloneable,
MsgTypes,
Serializable,
ServerIL {
    private static final long serialVersionUID = 853594001646066224L;
    private static Logger log = Logger.getLogger(UILServerIL.class);
    private static final String USE_SERVER_HOST = "org.jboss.mq.il.uil2.useServerHost";
    private static final String LOCAL_ADDR = "org.jboss.mq.il.uil2.localAddr";
    private static final String LOCAL_PORT = "org.jboss.mq.il.uil2.localPort";
    private static final String SERVER_ADDR = "org.jboss.mq.il.uil2.serverAddr";
    private static final String SERVER_PORT = "org.jboss.mq.il.uil2.serverPort";
    private static final String RETRY_COUNT = "org.jboss.mq.il.uil2.retryCount";
    private static final String RETRY_DELAY = "org.jboss.mq.il.uil2.retryDelay";
    private InetAddress addr;
    private int port;
    private String socketFactoryName;
    private boolean enableTcpNoDelay = false;
    private int soTimeout = 0;
    private String connectAddress;
    private int connectPort = 0;
    private int bufferSize;
    private int chunkSize;
    private transient InetAddress localAddr;
    private transient int localPort;
    protected transient Socket socket;
    protected transient SocketManager socketMgr;

    public UILServerIL(InetAddress addr, int port, String socketFactoryName, boolean enableTcpNoDelay, int bufferSize, int chunkSize, int soTimeout, String connectAddress, int connectPort) throws Exception {
        this.addr = addr;
        this.port = port;
        this.socketFactoryName = socketFactoryName;
        this.enableTcpNoDelay = enableTcpNoDelay;
        this.bufferSize = bufferSize;
        this.chunkSize = chunkSize;
        this.soTimeout = soTimeout;
        this.connectAddress = connectAddress;
        this.connectPort = connectPort;
    }

    public void setConnectionToken(ConnectionToken dest) throws Exception {
        ConnectionTokenMsg msg = new ConnectionTokenMsg(dest);
        this.getSocketMgr().sendMessage(msg);
    }

    public void setEnabled(ConnectionToken dc, boolean enabled) throws JMSException, Exception {
        EnableConnectionMsg msg = new EnableConnectionMsg(enabled);
        this.getSocketMgr().sendMessage(msg);
    }

    public String getID() throws Exception {
        GetIDMsg msg = new GetIDMsg();
        this.getSocketMgr().sendMessage(msg);
        String id = msg.getID();
        return id;
    }

    public TemporaryQueue getTemporaryQueue(ConnectionToken dc) throws JMSException, Exception {
        TemporaryDestMsg msg = new TemporaryDestMsg(true);
        this.getSocketMgr().sendMessage(msg);
        TemporaryQueue dest = msg.getQueue();
        return dest;
    }

    public TemporaryTopic getTemporaryTopic(ConnectionToken dc) throws JMSException, Exception {
        TemporaryDestMsg msg = new TemporaryDestMsg(false);
        this.getSocketMgr().sendMessage(msg);
        TemporaryTopic dest = msg.getTopic();
        return dest;
    }

    public void acknowledge(ConnectionToken dc, AcknowledgementRequest item) throws JMSException, Exception {
        AcknowledgementRequestMsg msg = new AcknowledgementRequestMsg(item);
        this.getSocketMgr().sendMessage(msg);
    }

    public void addMessage(ConnectionToken dc, SpyMessage val) throws Exception {
        AddMsg msg = new AddMsg(val);
        this.getSocketMgr().sendMessage(msg);
    }

    public SpyMessage[] browse(ConnectionToken dc, Destination dest, String selector) throws JMSException, Exception {
        BrowseMsg msg = new BrowseMsg(dest, selector);
        this.getSocketMgr().sendMessage(msg);
        SpyMessage[] msgs = msg.getMessages();
        return msgs;
    }

    public void checkID(String id) throws JMSException, Exception {
        CheckIDMsg msg = new CheckIDMsg(id);
        this.getSocketMgr().sendMessage(msg);
    }

    public String checkUser(String username, String password) throws JMSException, Exception {
        CheckUserMsg msg = new CheckUserMsg(username, password, false);
        this.getSocketMgr().sendMessage(msg);
        String clientID = msg.getID();
        return clientID;
    }

    public String authenticate(String username, String password) throws JMSException, Exception {
        CheckUserMsg msg = new CheckUserMsg(username, password, true);
        this.getSocketMgr().sendMessage(msg);
        String sessionID = msg.getID();
        return sessionID;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public ServerIL cloneServerIL() throws Exception {
        return (ServerIL)this.clone();
    }

    public void connectionClosing(ConnectionToken dc) throws JMSException, Exception {
        CloseMsg msg = new CloseMsg();
        try {
            this.getSocketMgr().sendMessage(msg);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.destroyConnection();
    }

    public Queue createQueue(ConnectionToken dc, String destName) throws JMSException, Exception {
        CreateDestMsg msg = new CreateDestMsg(destName, true);
        this.getSocketMgr().sendMessage(msg);
        Queue dest = msg.getQueue();
        return dest;
    }

    public Topic createTopic(ConnectionToken dc, String destName) throws JMSException, Exception {
        CreateDestMsg msg = new CreateDestMsg(destName, false);
        this.getSocketMgr().sendMessage(msg);
        Topic dest = msg.getTopic();
        return dest;
    }

    public void deleteTemporaryDestination(ConnectionToken dc, SpyDestination dest) throws JMSException, Exception {
        DeleteTemporaryDestMsg msg = new DeleteTemporaryDestMsg(dest);
        this.getSocketMgr().sendMessage(msg);
    }

    public void destroySubscription(ConnectionToken dc, DurableSubscriptionID id) throws JMSException, Exception {
        DeleteSubscriptionMsg msg = new DeleteSubscriptionMsg(id);
        this.getSocketMgr().sendMessage(msg);
    }

    public void ping(ConnectionToken dc, long clientTime) throws Exception {
        PingMsg msg = new PingMsg(clientTime, true);
        msg.getMsgID();
        this.getSocketMgr().sendReply(msg);
    }

    public SpyMessage receive(ConnectionToken dc, int subscriberId, long wait) throws Exception, Exception {
        ReceiveMsg msg = new ReceiveMsg(subscriberId, wait);
        this.getSocketMgr().sendMessage(msg);
        SpyMessage reply = msg.getMessage();
        return reply;
    }

    public void subscribe(ConnectionToken dc, Subscription s) throws JMSException, Exception {
        SubscribeMsg msg = new SubscribeMsg(s);
        this.getSocketMgr().sendMessage(msg);
    }

    public void transact(ConnectionToken dc, TransactionRequest t) throws JMSException, Exception {
        TransactMsg msg = new TransactMsg(t);
        this.getSocketMgr().sendMessage(msg);
    }

    public void unsubscribe(ConnectionToken dc, int subscriptionID) throws JMSException, Exception {
        UnsubscribeMsg msg = new UnsubscribeMsg(subscriptionID);
        this.getSocketMgr().sendMessage(msg);
    }

    final SocketManager getSocketMgr() throws Exception {
        if (this.socketMgr == null) {
            this.createConnection();
        }
        return this.socketMgr;
    }

    protected void checkConnection() throws Exception {
        if (this.socketMgr == null) {
            this.createConnection();
        }
    }

    protected void createConnection() throws Exception {
        String tmp;
        boolean tracing = log.isTraceEnabled();
        SocketFactory socketFactory = null;
        if (this.socketFactoryName != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = loader.loadClass(this.socketFactoryName);
                socketFactory = (SocketFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                log.debug("Failed to load socket factory: " + this.socketFactoryName, e);
            }
        }
        if (socketFactory == null) {
            socketFactory = SocketFactory.getDefault();
        }
        if ((tmp = this.getProperty(LOCAL_ADDR)) != null) {
            this.localAddr = InetAddress.getByName(tmp);
        }
        if ((tmp = this.getProperty(LOCAL_PORT)) != null) {
            this.localPort = Integer.parseInt(tmp);
        }
        InetAddress serverAddr = this.addr;
        int serverPort = this.port;
        tmp = this.getProperty(SERVER_ADDR);
        if (tmp == null) {
            tmp = this.connectAddress;
        }
        if (tmp != null) {
            serverAddr = InetAddress.getByName(tmp);
        }
        if ((tmp = this.getProperty(SERVER_PORT)) != null) {
            serverPort = Integer.parseInt(tmp);
        } else if (this.connectPort != 0) {
            serverPort = this.connectPort;
        }
        String useHostNameProp = this.getProperty(USE_SERVER_HOST);
        String serverHost = serverAddr.getHostAddress();
        if (Boolean.valueOf(useHostNameProp).booleanValue()) {
            serverHost = serverAddr.getHostName();
        }
        int retries = 0;
        int maxRetries = 10;
        tmp = this.getProperty(RETRY_COUNT);
        if (tmp != null) {
            maxRetries = Integer.parseInt(tmp);
        }
        long retryDelay = 0L;
        tmp = this.getProperty(RETRY_DELAY);
        if (tmp != null && (retryDelay = Long.parseLong(tmp)) < 0L) {
            retryDelay = 0L;
        }
        if (tracing) {
            log.trace("Begin connect loop, maxRetries=" + maxRetries + ", delay=" + retryDelay);
        }
        while (true) {
            try {
                if (tracing) {
                    log.trace("Connecting with addr=" + serverHost + ", port=" + serverPort + ", localAddr=" + this.localAddr + ", localPort=" + this.localPort + ", socketFactory=" + socketFactory + ", enableTcpNoDelay=" + this.enableTcpNoDelay + ", bufferSize=" + this.bufferSize + ", chunkSize=" + this.chunkSize);
                }
                if (this.localAddr != null) {
                    this.socket = socketFactory.createSocket(serverHost, serverPort, this.localAddr, this.localPort);
                    break;
                }
                this.socket = socketFactory.createSocket(serverHost, serverPort);
                break;
            }
            catch (ConnectException e) {
                if (++retries > maxRetries) {
                    throw e;
                }
                if (tracing) {
                    log.trace("Failed to connect, retries=" + retries, e);
                }
                try {
                    Thread.sleep(retryDelay);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                    break;
                }
            }
        }
        this.socket.setTcpNoDelay(this.enableTcpNoDelay);
        if (this.soTimeout != 0) {
            this.socket.setSoTimeout(this.soTimeout);
        }
        this.socketMgr = new SocketManager(this.socket);
        this.socketMgr.setBufferSize(this.bufferSize);
        this.socketMgr.setChunkSize(this.chunkSize);
        this.socketMgr.start(Connection.getThreadGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyConnection() {
        block5: {
            try {
                if (this.socket == null) break block5;
                try {
                    this.socketMgr.stop();
                }
                finally {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getProperty(String name) {
        String value = null;
        try {
            value = System.getProperty(name);
        }
        catch (Throwable ignored) {
            log.trace("Cannot retrieve system property " + name);
        }
        return value;
    }
}

