/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.OutputMultiplexor;
import org.jboss.remoting.transport.multiplex.SocketId;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class MultiplexingOutputStream
extends OutputStream {
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$multiplex$MultiplexingOutputStream == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexingOutputStream = MultiplexingOutputStream.class$("org.jboss.remoting.transport.multiplex.MultiplexingOutputStream")) : class$org$jboss$remoting$transport$multiplex$MultiplexingOutputStream);
    private MultiplexingManager manager;
    private OutputMultiplexor outputMultiplexor;
    private VirtualSocket virtualSocket;
    private SocketId socketId;
    private boolean shutdown = false;
    private boolean closed = false;
    private boolean remoteShutDownPending = false;
    private boolean remoteOutputShutdown = false;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiplexingOutputStream;

    public MultiplexingOutputStream(MultiplexingManager manager, SocketId socketId) {
        this(manager, null, socketId);
    }

    public MultiplexingOutputStream(MultiplexingManager manager, VirtualSocket virtualSocket, SocketId socketId) {
        this.manager = manager;
        this.virtualSocket = virtualSocket;
        this.socketId = socketId;
        this.outputMultiplexor = manager.getOutputMultiplexor();
    }

    public void write(int i) throws IOException {
        this.checkStatus();
        this.outputMultiplexor.write(this.socketId, new byte[]{(byte)i});
    }

    public void write(byte[] array) throws IOException, NullPointerException {
        this.checkStatus();
        this.outputMultiplexor.write(this.socketId, array);
    }

    public void write(byte[] array, int off, int len) throws IOException, NullPointerException, IndexOutOfBoundsException {
        this.checkStatus();
        if (array == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > array.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] subArray = new byte[len];
        for (int i = 0; i < len; ++i) {
            subArray[i] = array[off + i];
        }
        this.outputMultiplexor.write(this.socketId, subArray);
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.virtualSocket != null) {
            this.virtualSocket.close();
        }
    }

    protected void checkStatus() throws IOException {
        if (this.closed) {
            throw new SocketException("Socket closed");
        }
        if (this.shutdown) {
            throw new SocketException("Broken pipe");
        }
    }

    protected void handleRemoteInputShutdown() {
        log.debug("entering handleRemoteInputShutdown()");
        this.shutdown = true;
    }

    protected void shutdown() {
        this.shutdown = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

