/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityAssociationAuthenticator;

public class SecurityAssociationAuthenticator
extends Authenticator {
    protected PasswordAuthentication getPasswordAuthentication() {
        SecurityActions sa = SecurityActions.UTIL.getSecurityActions();
        Principal principal = sa.getPrincipal();
        Object credential = sa.getCredential();
        String name = principal != null ? principal.getName() : null;
        char[] password = new char[]{};
        if (credential != null) {
            password = password.getClass().isInstance(credential) ? (char[])credential : credential.toString().toCharArray();
        }
        PasswordAuthentication auth = new PasswordAuthentication(name, password);
        return auth;
    }

    static interface SecurityActions {
        public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

            public Principal getPrincipal() {
                return SecurityAssociation.getPrincipal();
            }

            public Object getCredential() {
                return SecurityAssociation.getCredential();
            }
        };
        public static final SecurityActions PRIVILEGED = new SecurityActions(){
            private final PrivilegedAction getPrincipalAction;
            private final PrivilegedAction getCredentialAction;
            {
                this.getPrincipalAction = new PrivilegedAction(this){
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return SecurityAssociation.getPrincipal();
                    }
                };
                this.getCredentialAction = new PrivilegedAction(this){
                    private final /* synthetic */ 2 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return SecurityAssociation.getCredential();
                    }
                };
            }

            public Principal getPrincipal() {
                return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
            }

            public Object getCredential() {
                return AccessController.doPrivileged(this.getCredentialAction);
            }
        };

        public Principal getPrincipal();

        public Object getCredential();

        public static class UTIL {
            static SecurityActions getSecurityActions() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }
        }
    }
}

