/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.bean;

import com.clustercontrol.jobmanagement.bean.JobInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JobTreeItem
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5749478055659165471L;
    protected JobInfo m_data;
    protected List<JobTreeItem> m_children = new ArrayList<JobTreeItem>();
    protected JobTreeItem m_parent;
    public static final String SEPARATOR = ">";

    public JobTreeItem() {
    }

    public JobTreeItem(JobInfo data) {
        this.setData(data);
    }

    public JobTreeItem(JobTreeItem parent, JobInfo data) {
        this.setParent(parent);
        this.setData(data);
        if (parent != null) {
            parent.addChildren(this);
        }
        this.m_children = new ArrayList<JobTreeItem>();
    }

    public void setParent(JobTreeItem parent) {
        this.m_parent = parent;
    }

    public JobTreeItem getParent() {
        return this.m_parent;
    }

    public void setData(JobInfo data) {
        this.m_data = data;
    }

    public JobInfo getData() {
        return this.m_data;
    }

    public void addChildren(JobTreeItem child) {
        this.m_children.add(child);
        child.setParent(this);
    }

    public void removeChildren(JobTreeItem child) {
        int i = 0;
        while (i < this.m_children.size()) {
            if (child.equals(this.m_children.get(i))) {
                this.m_children.remove(i);
                break;
            }
            ++i;
        }
    }

    public int size() {
        return this.m_children.size();
    }

    public JobTreeItem getChildren(int index) {
        return this.m_children.get(index);
    }

    public JobTreeItem[] getChildren() {
        return this.m_children.toArray(new JobTreeItem[this.m_children.size()]);
    }

    public String getPath() {
        if (this.getData().getType() == -1) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getData().getName());
        JobTreeItem parent = this.getParent();
        while (parent != null && parent.getData().getType() != -1) {
            buffer.insert(0, SEPARATOR);
            buffer.insert(0, parent.getData().getName());
            parent = parent.getParent();
        }
        return buffer.toString();
    }

    public Object clone() {
        try {
            JobTreeItem clone = (JobTreeItem)super.clone();
            clone.setData((JobInfo)this.getData().clone());
            clone.m_children = new ArrayList<JobTreeItem>();
            if (this.m_children != null && this.m_children instanceof ArrayList) {
                int i = 0;
                while (i < this.m_children.size()) {
                    JobTreeItem source = this.m_children.get(i);
                    if (source != null && source instanceof JobTreeItem) {
                        clone.addChildren((JobTreeItem)source.clone());
                    }
                    ++i;
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

