/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.invocation.MarshalledValue;
import org.jboss.invocation.MarshalledValueInputStream;
import org.jboss.invocation.MarshalledValueOutputStream;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.web.tomcat.tc5.session.ClusteredSession;
import org.jboss.web.tomcat.tc5.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.tc5.session.JBossCacheManager;
import org.jgroups.View;

public class JBossCacheService
implements TreeCacheListener {
    private TreeCacheMBean proxy_;
    private ObjectName cacheServiceName_;
    protected static Logger log_ = Logger.getLogger((Class)(class$org$jboss$web$tomcat$tc5$session$JBossCacheService == null ? (class$org$jboss$web$tomcat$tc5$session$JBossCacheService = JBossCacheService.class$("org.jboss.web.tomcat.tc5.session.JBossCacheService")) : class$org$jboss$web$tomcat$tc5$session$JBossCacheService));
    public static final String SESSION = "JSESSION";
    public static final String ATTRIBUTE = "ATTRIBUTE";
    public static final String KEY = "ATRR_KEY";
    private static final int RETRY = 3;
    private static final String VERSION_KEY = "VERSION";
    private String jvmRoute_;
    private String hostName_;
    private String webAppPath_;
    private List newSessionIDList_;
    private ClassLoader tcl_;
    private JBossCacheManager manager_;
    private Fqn webAppRoot_;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$session$JBossCacheService;
    static /* synthetic */ Class class$org$jboss$cache$TreeCacheMBean;

    public JBossCacheService() throws ClusteringNotSupportedException {
        this("jboss.cache:service=TomcatClusteringCache");
    }

    public JBossCacheService(String treeCacheObjectName) throws ClusteringNotSupportedException {
        try {
            this.cacheServiceName_ = new ObjectName(treeCacheObjectName);
            this.proxy_ = (TreeCacheMBean)MBeanProxyExt.create((Class)(class$org$jboss$cache$TreeCacheMBean == null ? (class$org$jboss$cache$TreeCacheMBean = JBossCacheService.class$("org.jboss.cache.TreeCacheMBean")) : class$org$jboss$cache$TreeCacheMBean), (ObjectName)this.cacheServiceName_);
            if (this.proxy_ == null) {
                throw new RuntimeException("JBossCacheService: locate null TomcatCacheMbean");
            }
            this.newSessionIDList_ = new ArrayList();
        }
        catch (Throwable e) {
            String str = this.cacheServiceName_ + " service to Tomcat clustering not found";
            log_.error((Object)str);
            throw new ClusteringNotSupportedException(str);
        }
    }

    public void start(ClassLoader tcl, JBossCacheManager manager) {
        this.tcl_ = tcl;
        this.manager_ = manager;
        this.jvmRoute_ = null;
        Context webapp = (Context)this.manager_.getContainer();
        String path = webapp.getName();
        this.webAppPath_ = path.length() == 0 || path.equals("/") ? "ROOT" : (path.startsWith("/") ? path.substring(1) : path);
        log_.debug((Object)("Old and new web app path are: " + path + ", " + this.webAppPath_));
        String host = webapp.getParent().getName();
        this.hostName_ = host == null || host.length() == 0 ? "localhost" : host;
        log_.debug((Object)("Old and new virtual host name are: " + host + ", " + this.hostName_));
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
        this.webAppRoot_ = new Fqn(objs);
        this.proxy_.addTreeCacheListener((TreeCacheListener)this);
    }

    public void stop() {
        this.proxy_.removeTreeCacheListener((TreeCacheListener)this);
    }

    public List findSessionIDs() {
        ArrayList ids = new ArrayList();
        try {
            Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_};
            Fqn path = new Fqn(objs);
            Set names = this.proxy_.getChildrenNames(path);
            if (names == null) {
                return ids;
            }
            Iterator it = names.iterator();
            while (it.hasNext()) {
                Object id = it.next();
                if (id == null) continue;
                ids.add(id);
                if (!log_.isTraceEnabled()) continue;
                log_.trace((Object)("Retrieving through web app path with fqn: " + path + " and session id: " + id));
            }
        }
        catch (CacheException e) {
            e.printStackTrace();
            throw new RuntimeException("JBossCacheService: exception occurred in cache getChildrenNames ... ", e);
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredSession loadSession(String realId, ClusteredSession toLoad) {
        Fqn fqn = this.getSessionFqn(realId);
        byte[] sessionData = (byte[])this._get(fqn, realId);
        if (sessionData == null) {
            return null;
        }
        ClassLoader prevTCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.tcl_);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(sessionData);
            MarshalledValueInputStream input = new MarshalledValueInputStream((InputStream)bais);
            toLoad.readExternal((ObjectInput)input);
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            ClusteredSession clusteredSession = null;
            return clusteredSession;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevTCL);
        }
        return toLoad;
    }

    public void putSession(String id, Object session) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getSessionFqn(realId);
        this._put(fqn, realId, this.externalizeSession((ClusteredSession)session));
        this._put(fqn, VERSION_KEY, new Integer(((ClusteredSession)session).getVersion()));
    }

    public void removeSession(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getSessionFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove session from distributed store. Fqn: " + fqn));
        }
        this._remove(fqn, realId);
        this._remove(fqn);
    }

    public void removeSessionLocal(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getSessionFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove session from my own distributed store only. Fqn: " + fqn));
        }
        this._evict(fqn);
    }

    public boolean exists(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getSessionFqn(realId);
        return this.proxy_.exists(fqn);
    }

    public Object getAttribute(String id, String key) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        return this.getUnMarshalledValue(this._get(fqn, key));
    }

    public Object putAttribute(String id, String key, Object value) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        return this._put(fqn, key, this.getMarshalledValue(value));
    }

    public void putAttribute(String id, Map map) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        Set set = map.keySet();
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this._put(fqn, key, this.getMarshalledValue(map.get(key)));
        }
    }

    public void removeAttributes(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        this._remove(fqn);
    }

    public Object removeAttribute(String id, String key) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove attribute from distributed store. Fqn: " + fqn + " key: " + key));
        }
        return this.getUnMarshalledValue(this._remove(fqn, key));
    }

    public void removeAttributeLocal(String id) {
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        if (log_.isDebugEnabled()) {
            log_.debug((Object)("Remove attributes from my own distributed store only. Fqn: " + fqn));
        }
        this._evict(fqn);
    }

    public Set getAttributeKeys(String id) {
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("JBossCacheService: id is either null or empty");
        }
        String realId = this.stripJvmRoute(id);
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            return this.proxy_.getKeys(fqn);
        }
        catch (CacheException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Map getAttributes(String id) {
        if (id == null || id.length() == 0) {
            return new HashMap();
        }
        Set set = this.getAttributeKeys(id);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (set == null) {
            return map;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = this.getAttribute(id, key);
            map.put(key, value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNewSessionsInStore() {
        ArrayList list = new ArrayList();
        List list2 = this.newSessionIDList_;
        synchronized (list2) {
            if (this.newSessionIDList_.size() != 0) {
                list.addAll(this.newSessionIDList_);
                this.newSessionIDList_.clear();
            }
        }
        return list;
    }

    protected Object _get(Fqn fqn, String id) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.proxy_.get(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache get ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache get after retry ... ", ex);
    }

    protected Object _put(Fqn fqn, String id, Object value) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.proxy_.put(fqn, (Object)id, value);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache put ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache put after retry ... ", ex);
    }

    protected void _put(Fqn fqn, Map map) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.proxy_.put(fqn, map);
                return;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache put ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache put after retry ... ", ex);
    }

    protected Object _remove(Fqn fqn, String id) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.proxy_.remove(fqn, (Object)id);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache remove ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache remove after retry ... ", ex);
    }

    protected void _remove(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.proxy_.remove(fqn);
                return;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache remove ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache remove after retry ... ", ex);
    }

    protected void _evict(Fqn fqn) {
        TimeoutException ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.proxy_.evict(fqn);
                return;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                ex = e;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("JBossCacheService: exception occurred in cache evict ... ", e);
            }
        }
        throw new RuntimeException("JBossCacheService: exception occurred in cache evict after retry ... ", ex);
    }

    private String stripJvmRoute(String id) {
        int index = id.indexOf(".");
        if (index > 0) {
            if (this.jvmRoute_ == null) {
                this.jvmRoute_ = id.substring(index);
            }
            return id.substring(0, index);
        }
        return id;
    }

    private Fqn getSessionFqn(String id) {
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_, id};
        return new Fqn(objs);
    }

    private Fqn getAttributeFqn(String id) {
        Object[] objs = new Object[]{SESSION, this.hostName_, this.webAppPath_, id, ATTRIBUTE};
        return new Fqn(objs);
    }

    private Object getMarshalledValue(Object value) {
        try {
            return new MarshalledValue(value);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUnMarshalledValue(Object mv) {
        if (mv == null) {
            return null;
        }
        ClassLoader prevTCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.tcl_);
        try {
            Object object = ((MarshalledValue)mv).get();
            return object;
        }
        catch (IOException e) {
            e.printStackTrace();
            Object var4_6 = null;
            return var4_6;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Object var4_7 = null;
            return var4_7;
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevTCL);
        }
    }

    public void nodeCreated(Fqn fqn) {
    }

    public void nodeRemoved(Fqn fqn) {
        this.nodeDirty(fqn);
    }

    public void nodeLoaded(Fqn fqn) {
    }

    public void nodeModified(Fqn fqn) {
        this.nodeDirty(fqn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nodeDirty(Fqn fqn) {
        if (!this.needToHandle(fqn)) {
            return;
        }
        Integer version = (Integer)this._get(fqn, VERSION_KEY);
        if (version != null) {
            String realId = this.getIdFromFqn(fqn);
            ClusteredSession session = this.manager_.findLocalSession(realId);
            if (session != null) {
                if (session.isNewData(version)) {
                    session.setIsOutdated(true);
                    if (log_.isDebugEnabled()) {
                        log_.debug((Object)("nodeDirty(): session in-memory data is invalidated with id: " + realId + " and verion id: " + version));
                    }
                }
            } else {
                List list = this.newSessionIDList_;
                synchronized (list) {
                    if (!this.newSessionIDList_.contains(realId)) {
                        this.newSessionIDList_.add(realId);
                    }
                }
            }
        }
    }

    protected boolean needToHandle(Fqn fqn) {
        return fqn.isChildOf(this.webAppRoot_);
    }

    protected String getIdFromFqn(Fqn fqn) {
        return (String)fqn.get(fqn.size() - 1);
    }

    public void nodeVisited(Fqn fqn) {
    }

    public void cacheStarted(TreeCache cache) {
    }

    public void cacheStopped(TreeCache cache) {
    }

    public void viewChange(View new_view) {
    }

    public void nodeEvicted(Fqn fqn) {
    }

    private byte[] externalizeSession(ClusteredSession session) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MarshalledValueOutputStream oos = new MarshalledValueOutputStream((OutputStream)baos);
            session.writeExternal((ObjectOutput)oos);
            oos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

