/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.failover.monitor.jmx;

import com.clustercontrol.failover.monitor.jmx.FailoverCheckServiceMBean;
import com.clustercontrol.failover.monitor.jmx.FailoverMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;

public class FailoverCheckService
extends ServiceMBeanSupport
implements FailoverCheckServiceMBean {
    private String jndiName = "FailoverCheckService";
    private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    private static final String OBJECT_NAME = "jboss:service=";
    private static final String GET_NODE_NAME = "getNodeName";
    private static final String GET_CURRENT_VIEW = "getCurrentView";
    private String partitionName = "HinemosPartition";
    private HAPartition partition;
    private ArrayList<String> members = new ArrayList();
    boolean failoverExecCheck = false;

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String name) {
        this.partitionName = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) throws NamingException {
        this.log.info((Object)("setJndiName() : jndiName = " + jndiName));
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        if (super.getState() == 3) {
            NamingException ne;
            try {
                this.unbind(oldName);
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to unbind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
            try {
                this.rebind();
            }
            catch (NamingException e) {
                ne = new NamingException("Failed to rebind");
                ne.setRootCause(e);
                this.log.error((Object)ne);
            }
        }
    }

    public String getName() {
        return "FailoverCheckService(" + this.jndiName + ")";
    }

    public void startService() throws NamingException {
        FailoverMonitor monitor;
        String[] cmd;
        int i;
        this.log.info((Object)("Start FailoverCheckService(" + this.jndiName + ")"));
        InitialContext ctx = new InitialContext();
        String partitionJndiName = "/HAPartition/" + this.partitionName;
        this.partition = (HAPartition)ctx.lookup(partitionJndiName);
        String bindAddress = this.getNodeName();
        this.getAllMembers();
        Properties properties = new Properties();
        String homedir = System.getProperty("jboss.server.home.dir");
        String propertyFile = homedir + File.separator + "conf" + File.separator + "trouble-detection.properties";
        Iterator<String> itr = this.members.iterator();
        String oldMember = null;
        while (itr.hasNext()) {
            if (oldMember == null) {
                oldMember = itr.next();
                continue;
            }
            oldMember = oldMember + ", " + itr.next();
        }
        this.log.info((Object)("member : " + oldMember));
        if (this.members.size() < 1) {
            this.log.error((Object)"Failed in getting member info!");
            throw new NamingException();
        }
        if (this.members.size() > 2) {
            this.log.error((Object)"Too match server!!");
            throw new NamingException();
        }
        try {
            properties.load(new FileInputStream(propertyFile));
        }
        catch (FileNotFoundException e) {
            this.log.info((Object)e);
            throw new NamingException();
        }
        catch (IOException e) {
            this.log.info((Object)e);
            throw new NamingException();
        }
        String jbossServer1 = properties.getProperty("jboss.server1");
        String jbossServer2 = properties.getProperty("jboss.server2");
        String command = properties.getProperty("jboss.failover.command");
        String backend1 = properties.getProperty("server1.backend.ip");
        String backend2 = properties.getProperty("server2.backend.ip");
        int commandRetry = Integer.parseInt(properties.getProperty("jboss.failover.command.retry"));
        this.log.info((Object)("bind address : " + bindAddress));
        if (bindAddress.equals(jbossServer2)) {
            for (i = 0; i < commandRetry; ++i) {
                cmd = new String[]{command, backend1};
                monitor = new FailoverMonitor();
                this.failoverExecCheck = monitor.callExternalCommand(cmd);
            }
        } else if (bindAddress.equals(jbossServer1)) {
            for (i = 0; i < commandRetry; ++i) {
                cmd = new String[]{command, backend2};
                monitor = new FailoverMonitor();
                this.failoverExecCheck = monitor.callExternalCommand(cmd);
            }
        } else {
            this.log.error((Object)("This node(" + bindAddress + ") is not MsaterServer(" + jbossServer1 + ") or SlaveServer(" + jbossServer2 + ") in " + propertyFile));
            throw new NamingException();
        }
        this.rebind();
        if (!this.failoverExecCheck) {
            this.log.error((Object)"Stopping Hinemos Startup.");
        }
        while (!this.failoverExecCheck) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new NamingException();
            }
        }
        this.log.info((Object)("Started FailoverCheckService(" + this.jndiName + ")"));
    }

    public void continueStartup() {
        this.failoverExecCheck = true;
    }

    public void stopService() throws NamingException {
        this.log.info((Object)("Stop FailoverCheckService(" + this.jndiName + ")"));
        this.unbind(this.jndiName);
        this.log.info((Object)("Stoped FailoverCheckService(" + this.jndiName + ")"));
    }

    private static Context createContext(Context rootCtx, Name name) throws NamingException {
        Context subctx = rootCtx;
        for (int n = 0; n < name.size(); ++n) {
            String atom = name.get(n);
            try {
                Object obj = subctx.lookup(atom);
                subctx = (Context)obj;
                continue;
            }
            catch (NamingException e) {
                subctx = subctx.createSubcontext(atom);
            }
        }
        return subctx;
    }

    private void rebind() throws NamingException {
        Name fullName;
        InitialContext rootCtx = new InitialContext();
        Name parentName = fullName = rootCtx.getNameParser("").parse(this.jndiName);
        parentName = fullName.size() > 1 ? fullName.getPrefix(fullName.size() - 1) : new CompositeName();
        Context parentCtx = FailoverCheckService.createContext(rootCtx, parentName);
        Name atomName = fullName.getSuffix(fullName.size() - 1);
        String atomStirng = atomName.get(0);
        NonSerializableFactory.rebind((Context)parentCtx, (String)atomStirng, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind(String jndiName) throws NamingException {
        InitialContext rootCtx = null;
        try {
            rootCtx = new InitialContext();
            Name fullName = rootCtx.getNameParser("").parse(jndiName);
            Name atomName = fullName.getSuffix(fullName.size() - 1);
            String atom = atomName.get(0);
            rootCtx.unbind(jndiName);
            NonSerializableFactory.unbind((String)atom);
        }
        finally {
            if (rootCtx != null) {
                rootCtx.close();
            }
        }
    }

    private String getNodeName() {
        this.log.debug((Object)"getAllMembers() start :");
        String nodeName = null;
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME + this.partitionName);
            Object returnObject = server.invoke(name, GET_NODE_NAME, null, null);
            if (returnObject instanceof String) {
                nodeName = ((String)returnObject).split(":")[0];
            }
        }
        catch (NamingException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (IOException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        this.log.debug((Object)"getAllMembers() end :");
        return nodeName;
    }

    private void getAllMembers() {
        this.log.debug((Object)"getAllMembers() start :");
        try {
            this.members.clear();
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME + this.partitionName);
            Object returnObject = server.invoke(name, GET_CURRENT_VIEW, null, null);
            if (returnObject instanceof Vector) {
                Vector returnVector = (Vector)returnObject;
                for (int i = 0; i < returnVector.size(); ++i) {
                    String work = (String)returnVector.get(i);
                    String[] node = work.split(":");
                    this.members.add(node[0]);
                }
            }
        }
        catch (NamingException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        catch (IOException e) {
            this.log.error((Object)("getAllMembers() : " + e.getMessage()));
        }
        this.log.debug((Object)"getAllMembers() end :");
    }
}

