/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.jboss.mq.AcknowledgementRequest;
import org.jboss.mq.DestinationFullException;
import org.jboss.mq.DurableSubscriptionID;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpyTopic;
import org.jboss.mq.Subscription;
import org.jboss.mq.pm.NewPersistenceManager;
import org.jboss.mq.pm.PersistenceManager;
import org.jboss.mq.pm.Tx;
import org.jboss.mq.server.BasicQueue;
import org.jboss.mq.server.BasicQueueParameters;
import org.jboss.mq.server.ClientConsumer;
import org.jboss.mq.server.ExclusiveQueue;
import org.jboss.mq.server.JMSDestination;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.server.MessageReference;
import org.jboss.mq.server.PersistentQueue;
import org.jboss.mq.server.SelectorPersistentQueue;

public class JMSTopic
extends JMSDestination {
    ConcurrentReaderHashMap durQueues = new ConcurrentReaderHashMap();
    ConcurrentReaderHashMap tempQueues = new ConcurrentReaderHashMap();

    public JMSTopic(SpyDestination dest, ClientConsumer temporary, JMSDestinationManager server, BasicQueueParameters parameters) throws JMSException {
        super(dest, temporary, server, parameters);
        PersistenceManager pm = server.getPersistenceManager();
        parameters.lateClone = pm instanceof NewPersistenceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(Subscription sub) throws JMSException {
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        if (id == null) {
            ExclusiveQueue q = new ExclusiveQueue(this.server, this.destination, sub, this.parameters);
            q.createMessageCounter(this.destination.getName(), q.getDescription(), true, false, this.parameters.messageCounterHistoryDayLimit);
            this.tempQueues.put((Object)sub, (Object)q);
            q.addSubscriber(sub);
        } else {
            PersistentQueue q = (PersistentQueue)this.durQueues.get((Object)id);
            if (q != null && q.isInUse()) {
                throw new IllegalStateException("The durable subscription is already in use. " + id);
            }
            boolean selectorChanged = false;
            if (q != null) {
                String newSelector = sub.messageSelector;
                String oldSelector = null;
                if (q instanceof SelectorPersistentQueue) {
                    oldSelector = ((SelectorPersistentQueue)q).selectorString;
                }
                if (newSelector == null && oldSelector != null || newSelector != null && !newSelector.equals(oldSelector)) {
                    selectorChanged = true;
                }
            }
            if (q == null || !q.destination.equals(topic) || selectorChanged) {
                this.server.getStateManager().setDurableSubscription(this.server, id, topic);
                ConcurrentReaderHashMap concurrentReaderHashMap = this.durQueues;
                synchronized (concurrentReaderHashMap) {
                    q = (PersistentQueue)this.durQueues.get((Object)id);
                }
            }
            q.addSubscriber(sub);
        }
    }

    public void removeSubscriber(Subscription sub) throws JMSException {
        BasicQueue queue = null;
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        queue = id == null ? (BasicQueue)this.tempQueues.get((Object)sub) : (BasicQueue)this.durQueues.get((Object)id);
        if (queue == null) {
            ((ClientConsumer)sub.clientConsumer).removeRemovedSubscription(sub.subscriptionId);
        } else {
            queue.removeSubscriber(sub);
        }
    }

    public void nackMessages(Subscription sub) throws JMSException {
        BasicQueue queue = null;
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        queue = id == null ? (BasicQueue)this.tempQueues.get((Object)sub) : (BasicQueue)this.durQueues.get((Object)id);
        if (queue != null) {
            queue.nackMessages(sub);
        }
    }

    void cleanupSubscription(Subscription sub) {
        BasicQueue queue = (BasicQueue)this.tempQueues.remove((Object)sub);
        try {
            if (queue != null) {
                queue.removeAllMessages();
            }
        }
        catch (JMSException e) {
            cat.debug((Object)("Error removing messages for subscription " + sub), (Throwable)e);
        }
    }

    public void addReceiver(Subscription sub) throws JMSException {
        this.getQueue(sub).addReceiver(sub);
    }

    public void removeReceiver(Subscription sub) {
        this.getQueue(sub).removeReceiver(sub);
    }

    public void restoreMessage(MessageReference messageRef) {
        try {
            SpyMessage spyMessage = messageRef.getMessage();
            this.updateNextMessageId(spyMessage);
            if (spyMessage.header.durableSubscriberID == null) {
                cat.debug((Object)"Trying to restore message with null durableSubscriberID");
            } else {
                BasicQueue queue;
                messageRef.queue = queue = (BasicQueue)this.durQueues.get((Object)spyMessage.header.durableSubscriberID);
                queue.restoreMessage(messageRef);
            }
        }
        catch (JMSException e) {
            cat.error((Object)"Could not restore message:", (Throwable)e);
        }
    }

    public void restoreMessage(SpyMessage message) {
        try {
            this.updateNextMessageId(message);
            if (message.header.durableSubscriberID == null) {
                cat.debug((Object)"Trying to restore message with null durableSubscriberID");
            } else {
                BasicQueue queue = (BasicQueue)this.durQueues.get((Object)message.header.durableSubscriberID);
                MessageReference messageRef = this.server.getMessageCache().add(message, queue, 2);
                queue.restoreMessage(messageRef);
            }
        }
        catch (JMSException e) {
            cat.error((Object)"Could not restore message:", (Throwable)e);
        }
    }

    public void restoreMessage(SpyMessage message, DurableSubscriptionID id) {
        try {
            this.updateNextMessageId(message);
            if (id == null) {
                cat.debug((Object)"Trying to restore message with null durableSubscriberID");
            } else {
                BasicQueue queue = (BasicQueue)this.durQueues.get((Object)id);
                MessageReference messageRef = this.server.getMessageCache().add(message, queue, 2, id);
                queue.restoreMessage(messageRef);
            }
        }
        catch (JMSException e) {
            cat.error((Object)"Could not restore message:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDurableSubscription(DurableSubscriptionID id) throws JMSException {
        if (this.temporaryDestination != null) {
            throw new JMSException("Not a valid operation on a temporary topic");
        }
        SpyTopic dstopic = new SpyTopic((SpyTopic)this.destination, id);
        Throwable error = null;
        for (int i = 0; i <= this.parameters.recoveryRetries; ++i) {
            PersistentQueue queue = id.getSelector() == null ? new PersistentQueue(this.server, dstopic, this.parameters) : new SelectorPersistentQueue(this.server, dstopic, id.getSelector(), this.parameters);
            queue.createMessageCounter(this.destination.getName(), id.toString(), true, true, this.parameters.messageCounterHistoryDayLimit);
            this.durQueues.put((Object)id, (Object)queue);
            try {
                this.server.getPersistenceManager().restoreQueue(this, dstopic);
                break;
            }
            catch (Throwable t) {
                if (i < this.parameters.recoveryRetries) {
                    cat.warn((Object)("Error restoring topic subscription " + queue + " retries=" + i + " of " + this.parameters.recoveryRetries), t);
                } else {
                    error = t;
                }
                try {
                    queue.stop();
                    continue;
                }
                catch (Throwable ignored) {
                    cat.trace((Object)("Ignored error stopping topic subscription " + queue), ignored);
                    continue;
                }
                finally {
                    this.durQueues.remove((Object)id);
                    queue = null;
                }
            }
        }
        if (error != null) {
            SpyJMSException.rethrowAsJMSException("Unable to recover topic subscription " + id + " retries=" + this.parameters.recoveryRetries, error);
        }
    }

    public void close() throws JMSException {
        BasicQueue queue;
        if (this.temporaryDestination != null) {
            throw new JMSException("Not a valid operation on a temporary topic");
        }
        Iterator i = this.tempQueues.values().iterator();
        while (i.hasNext()) {
            queue = (ExclusiveQueue)i.next();
            queue.stop();
        }
        i = this.durQueues.values().iterator();
        while (i.hasNext()) {
            queue = (PersistentQueue)i.next();
            queue.stop();
            this.server.getPersistenceManager().closeQueue(this, ((PersistentQueue)queue).getSpyDestination());
        }
    }

    public void destroyDurableSubscription(DurableSubscriptionID id) throws JMSException {
        BasicQueue queue = (BasicQueue)this.durQueues.remove((Object)id);
        queue.removeAllMessages();
    }

    public SpyMessage receive(Subscription sub, boolean wait) throws JMSException {
        return this.getQueue(sub).receive(sub, wait);
    }

    public void acknowledge(AcknowledgementRequest req, Subscription sub, Tx txId) throws JMSException {
        this.getQueue(sub).acknowledge(req, txId);
    }

    public void addMessage(SpyMessage message, Tx txId) throws JMSException {
        StringBuffer errorMessage = null;
        boolean added = false;
        long messageId = this.nextMessageId();
        if (this.parameters.lateClone) {
            message.header.messageId = messageId;
        }
        Iterator iter = this.durQueues.keySet().iterator();
        while (iter.hasNext()) {
            MessageReference ref;
            DurableSubscriptionID id = (DurableSubscriptionID)iter.next();
            PersistentQueue q = (PersistentQueue)this.durQueues.get((Object)id);
            if (this.parameters.lateClone) {
                ref = this.server.getMessageCache().add(message, q, 1, id);
            } else {
                SpyMessage clone = message.myClone();
                clone.header.durableSubscriberID = id;
                clone.header.messageId = messageId;
                clone.setJMSDestination(q.getSpyDestination());
                ref = this.server.getMessageCache().add(clone, q, 1);
            }
            try {
                if (!added && this.parameters.lateClone && ref.isPersistent()) {
                    NewPersistenceManager pm = (NewPersistenceManager)this.server.getPersistenceManager();
                    pm.addMessage(message);
                    added = true;
                }
                q.addMessage(ref, txId);
            }
            catch (DestinationFullException e) {
                if (errorMessage == null) {
                    errorMessage = new StringBuffer(e.getText());
                    continue;
                }
                errorMessage.append(", ").append(e.getText());
            }
        }
        iter = this.tempQueues.values().iterator();
        while (iter.hasNext()) {
            MessageReference ref;
            BasicQueue q = (BasicQueue)iter.next();
            if (this.parameters.lateClone) {
                ref = this.server.getMessageCache().add(message, q, 1);
            } else {
                SpyMessage clone = message.myClone();
                clone.header.messageId = messageId;
                ref = this.server.getMessageCache().add(clone, q, 1);
            }
            try {
                q.addMessage(ref, txId);
            }
            catch (DestinationFullException e) {
                if (errorMessage == null) {
                    errorMessage = new StringBuffer(e.getText());
                    continue;
                }
                errorMessage.append(", ").append(e.getText());
            }
        }
        if (errorMessage != null) {
            throw new DestinationFullException(errorMessage.toString());
        }
    }

    public int getAllMessageCount() {
        return this.calculateMessageCount(this.getAllQueues());
    }

    public int getDurableMessageCount() {
        return this.calculateMessageCount(this.getPersistentQueues());
    }

    public int getNonDurableMessageCount() {
        return this.calculateMessageCount(this.getTemporaryQueues());
    }

    public ArrayList getAllQueues() {
        ArrayList result = new ArrayList(this.getAllSubscriptionsCount());
        result.addAll(this.getPersistentQueues());
        result.addAll(this.getTemporaryQueues());
        return result;
    }

    public ArrayList getTemporaryQueues() {
        return new ArrayList(this.tempQueues.values());
    }

    public ArrayList getPersistentQueues() {
        return new ArrayList(this.durQueues.values());
    }

    public int getAllSubscriptionsCount() {
        return this.durQueues.size() + this.tempQueues.size();
    }

    public int getDurableSubscriptionsCount() {
        return this.durQueues.size();
    }

    public int getNonDurableSubscriptionsCount() {
        return this.tempQueues.size();
    }

    public ArrayList getAllSubscriptions() {
        ArrayList result = new ArrayList(this.getAllSubscriptionsCount());
        result.addAll(this.getDurableSubscriptions());
        result.addAll(this.getNonDurableSubscriptions());
        return result;
    }

    public ArrayList getDurableSubscriptions() {
        return new ArrayList(this.durQueues.keySet());
    }

    public ArrayList getNonDurableSubscriptions() {
        return new ArrayList(this.tempQueues.keySet());
    }

    public PersistentQueue getDurableSubscription(DurableSubscriptionID id) {
        return (PersistentQueue)this.durQueues.get((Object)id);
    }

    public BasicQueue getQueue(Subscription sub) {
        SpyTopic topic = (SpyTopic)sub.destination;
        DurableSubscriptionID id = topic.getDurableSubscriptionID();
        if (id != null) {
            return this.getDurableSubscription(id);
        }
        return (BasicQueue)this.tempQueues.get((Object)sub);
    }

    public boolean isInUse() {
        if (this.tempQueues.size() > 0) {
            return true;
        }
        Iterator iter = this.durQueues.values().iterator();
        while (iter.hasNext()) {
            PersistentQueue q = (PersistentQueue)iter.next();
            if (!q.isInUse()) continue;
            return true;
        }
        return false;
    }

    public void removeAllMessages() throws JMSException {
        Iterator i = this.durQueues.values().iterator();
        while (i.hasNext()) {
            PersistentQueue queue = (PersistentQueue)i.next();
            queue.removeAllMessages();
        }
    }

    private int calculateMessageCount(ArrayList queues) {
        int count = 0;
        ListIterator i = queues.listIterator();
        while (i.hasNext()) {
            BasicQueue queue = (BasicQueue)i.next();
            count += queue.getQueueDepth();
        }
        return count;
    }

    public MessageCounter[] getMessageCounter() {
        String key;
        MessageCounter counter;
        BasicQueue queue;
        TreeMap<String, MessageCounter> map = new TreeMap<String, MessageCounter>();
        Iterator i = this.durQueues.values().iterator();
        while (i.hasNext()) {
            queue = (BasicQueue)i.next();
            counter = queue.getMessageCounter();
            if (counter == null) continue;
            key = counter.getDestinationName() + counter.getDestinationSubscription();
            map.put(key, counter);
        }
        i = this.tempQueues.values().iterator();
        while (i.hasNext()) {
            queue = (BasicQueue)i.next();
            counter = queue.getMessageCounter();
            if (counter == null) continue;
            key = counter.getDestinationName() + counter.getDestinationSubscription();
            map.put(key, counter);
        }
        return map.values().toArray(new MessageCounter[0]);
    }
}

