/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Dataset;
import org.jfree.data.DefaultCategoryDataset;
import org.jfree.data.DefaultPieDataset;
import org.jfree.data.DomainInfo;
import org.jfree.data.Function2D;
import org.jfree.data.HighLowDataset;
import org.jfree.data.IntervalCategoryDataset;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.KeyedValues;
import org.jfree.data.PieDataset;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.TableXYDataset;
import org.jfree.data.XYDataset;
import org.jfree.data.XYSeries;
import org.jfree.data.XYSeriesCollection;

public final class DatasetUtilities {
    private DatasetUtilities() {
    }

    public static Number[] createNumberArray(double[] data) {
        Number[] result = new Number[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = new Double(data[i]);
        }
        return result;
    }

    public static Number[][] createNumberArray2D(double[][] data) {
        int l1 = data.length;
        int l2 = data[0].length;
        Number[][] result = new Number[l1][l2];
        for (int i = 0; i < l1; ++i) {
            result[i] = DatasetUtilities.createNumberArray(data[i]);
        }
        return result;
    }

    public static Range getDomainExtent(Dataset dataset) {
        if (dataset == null) {
            return null;
        }
        if (dataset instanceof CategoryDataset && !(dataset instanceof XYDataset)) {
            throw new IllegalArgumentException("The dataset does not have a numerical domain.");
        }
        if (dataset instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)dataset);
            return info.getDomainRange();
        }
        if (dataset instanceof XYDataset) {
            return DatasetUtilities.iterateDomainExtent((XYDataset)dataset);
        }
        return null;
    }

    public static Range iterateDomainExtent(XYDataset data) {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = data.getSeriesCount();
        for (int series = 0; series < seriesCount; ++series) {
            int itemCount = data.getItemCount(series);
            for (int item = 0; item < itemCount; ++item) {
                Number uvalue;
                Number lvalue;
                if (data instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                    lvalue = intervalXYData.getStartXValue(series, item);
                    uvalue = intervalXYData.getEndXValue(series, item);
                } else {
                    uvalue = lvalue = data.getXValue(series, item);
                }
                if (lvalue != null) {
                    minimum = Math.min(minimum, lvalue.doubleValue());
                }
                if (uvalue == null) continue;
                maximum = Math.max(maximum, uvalue.doubleValue());
            }
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range getRangeExtent(Dataset data) {
        if (data == null) {
            return null;
        }
        if (data instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)data);
            return info.getValueRange();
        }
        if (data instanceof CategoryDataset) {
            return DatasetUtilities.iterateCategoryRangeExtent((CategoryDataset)data);
        }
        if (data instanceof XYDataset) {
            return DatasetUtilities.iterateXYRangeExtent((XYDataset)data);
        }
        return null;
    }

    public static Range iterateCategoryRangeExtent(CategoryDataset data) {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int rowCount = data.getRowCount();
        int columnCount = data.getColumnCount();
        for (int row = 0; row < rowCount; ++row) {
            for (int column = 0; column < columnCount; ++column) {
                Number uvalue;
                Number lvalue;
                if (data instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset icd = (IntervalCategoryDataset)data;
                    lvalue = icd.getStartValue(row, column);
                    uvalue = icd.getEndValue(row, column);
                } else {
                    uvalue = lvalue = data.getValue(row, column);
                }
                if (lvalue != null) {
                    minimum = Math.min(minimum, lvalue.doubleValue());
                }
                if (uvalue == null) continue;
                maximum = Math.max(maximum, uvalue.doubleValue());
            }
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range iterateXYRangeExtent(XYDataset data) {
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        int seriesCount = data.getSeriesCount();
        for (int series = 0; series < seriesCount; ++series) {
            int itemCount = data.getItemCount(series);
            for (int item = 0; item < itemCount; ++item) {
                Number uvalue;
                Number lvalue;
                if (data instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                    lvalue = intervalXYData.getStartYValue(series, item);
                    uvalue = intervalXYData.getEndYValue(series, item);
                } else if (data instanceof HighLowDataset) {
                    HighLowDataset highLowData = (HighLowDataset)data;
                    lvalue = highLowData.getLowValue(series, item);
                    uvalue = highLowData.getHighValue(series, item);
                } else {
                    uvalue = lvalue = data.getYValue(series, item);
                }
                if (lvalue != null) {
                    minimum = Math.min(minimum, lvalue.doubleValue());
                }
                if (uvalue == null) continue;
                maximum = Math.max(maximum, uvalue.doubleValue());
            }
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Number getMinimumDomainValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("DatasetUtilities.getMinimumDomainValue: null dataset not allowed.");
        }
        if (data instanceof CategoryDataset && !(data instanceof XYDataset)) {
            throw new IllegalArgumentException("DatasetUtilities.getMinimumDomainValue(...): TableDataset does not have numerical domain.");
        }
        if (data instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)data);
            return info.getMinimumDomainValue();
        }
        if (data instanceof XYDataset) {
            double minimum = Double.POSITIVE_INFINITY;
            XYDataset xyData = (XYDataset)data;
            int seriesCount = xyData.getSeriesCount();
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = xyData.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    Number value;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getStartXValue(series, item);
                    } else {
                        value = xyData.getXValue(series, item);
                    }
                    if (value == null) continue;
                    minimum = Math.min(minimum, value.doubleValue());
                }
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(minimum);
        }
        return null;
    }

    public static Number getMaximumDomainValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue: null dataset not allowed.");
        }
        if (data instanceof CategoryDataset && !(data instanceof XYDataset)) {
            throw new IllegalArgumentException("Datasets.getMaximumDomainValue(...): CategoryDataset does not have numerical domain.");
        }
        if (data instanceof DomainInfo) {
            DomainInfo info = (DomainInfo)((Object)data);
            return info.getMaximumDomainValue();
        }
        if (data instanceof XYDataset) {
            XYDataset xyData = (XYDataset)data;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = xyData.getSeriesCount();
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = xyData.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    Number value;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getEndXValue(series, item);
                    } else {
                        value = xyData.getXValue(series, item);
                    }
                    if (value == null) continue;
                    maximum = Math.max(maximum, value.doubleValue());
                }
            }
            if (maximum == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(maximum);
        }
        return null;
    }

    public static Number getMinimumRangeValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (data instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)data);
            return info.getMinimumRangeValue();
        }
        if (data instanceof CategoryDataset) {
            CategoryDataset categoryData = (CategoryDataset)data;
            double minimum = Double.POSITIVE_INFINITY;
            int seriesCount = categoryData.getRowCount();
            int itemCount = categoryData.getColumnCount();
            for (int series = 0; series < seriesCount; ++series) {
                for (int item = 0; item < itemCount; ++item) {
                    Number value;
                    if (data instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset icd = (IntervalCategoryDataset)data;
                        value = icd.getStartValue(series, item);
                    } else {
                        value = categoryData.getValue(series, item);
                    }
                    if (value == null) continue;
                    minimum = Math.min(minimum, value.doubleValue());
                }
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(minimum);
        }
        if (data instanceof XYDataset) {
            XYDataset xyData = (XYDataset)data;
            double minimum = Double.POSITIVE_INFINITY;
            int seriesCount = xyData.getSeriesCount();
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = xyData.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    Number value;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getStartYValue(series, item);
                    } else if (data instanceof HighLowDataset) {
                        HighLowDataset highLowData = (HighLowDataset)data;
                        value = highLowData.getLowValue(series, item);
                    } else {
                        value = xyData.getYValue(series, item);
                    }
                    if (value == null) continue;
                    minimum = Math.min(minimum, value.doubleValue());
                }
            }
            if (minimum == Double.POSITIVE_INFINITY) {
                return null;
            }
            return new Double(minimum);
        }
        return null;
    }

    public static Number getMaximumRangeValue(Dataset data) {
        if (data == null) {
            throw new IllegalArgumentException("Datasets.getMinimumRangeValue: null dataset not allowed.");
        }
        if (data instanceof RangeInfo) {
            RangeInfo info = (RangeInfo)((Object)data);
            return info.getMaximumRangeValue();
        }
        if (data instanceof CategoryDataset) {
            CategoryDataset categoryData = (CategoryDataset)data;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = categoryData.getRowCount();
            int itemCount = categoryData.getColumnCount();
            for (int series = 0; series < seriesCount; ++series) {
                for (int item = 0; item < itemCount; ++item) {
                    Number value;
                    if (data instanceof IntervalCategoryDataset) {
                        IntervalCategoryDataset icd = (IntervalCategoryDataset)data;
                        value = icd.getEndValue(series, item);
                    } else {
                        value = categoryData.getValue(series, item);
                    }
                    if (value == null) continue;
                    maximum = Math.max(maximum, value.doubleValue());
                }
            }
            if (maximum == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(maximum);
        }
        if (data instanceof XYDataset) {
            XYDataset xyData = (XYDataset)data;
            double maximum = Double.NEGATIVE_INFINITY;
            int seriesCount = xyData.getSeriesCount();
            for (int series = 0; series < seriesCount; ++series) {
                int itemCount = xyData.getItemCount(series);
                for (int item = 0; item < itemCount; ++item) {
                    Number value;
                    if (data instanceof IntervalXYDataset) {
                        IntervalXYDataset intervalXYData = (IntervalXYDataset)data;
                        value = intervalXYData.getEndYValue(series, item);
                    } else if (data instanceof HighLowDataset) {
                        HighLowDataset highLowData = (HighLowDataset)data;
                        value = highLowData.getHighValue(series, item);
                    } else {
                        value = xyData.getYValue(series, item);
                    }
                    if (value == null) continue;
                    maximum = Math.max(maximum, value.doubleValue());
                }
            }
            if (maximum == Double.NEGATIVE_INFINITY) {
                return null;
            }
            return new Double(maximum);
        }
        return null;
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset data, Comparable rowKey) {
        int row = data.getRowIndex(rowKey);
        return DatasetUtilities.createPieDatasetForRow(data, row);
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset data, int row) {
        DefaultPieDataset result = new DefaultPieDataset();
        int columnCount = data.getColumnCount();
        for (int current = 0; current < columnCount; ++current) {
            Comparable columnKey = data.getColumnKey(current);
            result.setValue(columnKey, data.getValue(row, current));
        }
        return result;
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset data, Comparable columnKey) {
        int column = data.getColumnIndex(columnKey);
        return DatasetUtilities.createPieDatasetForColumn(data, column);
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset data, int column) {
        DefaultPieDataset result = new DefaultPieDataset();
        int rowCount = data.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Comparable rowKey = data.getRowKey(i);
            result.setValue(rowKey, data.getValue(i, column));
        }
        return result;
    }

    public static double calculatePieDatasetTotal(PieDataset dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Null 'dataset' argument.");
        }
        List keys = dataset.getKeys();
        double totalValue = 0.0;
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Comparable current = (Comparable)iterator.next();
            if (current == null) continue;
            Number value = dataset.getValue(current);
            double v = 0.0;
            if (value != null) {
                v = value.doubleValue();
            }
            if (!(v > 0.0)) continue;
            totalValue += v;
        }
        return totalValue;
    }

    public static Range getStackedRangeExtent(CategoryDataset data) {
        Range result = null;
        if (data != null) {
            double minimum = 0.0;
            double maximum = 0.0;
            int categoryCount = data.getColumnCount();
            for (int item = 0; item < categoryCount; ++item) {
                double positive = 0.0;
                double negative = 0.0;
                int seriesCount = data.getRowCount();
                for (int series = 0; series < seriesCount; ++series) {
                    Number number = data.getValue(series, item);
                    if (number == null) continue;
                    double value = number.doubleValue();
                    if (value > 0.0) {
                        positive += value;
                    }
                    if (!(value < 0.0)) continue;
                    negative += value;
                }
                minimum = Math.min(minimum, negative);
                maximum = Math.max(maximum, positive);
            }
            result = new Range(minimum, maximum);
        }
        return result;
    }

    public static Range getStackedRangeExtent(CategoryDataset dataset, KeyToGroupMap map) {
        Range result = null;
        if (dataset != null) {
            int[] groupIndex = new int[dataset.getRowCount()];
            for (int i = 0; i < dataset.getRowCount(); ++i) {
                groupIndex[i] = map.getGroupIndex(map.getGroup(dataset.getRowKey(i)));
            }
            int groupCount = map.getGroupCount();
            double[] minimum = new double[groupCount];
            double[] maximum = new double[groupCount];
            int categoryCount = dataset.getColumnCount();
            for (int item = 0; item < categoryCount; ++item) {
                double[] positive = new double[groupCount];
                double[] negative = new double[groupCount];
                int seriesCount = dataset.getRowCount();
                for (int series = 0; series < seriesCount; ++series) {
                    Number number = dataset.getValue(series, item);
                    if (number == null) continue;
                    double value = number.doubleValue();
                    if (value > 0.0) {
                        positive[groupIndex[series]] = positive[groupIndex[series]] + value;
                    }
                    if (!(value < 0.0)) continue;
                    negative[groupIndex[series]] = negative[groupIndex[series]] + value;
                }
                for (int g = 0; g < groupCount; ++g) {
                    minimum[g] = Math.min(minimum[g], negative[g]);
                    maximum[g] = Math.max(maximum[g], positive[g]);
                }
            }
            for (int j = 0; j < groupCount; ++j) {
                result = Range.combine(result, new Range(minimum[j], maximum[j]));
            }
        }
        return result;
    }

    public static Number getMinimumStackedRangeValue(CategoryDataset data) {
        Double result = null;
        if (data != null) {
            double minimum = 0.0;
            int categoryCount = data.getRowCount();
            for (int item = 0; item < categoryCount; ++item) {
                double total = 0.0;
                int seriesCount = data.getColumnCount();
                for (int series = 0; series < seriesCount; ++series) {
                    double value;
                    Number number = data.getValue(series, item);
                    if (number == null || !((value = number.doubleValue()) < 0.0)) continue;
                    total += value;
                }
                minimum = Math.min(minimum, total);
            }
            result = new Double(minimum);
        }
        return result;
    }

    public static Number getMaximumStackedRangeValue(CategoryDataset data) {
        Double result = null;
        if (data != null) {
            double maximum = 0.0;
            int categoryCount = data.getColumnCount();
            for (int item = 0; item < categoryCount; ++item) {
                double total = 0.0;
                int seriesCount = data.getRowCount();
                for (int series = 0; series < seriesCount; ++series) {
                    double value;
                    Number number = data.getValue(series, item);
                    if (number == null || !((value = number.doubleValue()) > 0.0)) continue;
                    total += value;
                }
                maximum = Math.max(maximum, total);
            }
            result = new Double(maximum);
        }
        return result;
    }

    public static XYDataset sampleFunction2D(Function2D f, double start, double end, int samples, String seriesName) {
        if (f == null) {
            throw new IllegalArgumentException("Null 'f' argument.");
        }
        if (seriesName == null) {
            throw new IllegalArgumentException("Null 'seriesName' argument.");
        }
        if (start >= end) {
            throw new IllegalArgumentException("Requires 'start' < 'end'.");
        }
        if (samples < 2) {
            throw new IllegalArgumentException("Requires 'samples' > 1");
        }
        XYSeries series = new XYSeries(seriesName);
        double step = (end - start) / (double)samples;
        for (int i = 0; i <= samples; ++i) {
            double x = start + step * (double)i;
            series.add(x, f.getValue(x));
        }
        XYSeriesCollection collection = new XYSeriesCollection(series);
        return collection;
    }

    public static CategoryDataset createCategoryDataset(String rowKeyPrefix, String columnKeyPrefix, double[][] data) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        for (int r = 0; r < data.length; ++r) {
            String rowKey = rowKeyPrefix + (r + 1);
            for (int c = 0; c < data[r].length; ++c) {
                String columnKey = columnKeyPrefix + (c + 1);
                result.addValue(new Double(data[r][c]), (Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
            }
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(String rowKeyPrefix, String columnKeyPrefix, Number[][] data) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        for (int r = 0; r < data.length; ++r) {
            String rowKey = rowKeyPrefix + (r + 1);
            for (int c = 0; c < data[r].length; ++c) {
                String columnKey = columnKeyPrefix + (c + 1);
                result.addValue(data[r][c], (Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
            }
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(String[] rowKeys, String[] columnKeys, double[][] data) {
        if (rowKeys == null) {
            throw new IllegalArgumentException("Argument 'rowKeys' cannot be null.");
        }
        if (columnKeys == null) {
            throw new IllegalArgumentException("Argument 'columnKeys' cannot be null.");
        }
        if (rowKeys.length != data.length) {
            throw new IllegalArgumentException("The number of row keys does not match the number of rows in the data array.");
        }
        int columnCount = 0;
        for (int r = 0; r < data.length; ++r) {
            columnCount = Math.max(columnCount, data[r].length);
        }
        if (columnKeys.length != columnCount) {
            throw new IllegalArgumentException("The number of column keys does not match the number of columns in the data array.");
        }
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        for (int r = 0; r < data.length; ++r) {
            String rowKey = rowKeys[r];
            for (int c = 0; c < data[r].length; ++c) {
                String columnKey = columnKeys[c];
                result.addValue(new Double(data[r][c]), (Comparable)((Object)rowKey), (Comparable)((Object)columnKey));
            }
        }
        return result;
    }

    public static CategoryDataset createCategoryDataset(String rowKey, KeyedValues rowData) {
        DefaultCategoryDataset result = new DefaultCategoryDataset();
        for (int i = 0; i < rowData.getItemCount(); ++i) {
            result.addValue(rowData.getValue(i), (Comparable)((Object)rowKey), rowData.getKey(i));
        }
        return result;
    }

    public static boolean isEmptyOrNull(XYDataset data) {
        boolean result = true;
        if (data != null) {
            for (int s = 0; s < data.getSeriesCount(); ++s) {
                if (data.getItemCount(s) <= 0) continue;
                result = false;
            }
        }
        return result;
    }

    public static boolean isEmptyOrNull(PieDataset dataset) {
        if (dataset == null) {
            return true;
        }
        int itemCount = dataset.getItemCount();
        if (itemCount == 0) {
            return true;
        }
        for (int item = 0; item < itemCount; ++item) {
            double yy;
            Number y = dataset.getValue(item);
            if (y == null || !((yy = y.doubleValue()) > 0.0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyOrNull(CategoryDataset data) {
        if (data == null) {
            return true;
        }
        int rowCount = data.getRowCount();
        int columnCount = data.getColumnCount();
        if (rowCount == 0 || columnCount == 0) {
            return true;
        }
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < columnCount; ++c) {
                if (data.getValue(r, c) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static PieDataset limitPieDataset(PieDataset dataset, double percentThreshold) {
        return DatasetUtilities.limitPieDataset(dataset, percentThreshold, 2, (Comparable)((Object)"Other"));
    }

    public static PieDataset limitPieDataset(PieDataset dataset, double percentThreshold, int minItems) {
        return DatasetUtilities.limitPieDataset(dataset, percentThreshold, minItems, (Comparable)((Object)"Other"));
    }

    public static PieDataset limitPieDataset(PieDataset dataset, double percentThreshold, int minItems, Comparable key) {
        DefaultPieDataset result = new DefaultPieDataset();
        double total = DatasetUtilities.calculatePieDatasetTotal(dataset);
        List keys = dataset.getKeys();
        ArrayList<Comparable> otherKeys = new ArrayList<Comparable>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            double value;
            Comparable currentKey = (Comparable)iterator.next();
            Number dataValue = dataset.getValue(currentKey);
            if (dataValue == null || !((value = dataValue.doubleValue()) / total < percentThreshold)) continue;
            otherKeys.add(currentKey);
        }
        iterator = keys.iterator();
        double otherValue = 0.0;
        while (iterator.hasNext()) {
            Comparable currentKey = (Comparable)iterator.next();
            Number dataValue = dataset.getValue(currentKey);
            if (dataValue == null) continue;
            if (otherKeys.contains(currentKey) && otherKeys.size() >= minItems) {
                otherValue += dataValue.doubleValue();
                continue;
            }
            result.setValue(currentKey, dataValue);
        }
        if (otherKeys.size() >= minItems) {
            result.setValue(key, otherValue);
        }
        return result;
    }

    public static Range getStackedRangeExtent(TableXYDataset data) {
        if (data == null) {
            return null;
        }
        double minimum = Double.POSITIVE_INFINITY;
        double maximum = Double.NEGATIVE_INFINITY;
        for (int itemNo = 0; itemNo < data.getItemCount(); ++itemNo) {
            double value = 0.0;
            for (int seriesNo = 0; seriesNo < data.getSeriesCount(); ++seriesNo) {
                if (data.getYValue(seriesNo, itemNo) == null) continue;
                value += data.getYValue(seriesNo, itemNo).doubleValue();
            }
            if (value > maximum) {
                maximum = value;
            }
            if (!(value < minimum)) continue;
            minimum = value;
        }
        if (minimum == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(minimum, maximum);
    }

    public static Range getCumulativeRangeExtent(CategoryDataset dataset) {
        if (dataset == null) {
            return null;
        }
        boolean allItemsNull = true;
        double minimum = 0.0;
        double maximum = 0.0;
        for (int row = 0; row < dataset.getRowCount(); ++row) {
            double runningTotal = 0.0;
            for (int column = 0; column < dataset.getColumnCount() - 1; ++column) {
                Number n = dataset.getValue(row, column);
                if (n == null) continue;
                allItemsNull = false;
                double value = n.doubleValue();
                minimum = Math.min(minimum, runningTotal += value);
                maximum = Math.max(maximum, runningTotal);
            }
        }
        if (!allItemsNull) {
            return new Range(minimum, maximum);
        }
        return null;
    }
}

