/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.uil2.msgs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import org.jboss.mq.il.uil2.SocketManager;
import org.jboss.mq.il.uil2.msgs.AcknowledgementRequestMsg;
import org.jboss.mq.il.uil2.msgs.AddMsg;
import org.jboss.mq.il.uil2.msgs.BrowseMsg;
import org.jboss.mq.il.uil2.msgs.CheckIDMsg;
import org.jboss.mq.il.uil2.msgs.CheckUserMsg;
import org.jboss.mq.il.uil2.msgs.CloseMsg;
import org.jboss.mq.il.uil2.msgs.ConnectionTokenMsg;
import org.jboss.mq.il.uil2.msgs.CreateDestMsg;
import org.jboss.mq.il.uil2.msgs.DeleteSubscriptionMsg;
import org.jboss.mq.il.uil2.msgs.DeleteTemporaryDestMsg;
import org.jboss.mq.il.uil2.msgs.EnableConnectionMsg;
import org.jboss.mq.il.uil2.msgs.GetIDMsg;
import org.jboss.mq.il.uil2.msgs.PingMsg;
import org.jboss.mq.il.uil2.msgs.ReceiveMsg;
import org.jboss.mq.il.uil2.msgs.ReceiveRequestMsg;
import org.jboss.mq.il.uil2.msgs.SubscribeMsg;
import org.jboss.mq.il.uil2.msgs.TemporaryDestMsg;
import org.jboss.mq.il.uil2.msgs.TransactMsg;
import org.jboss.mq.il.uil2.msgs.UnsubscribeMsg;

public class BaseMsg
implements Runnable {
    private static boolean useJMSServerMsgIDs = false;
    private static int nextMsgID = 0;
    private static Object nextMsgIDLock = new Object();
    private static final int SERVER_MSG_ID_MASK = Integer.MIN_VALUE;
    private SocketManager.ReadTask handler;
    public int msgType;
    public int msgID;
    public Exception error;

    public BaseMsg(int msgType) {
        this(msgType, 0);
    }

    public BaseMsg(int msgType, int msgID) {
        this.msgType = msgType;
        this.msgID = msgID;
    }

    public static void setUseJMSServerMsgIDs(boolean flag) {
        useJMSServerMsgIDs = flag;
    }

    public static BaseMsg createMsg(int msgType) throws IllegalArgumentException {
        BaseMsg msg = null;
        switch (msgType) {
            case 1: {
                msg = new AcknowledgementRequestMsg();
                break;
            }
            case 2: {
                msg = new AddMsg();
                break;
            }
            case 3: {
                msg = new BrowseMsg();
                break;
            }
            case 4: {
                msg = new CheckIDMsg();
                break;
            }
            case 5: {
                msg = new CloseMsg();
                break;
            }
            case 6: {
                msg = new CreateDestMsg(true);
                break;
            }
            case 7: {
                msg = new CreateDestMsg(false);
                break;
            }
            case 8: {
                msg = new DeleteTemporaryDestMsg();
                break;
            }
            case 9: {
                msg = new GetIDMsg();
                break;
            }
            case 10: {
                msg = new TemporaryDestMsg(true);
                break;
            }
            case 11: {
                msg = new TemporaryDestMsg(false);
                break;
            }
            case 13: {
                msg = new ReceiveMsg();
                break;
            }
            case 14: {
                msg = new EnableConnectionMsg();
                break;
            }
            case 15: {
                msg = new ConnectionTokenMsg();
                break;
            }
            case 16: {
                msg = new SubscribeMsg();
                break;
            }
            case 17: {
                msg = new TransactMsg();
                break;
            }
            case 18: {
                msg = new UnsubscribeMsg();
                break;
            }
            case 19: {
                msg = new DeleteSubscriptionMsg();
                break;
            }
            case 20: {
                msg = new CheckUserMsg(false);
                break;
            }
            case 21: {
                msg = new PingMsg(true);
                break;
            }
            case 22: {
                msg = new CheckUserMsg(true);
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                msg = new PingMsg(false);
                break;
            }
            case 25: {
                msg = new ReceiveRequestMsg();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid msgType: " + msgType);
            }
        }
        return msg;
    }

    public static String toString(int msgType) {
        String msgTypeString = null;
        switch (msgType) {
            case 1: {
                msgTypeString = "m_acknowledge";
                break;
            }
            case 2: {
                msgTypeString = "m_addMessage";
                break;
            }
            case 3: {
                msgTypeString = "m_browse";
                break;
            }
            case 4: {
                msgTypeString = "m_checkID";
                break;
            }
            case 5: {
                msgTypeString = "m_connectionClosing";
                break;
            }
            case 6: {
                msgTypeString = "m_createQueue";
                break;
            }
            case 7: {
                msgTypeString = "m_createTopic";
                break;
            }
            case 8: {
                msgTypeString = "m_deleteTemporaryDestination";
                break;
            }
            case 9: {
                msgTypeString = "m_getID";
                break;
            }
            case 10: {
                msgTypeString = "m_getTemporaryQueue";
                break;
            }
            case 11: {
                msgTypeString = "m_getTemporaryTopic";
                break;
            }
            case 13: {
                msgTypeString = "m_receive";
                break;
            }
            case 14: {
                msgTypeString = "m_setEnabled";
                break;
            }
            case 15: {
                msgTypeString = "m_setSpyDistributedConnection";
                break;
            }
            case 16: {
                msgTypeString = "m_subscribe";
                break;
            }
            case 17: {
                msgTypeString = "m_transact";
                break;
            }
            case 18: {
                msgTypeString = "m_unsubscribe";
                break;
            }
            case 19: {
                msgTypeString = "m_destroySubscription";
                break;
            }
            case 20: {
                msgTypeString = "m_checkUser";
                break;
            }
            case 21: {
                msgTypeString = "m_ping";
                break;
            }
            case 22: {
                msgTypeString = "m_authenticate";
                break;
            }
            case 23: {
                msgTypeString = "m_close";
                break;
            }
            case 24: {
                msgTypeString = "m_pong";
                break;
            }
            case 25: {
                msgTypeString = "m_receiveRequest";
                break;
            }
            default: {
                msgTypeString = "unknown message type " + msgType;
            }
        }
        return msgTypeString;
    }

    public int getMsgType() {
        return this.msgType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getMsgID() {
        if (this.msgID == 0) {
            Object object = nextMsgIDLock;
            synchronized (object) {
                this.msgID = ++nextMsgID;
            }
            if (useJMSServerMsgIDs) {
                this.msgID += Integer.MIN_VALUE;
            } else if (this.msgID >= Integer.MIN_VALUE) {
                this.msgID %= Integer.MIN_VALUE;
            }
        }
        return this.msgID;
    }

    public void setMsgID(int msgID) {
        this.msgID = msgID;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Throwable e) {
        this.error = e instanceof Exception ? (Exception)e : new UndeclaredThrowableException(e);
    }

    public boolean equals(Object o) {
        BaseMsg msg = (BaseMsg)o;
        return msg.msgID == this.msgID;
    }

    public int hashCode() {
        return this.msgID;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer(this.getClass().getName());
        tmp.append(System.identityHashCode(this));
        tmp.append("[msgType: ");
        tmp.append(BaseMsg.toString(this.msgType));
        tmp.append(", msgID: ");
        tmp.append(this.msgID);
        tmp.append(", error: ");
        tmp.append(this.error);
        tmp.append("]");
        return tmp.toString();
    }

    public void trimReply() {
    }

    public void write(ObjectOutputStream out) throws IOException {
        out.writeByte(this.msgType);
        out.writeInt(this.msgID);
        int hasError = this.error != null ? 1 : 0;
        out.writeByte(hasError);
        if (hasError == 1) {
            out.writeObject(this.error);
        }
    }

    public void read(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte hasError = in.readByte();
        if (hasError == 1) {
            this.error = (Exception)in.readObject();
        }
    }

    public void setHandler(SocketManager.ReadTask handler) {
        this.handler = handler;
    }

    public void run() {
        this.handler.handleMsg(this);
        this.handler = null;
    }
}

