/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xb.binding.DelegatingObjectModelProvider;
import org.jboss.xb.binding.GenericObjectModelProvider;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.MarshallingContext;
import org.jboss.xb.binding.ObjectModelProvider;
import org.jboss.xb.binding.TypeBinding;
import org.jboss.xb.binding.Util;

public class MappingObjectModelProvider
implements GenericObjectModelProvider {
    private static final Logger log = Logger.getLogger(MappingObjectModelProvider.class);
    private final Map classMappings = new HashMap();
    private final Map fieldMappings = new HashMap();
    private boolean ignoreLowLine = true;
    private boolean ignoreNotFoundField = true;

    public boolean isIgnoreNotFoundField() {
        return this.ignoreNotFoundField;
    }

    public void setIgnoreNotFoundField(boolean ignoreNotFoundField) {
        this.ignoreNotFoundField = ignoreNotFoundField;
    }

    public void mapClassToElement(Class cls, String namespaceURI, String localName, ObjectModelProvider provider) {
        ClassToElementMapping mapping = new ClassToElementMapping(cls, namespaceURI, localName, provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider));
        this.classMappings.put(mapping.cls, mapping);
    }

    public void mapFieldToElement(Class cls, String field, String namespaceURI, String localName, TypeBinding converter) {
        FieldToElementMapping mapping = new FieldToElementMapping(cls, field, namespaceURI, localName, converter);
        String mappingKey = cls.getName() + ":" + localName;
        this.fieldMappings.put(mappingKey, mapping);
    }

    public boolean isIgnoreLowLine() {
        return this.ignoreLowLine;
    }

    public void setIgnoreLowLine(boolean ignoreLowLine) {
        this.ignoreLowLine = ignoreLowLine;
    }

    public Object getChildren(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        Object children = null;
        if (!this.writeAsValue(o.getClass())) {
            children = this.getJavaValue(localName, o, true);
        }
        return children;
    }

    public Object getElementValue(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        Object value = null;
        value = this.writeAsValue(o.getClass()) ? o : this.getJavaValue(localName, o, false);
        return value;
    }

    public Object getAttributeValue(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        Object value = null;
        value = this.writeAsValue(o.getClass()) ? o : this.getJavaValue(localName, o, false);
        return value;
    }

    public Object getRoot(Object o, MarshallingContext ctx, String namespaceURI, String localName) {
        return o;
    }

    private Object getJavaValue(String localName, Object o, boolean forComplexType) {
        Method getter = null;
        Field field = null;
        String mappingKey = o.getClass().getName() + ":" + localName;
        FieldToElementMapping mapping = (FieldToElementMapping)this.fieldMappings.get(mappingKey);
        if (mapping != null) {
            if (mapping.getter != null) {
                getter = mapping.getter;
            } else {
                field = mapping.field;
            }
        } else {
            String getterStr = Util.xmlNameToGetMethodName(localName, this.ignoreLowLine);
            try {
                getter = o.getClass().getMethod(getterStr, null);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (getter == null) {
                String booleanGetterStr = "is" + getterStr.substring(3);
                try {
                    getter = o.getClass().getMethod(booleanGetterStr, null);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (getter == null) {
                String attr = Util.xmlNameToClassName(localName, this.ignoreLowLine);
                attr = Character.toLowerCase(attr.charAt(0)) + attr.substring(1);
                try {
                    field = o.getClass().getField(attr);
                }
                catch (NoSuchFieldException e1) {
                    if (this.ignoreNotFoundField) {
                        if (log.isTraceEnabled()) {
                            log.trace("getChildren: found neither getter nor field for " + localName + " in " + o.getClass());
                        }
                    }
                    throw new JBossXBRuntimeException("getChildren: found neither getter nor field for " + localName + " in " + o.getClass());
                }
            }
        }
        Object value = null;
        try {
            if (getter != null && (!forComplexType || forComplexType && !this.writeAsValue(getter.getReturnType()))) {
                value = getter.invoke(o, null);
            }
        }
        catch (Exception e) {
            log.error("Cannot invoke getter '" + getter + "' on object: " + o);
            throw new JBossXBRuntimeException("Failed to provide value for " + localName + " from " + o, e);
        }
        try {
            if (field != null && (!forComplexType || forComplexType && !this.writeAsValue(field.getType()))) {
                value = field.get(o);
            }
        }
        catch (Exception e) {
            log.error("Cannot invoke field '" + field + "' on object: " + o);
            throw new JBossXBRuntimeException("Failed to provide value for " + localName + " from " + o, e);
        }
        if (value != null && mapping != null && mapping.converter != null) {
            value = mapping.converter.marshal(value);
        }
        return value;
    }

    private boolean writeAsValue(Class type) {
        return Classes.isPrimitive(type) || type == String.class || type == Date.class;
    }

    private class FieldToElementMapping {
        public final Class cls;
        public final String fieldName;
        public final String namespaceURI;
        public final String localName;
        public final TypeBinding converter;
        public final Method getter;
        public final Method setter;
        public final Field field;

        public FieldToElementMapping(Class cls, String field, String namespaceURI, String localName, TypeBinding converter) {
            this.cls = cls;
            this.fieldName = field;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.converter = converter;
            if (log.isTraceEnabled()) {
                log.trace("new FieldToElementMapping: [cls=" + cls.getName() + ",field=" + field + ",qname=" + new QName(namespaceURI, localName) + "]");
            }
            Method localGetter = null;
            Method localSetter = null;
            Field localField = null;
            try {
                localGetter = Classes.getAttributeGetter(cls, field);
                localSetter = Classes.getAttributeSetter(cls, field, localGetter.getReturnType());
            }
            catch (NoSuchMethodException e) {
                try {
                    localField = cls.getField(field);
                }
                catch (NoSuchFieldException e1) {
                    throw new JBossXBRuntimeException("Neither getter/setter pair nor field where found for " + field + " in " + cls);
                }
            }
            this.getter = localGetter;
            this.setter = localSetter;
            this.field = localField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldToElementMapping)) {
                return false;
            }
            FieldToElementMapping fieldToElementMapping = (FieldToElementMapping)o;
            if (this.cls != null ? !this.cls.equals(fieldToElementMapping.cls) : fieldToElementMapping.cls != null) {
                return false;
            }
            if (this.fieldName != null ? !this.fieldName.equals(fieldToElementMapping.fieldName) : fieldToElementMapping.fieldName != null) {
                return false;
            }
            if (this.localName != null ? !this.localName.equals(fieldToElementMapping.localName) : fieldToElementMapping.localName != null) {
                return false;
            }
            return !(this.namespaceURI != null ? !this.namespaceURI.equals(fieldToElementMapping.namespaceURI) : fieldToElementMapping.namespaceURI != null);
        }

        public int hashCode() {
            int result = this.cls != null ? this.cls.hashCode() : 0;
            result = 29 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
            result = 29 * result + (this.namespaceURI != null ? this.namespaceURI.hashCode() : 0);
            result = 29 * result + (this.localName != null ? this.localName.hashCode() : 0);
            return result;
        }
    }

    private class ClassToElementMapping {
        public final Class cls;
        public final String namespaceURI;
        public final String localName;
        public final GenericObjectModelProvider provider;

        public ClassToElementMapping(Class cls, String namespaceURI, String localName, GenericObjectModelProvider provider) {
            this.cls = cls;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.provider = provider;
            if (log.isTraceEnabled()) {
                log.trace("new ClassToElementMapping: [cls=" + cls.getName() + ",qname=" + new QName(namespaceURI, localName) + "]");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassToElementMapping)) {
                return false;
            }
            ClassToElementMapping classToElementMapping = (ClassToElementMapping)o;
            if (this.cls != null ? !this.cls.equals(classToElementMapping.cls) : classToElementMapping.cls != null) {
                return false;
            }
            if (this.localName != null ? !this.localName.equals(classToElementMapping.localName) : classToElementMapping.localName != null) {
                return false;
            }
            return !(this.namespaceURI != null ? !this.namespaceURI.equals(classToElementMapping.namespaceURI) : classToElementMapping.namespaceURI != null);
        }

        public int hashCode() {
            int result = this.cls != null ? this.cls.hashCode() : 0;
            result = 29 * result + (this.namespaceURI != null ? this.namespaceURI.hashCode() : 0);
            result = 29 * result + (this.localName != null ? this.localName.hashCode() : 0);
            return result;
        }
    }
}

