/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.deployment;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.axis.utils.LinkedHashMap;
import org.jboss.util.xml.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeanXMLMetaData {
    private Map elementDescMap = new LinkedHashMap();
    private List elementOrderList = new ArrayList();

    private BeanXMLMetaData() {
    }

    public static BeanXMLMetaData parse(Element metaData) {
        BeanXMLMetaData beanMetaData = new BeanXMLMetaData();
        if (metaData != null) {
            ArrayList<QName> qnames = new ArrayList<QName>();
            NodeList nlistElementDesc = metaData.getElementsByTagName("elementDesc");
            for (int i = 0; i < nlistElementDesc.getLength(); ++i) {
                QName xmlType;
                Element elDesc = (Element)nlistElementDesc.item(i);
                String fieldName = DOMUtils.getAttributeValue((Element)elDesc, (String)"fieldName");
                QName xmlName = DOMUtils.getAttributeValueAsQName((Element)elDesc, (String)"xmlName");
                if (xmlName == null) {
                    xmlName = new QName("", fieldName);
                }
                if ((xmlType = DOMUtils.getAttributeValueAsQName((Element)elDesc, (String)"xmlType")) != null) {
                    if (qnames.contains(xmlType)) {
                        throw new IllegalStateException("Duplicate type mapping definition: " + xmlType);
                    }
                    qnames.add(xmlType);
                }
                ElementMetaData elMetaData = new ElementMetaData(fieldName, xmlName, xmlType);
                beanMetaData.elementDescMap.put(fieldName, elMetaData);
                boolean asAttribute = DOMUtils.getAttributeValueAsBoolean((Element)elDesc, (String)"asAttr");
                elMetaData.setAsAttribute(asAttribute);
                boolean asContent = DOMUtils.getAttributeValueAsBoolean((Element)elDesc, (String)"asContent");
                elMetaData.setAsContent(asContent);
                Integer minOccurs = DOMUtils.getAttributeValueAsInteger((Element)elDesc, (String)"minOccurs");
                elMetaData.setMinOccurs(minOccurs);
                QName itemXmlType = DOMUtils.getAttributeValueAsQName((Element)elDesc, (String)"itemXmlType");
                elMetaData.setItemXmlType(itemXmlType);
            }
            Element orderEl = DOMUtils.getFirstChildElement((Node)metaData, (String)"elementOrder");
            if (orderEl != null) {
                NodeList nlistElementOrder = orderEl.getElementsByTagName("element");
                for (int i = 0; i < nlistElementOrder.getLength(); ++i) {
                    Element el = (Element)nlistElementOrder.item(i);
                    String fieldName = el.getAttribute("name");
                    beanMetaData.elementOrderList.add(fieldName);
                }
            }
        }
        return beanMetaData;
    }

    public Iterator getElementMetaData() {
        return this.elementDescMap.values().iterator();
    }

    public List getElementOrder() {
        return new ArrayList(this.elementOrderList);
    }

    public void serializeAsXML(PrintWriter out) {
        String pad = "  ";
        out.println(pad + "<typeDesc>");
        Iterator itElDesc = this.elementDescMap.values().iterator();
        while (itElDesc.hasNext()) {
            ElementMetaData elMetaData = (ElementMetaData)itElDesc.next();
            String prefixedXmlName = elMetaData.getPrefixedXmlName();
            out.print(pad + pad + "<elementDesc fieldName='" + elMetaData.getFieldName() + "' xmlName='" + prefixedXmlName + "'");
            if (elMetaData.getXmlType() != null) {
                String prefixedXmlType = elMetaData.getPrefixedXmlType();
                out.print(" xmlType='" + prefixedXmlType + "'");
            }
            if (elMetaData.isAsAttribute()) {
                out.print(" asAttr='true'");
            }
            if (elMetaData.isAsContent()) {
                out.print(" asContent='true'");
            }
            if (elMetaData.getMinOccurs() != null) {
                out.print(" minOccurs='" + elMetaData.getMinOccurs() + "'");
            }
            if (elMetaData.getItemXmlType() != null) {
                out.print(" itemXmlType='" + elMetaData.getPrefixedItemXmlType() + "'");
            }
            out.println("/>");
        }
        if (this.elementOrderList.size() > 0) {
            out.println(pad + pad + "<elementOrder>");
            Iterator itElOrder = this.elementOrderList.iterator();
            while (itElOrder.hasNext()) {
                String fieldName = (String)itElOrder.next();
                out.println(pad + pad + pad + "<element name='" + fieldName + "'/>");
            }
            out.println(pad + pad + "</elementOrder>");
        }
        out.println(pad + "</typeDesc>");
    }

    public static class ElementMetaData {
        private String fieldName;
        private QName xmlName;
        private QName xmlType;
        private QName itemXmlType;
        private boolean asAttribute;
        private boolean asContent;
        private Integer minOccurs;

        public ElementMetaData(String fieldName, QName xmlName, QName xmlType) {
            this.fieldName = fieldName;
            this.xmlName = xmlName;
            this.xmlType = xmlType;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public QName getXmlName() {
            return this.xmlName;
        }

        public String getPrefixedXmlName() {
            String retStr = null;
            if (this.xmlName != null) {
                retStr = this.xmlName.getLocalPart();
                if (this.xmlName.getPrefix().length() > 0) {
                    retStr = this.xmlName.getPrefix() + ":" + retStr;
                }
            }
            return retStr;
        }

        public QName getXmlType() {
            return this.xmlType;
        }

        public String getPrefixedXmlType() {
            String retStr = null;
            if (this.xmlType != null) {
                retStr = this.xmlType.getLocalPart();
                if (this.xmlType.getPrefix().length() > 0) {
                    retStr = this.xmlType.getPrefix() + ":" + retStr;
                }
            }
            return retStr;
        }

        public boolean isAsAttribute() {
            return this.asAttribute;
        }

        public void setAsAttribute(boolean asAttribute) {
            this.asAttribute = asAttribute;
        }

        public boolean isAsContent() {
            return this.asContent;
        }

        public void setAsContent(boolean asContent) {
            this.asContent = asContent;
        }

        public Integer getMinOccurs() {
            return this.minOccurs;
        }

        public void setMinOccurs(Integer minOccurs) {
            this.minOccurs = minOccurs;
        }

        public QName getItemXmlType() {
            return this.itemXmlType;
        }

        public String getPrefixedItemXmlType() {
            String retStr = null;
            if (this.itemXmlType != null) {
                retStr = this.itemXmlType.getLocalPart();
                if (this.itemXmlType.getPrefix().length() > 0) {
                    retStr = this.itemXmlType.getPrefix() + ":" + retStr;
                }
            }
            return retStr;
        }

        public void setItemXmlType(QName itemXmlType) {
            this.itemXmlType = itemXmlType;
        }
    }
}

