/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.security;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.jboss.aspects.security.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;

class SecurityActions {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$aspects$security$SecurityActions == null ? (class$org$jboss$aspects$security$SecurityActions = SecurityActions.class$("org.jboss.aspects.security.SecurityActions")) : class$org$jboss$aspects$security$SecurityActions));
    static /* synthetic */ Class class$org$jboss$aspects$security$SecurityActions;

    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        return TCLAction.UTIL.getContextClassLoader();
    }

    static void setContextClassLoader(ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(loader);
    }

    static Principal getPrincipal() {
        if (System.getSecurityManager() == null) {
            return PrincipalInfoAction.NON_PRIVILEGED.getPrincipal();
        }
        return PrincipalInfoAction.PRIVILEGED.getPrincipal();
    }

    static Object getCredential() {
        if (System.getSecurityManager() == null) {
            return PrincipalInfoAction.NON_PRIVILEGED.getCredential();
        }
        return PrincipalInfoAction.PRIVILEGED.getCredential();
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
        }
    }

    static void popSubjectContext() {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.pop();
        } else {
            PrincipalInfoAction.PRIVILEGED.pop();
        }
    }

    static RunAsIdentity peekRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.peek();
        }
        return RunAsIdentityActions.PRIVILEGED.peek();
    }

    static void pushRunAsIdentity(RunAsIdentity principal) {
        if (System.getSecurityManager() == null) {
            RunAsIdentityActions.NON_PRIVILEGED.push(principal);
        } else {
            RunAsIdentityActions.PRIVILEGED.push(principal);
        }
    }

    static RunAsIdentity popRunAsIdentity() {
        if (System.getSecurityManager() == null) {
            return RunAsIdentityActions.NON_PRIVILEGED.pop();
        }
        return RunAsIdentityActions.PRIVILEGED.pop();
    }

    static Exception getContextException() {
        if (System.getSecurityManager() == null) {
            return ContextInfoActions.NON_PRIVILEGED.getContextException();
        }
        return ContextInfoActions.PRIVILEGED.getContextException();
    }

    static Subject getContextSubject() throws PolicyContextException {
        if (System.getSecurityManager() == null) {
            return PolicyContextActions.NON_PRIVILEGED.getContextSubject();
        }
        return PolicyContextActions.PRIVILEGED.getContextSubject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction;
            {
                this.getTCLPrivilegedAction = new PrivilegedAction(this){
                    private final /* synthetic */ 19 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                };
            }

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(this, thread){
                    private final /* synthetic */ Thread val$thread;
                    private final /* synthetic */ 19 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$thread = val$thread;
                    }

                    public Object run() {
                        return this.val$thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(this, cl){
                    private final /* synthetic */ ClassLoader val$cl;
                    private final /* synthetic */ 19 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$cl = val$cl;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(this, thread, cl){
                    private final /* synthetic */ Thread val$thread;
                    private final /* synthetic */ ClassLoader val$cl;
                    private final /* synthetic */ 19 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$thread = val$thread;
                        this.val$cl = val$cl;
                    }

                    public Object run() {
                        this.val$thread.setContextClassLoader(this.val$cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    static interface PolicyContextActions {
        public static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
        public static final PolicyContextActions PRIVILEGED = new PolicyContextActions(){
            private final PrivilegedExceptionAction exAction;
            {
                this.exAction = new PrivilegedExceptionAction(this){
                    private final /* synthetic */ 15 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() throws Exception {
                        return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
                    }
                };
            }

            public Subject getContextSubject() throws PolicyContextException {
                try {
                    return (Subject)AccessController.doPrivileged(this.exAction);
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof PolicyContextException) {
                        throw (PolicyContextException)ex;
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final PolicyContextActions NON_PRIVILEGED = new PolicyContextActions(){

            public Subject getContextSubject() throws PolicyContextException {
                return (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            }
        };

        public Subject getContextSubject() throws PolicyContextException;
    }

    static interface ContextInfoActions {
        public static final String EX_KEY = "org.jboss.security.exception";
        public static final ContextInfoActions PRIVILEGED = new ContextInfoActions(){
            private final PrivilegedAction exAction;
            {
                this.exAction = new PrivilegedAction(this){
                    private final /* synthetic */ 12 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return SecurityAssociation.getContextInfo((Object)"org.jboss.security.exception");
                    }
                };
            }

            public Exception getContextException() {
                return (Exception)AccessController.doPrivileged(this.exAction);
            }
        };
        public static final ContextInfoActions NON_PRIVILEGED = new ContextInfoActions(){

            public Exception getContextException() {
                return (Exception)SecurityAssociation.getContextInfo((Object)"org.jboss.security.exception");
            }
        };

        public Exception getContextException();
    }

    static interface RunAsIdentityActions {
        public static final RunAsIdentityActions PRIVILEGED = new RunAsIdentityActions(){
            private final PrivilegedAction peekAction;
            private final PrivilegedAction popAction;
            {
                this.peekAction = new PrivilegedAction(this){
                    private final /* synthetic */ 7 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return SecurityAssociation.peekRunAsIdentity();
                    }
                };
                this.popAction = new PrivilegedAction(this){
                    private final /* synthetic */ 7 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        return SecurityAssociation.popRunAsIdentity();
                    }
                };
            }

            public RunAsIdentity peek() {
                return (RunAsIdentity)AccessController.doPrivileged(this.peekAction);
            }

            public void push(RunAsIdentity id) {
                AccessController.doPrivileged(new PrivilegedAction(this, id){
                    private final /* synthetic */ RunAsIdentity val$id;
                    private final /* synthetic */ 7 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$id = val$id;
                    }

                    public Object run() {
                        SecurityAssociation.pushRunAsIdentity((RunAsIdentity)this.val$id);
                        return null;
                    }
                });
            }

            public RunAsIdentity pop() {
                return (RunAsIdentity)AccessController.doPrivileged(this.popAction);
            }
        };
        public static final RunAsIdentityActions NON_PRIVILEGED = new RunAsIdentityActions(){

            public RunAsIdentity peek() {
                return SecurityAssociation.peekRunAsIdentity();
            }

            public void push(RunAsIdentity id) {
                SecurityAssociation.pushRunAsIdentity((RunAsIdentity)id);
            }

            public RunAsIdentity pop() {
                return SecurityAssociation.popRunAsIdentity();
            }
        };

        public RunAsIdentity peek();

        public void push(RunAsIdentity var1);

        public RunAsIdentity pop();
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                AccessController.doPrivileged(new PrivilegedAction(this, subject, principal, credential){
                    private final /* synthetic */ Subject val$subject;
                    private final /* synthetic */ Principal val$principal;
                    private final /* synthetic */ Object val$credential;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$subject = val$subject;
                        this.val$principal = val$principal;
                        this.val$credential = val$credential;
                    }

                    public Object run() {
                        SecurityAssociation.pushSubjectContext((Subject)this.val$subject, (Principal)this.val$principal, (Object)this.val$credential);
                        return null;
                    }
                });
            }

            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        SecurityAssociation.popSubjectContext();
                        return null;
                    }
                });
            }

            public Principal getPrincipal() {
                return (Principal)AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        SecurityAssociation.getPrincipal();
                        return null;
                    }
                });
            }

            public Object getCredential() {
                return AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        SecurityAssociation.getCredential();
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                SecurityAssociation.pushSubjectContext((Subject)subject, (Principal)principal, (Object)credential);
            }

            public void pop() {
                SecurityAssociation.popSubjectContext();
            }

            public Principal getPrincipal() {
                return SecurityAssociation.getPrincipal();
            }

            public Object getCredential() {
                return SecurityAssociation.getCredential();
            }
        };

        public void push(Principal var1, Object var2, Subject var3);

        public void pop();

        public Principal getPrincipal();

        public Object getCredential();
    }
}

