/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.authenticator.SingleSignOnEntry;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public class SingleSignOn
extends ValveBase
implements Lifecycle,
SessionListener {
    protected HashMap cache = new HashMap();
    protected static String info = "org.apache.catalina.authenticator.SingleSignOn";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private boolean requireReauthentication = false;
    protected HashMap reverse = new HashMap();
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected boolean started = false;

    public boolean getRequireReauthentication() {
        return this.requireReauthentication;
    }

    public void setRequireReauthentication(boolean required) {
        this.requireReauthentication = required;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Process session destroyed on " + session));
        }
        String ssoId = null;
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            ssoId = (String)this.reverse.get(session);
        }
        if (ssoId == null) {
            return;
        }
        if (session.getMaxInactiveInterval() > 0 && System.currentTimeMillis() - session.getLastAccessedTime() >= (long)(session.getMaxInactiveInterval() * 1000)) {
            this.removeSession(ssoId, session);
        } else {
            this.deregister(ssoId);
        }
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        SingleSignOnEntry entry;
        request.removeNote("org.apache.catalina.request.SSOID");
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Process request for '" + request.getRequestURI() + "'"));
        }
        if (request.getUserPrincipal() != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)(" Principal '" + request.getUserPrincipal().getName() + "' has already been authenticated"));
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)" Checking for SSO cookie");
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Cookie[]{};
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!"JSESSIONIDSSO".equals(cookies[i].getName())) continue;
            cookie = cookies[i];
            break;
        }
        if (cookie == null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)" SSO cookie is not present");
            }
            this.getNext().invoke(request, response);
            return;
        }
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)(" Checking for cached principal for " + cookie.getValue()));
        }
        if ((entry = this.lookup(cookie.getValue())) != null) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)(" Found cached principal '" + entry.getPrincipal().getName() + "' with auth type '" + entry.getAuthType() + "'"));
            }
            request.setNote("org.apache.catalina.request.SSOID", cookie.getValue());
            if (!this.getRequireReauthentication()) {
                request.setAuthType(entry.getAuthType());
                request.setUserPrincipal(entry.getPrincipal());
            }
        } else {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)" No cached principal found, erasing SSO cookie");
            }
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
        this.getNext().invoke(request, response);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SingleSignOn[");
        if (this.container == null) {
            sb.append("Container is null");
        } else {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associate(String ssoId, Session session) {
        SingleSignOnEntry sso;
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Associate sso id " + ssoId + " with session " + session));
        }
        if ((sso = this.lookup(ssoId)) != null) {
            sso.addSession(this, session);
        }
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.put(session, ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId, Session session) {
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.remove(session);
        }
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso == null) {
            return;
        }
        sso.removeSession(session);
        Session[] sessions = sso.findSessions();
        if (sessions == null || sessions.length == 0) {
            HashMap hashMap2 = this.cache;
            synchronized (hashMap2) {
                sso = (SingleSignOnEntry)this.cache.remove(ssoId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(String ssoId) {
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Deregistering sso id '" + ssoId + "'"));
        }
        SingleSignOnEntry sso = null;
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            sso = (SingleSignOnEntry)this.cache.remove(ssoId);
        }
        if (sso == null) {
            return;
        }
        Session[] sessions = sso.findSessions();
        for (int i = 0; i < sessions.length; ++i) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)(" Invalidating session " + sessions[i]));
            }
            HashMap hashMap2 = this.reverse;
            synchronized (hashMap2) {
                this.reverse.remove(sessions[i]);
            }
            sessions[i].expire();
        }
    }

    protected boolean reauthenticate(String ssoId, Realm realm, Request request) {
        Principal reauthPrincipal;
        String username;
        if (ssoId == null || realm == null) {
            return false;
        }
        boolean reauthenticated = false;
        SingleSignOnEntry entry = this.lookup(ssoId);
        if (entry != null && entry.getCanReauthenticate() && (username = entry.getUsername()) != null && (reauthPrincipal = realm.authenticate(username, entry.getPassword())) != null) {
            reauthenticated = true;
            request.setAuthType(entry.getAuthType());
            request.setUserPrincipal(reauthPrincipal);
        }
        return reauthenticated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(String ssoId, Principal principal, String authType, String username, String password) {
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Registering sso id '" + ssoId + "' for user '" + principal.getName() + "' with auth type '" + authType + "'"));
        }
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.put(ssoId, new SingleSignOnEntry(principal, authType, username, password));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(String ssoId, Principal principal, String authType, String username, String password) {
        SingleSignOnEntry sso = this.lookup(ssoId);
        if (sso != null && !sso.getCanReauthenticate()) {
            if (this.containerLog.isDebugEnabled()) {
                this.containerLog.debug((Object)("Update sso id " + ssoId + " to auth type " + authType));
            }
            SingleSignOnEntry singleSignOnEntry = sso;
            synchronized (singleSignOnEntry) {
                sso.updateCredentials(principal, authType, username, password);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleSignOnEntry lookup(String ssoId) {
        HashMap hashMap = this.cache;
        synchronized (hashMap) {
            return (SingleSignOnEntry)this.cache.get(ssoId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String ssoId, Session session) {
        SingleSignOnEntry entry;
        if (this.containerLog.isDebugEnabled()) {
            this.containerLog.debug((Object)("Removing session " + session.toString() + " from sso id " + ssoId));
        }
        if ((entry = this.lookup(ssoId)) == null) {
            return;
        }
        entry.removeSession(session);
        HashMap hashMap = this.reverse;
        synchronized (hashMap) {
            this.reverse.remove(session);
        }
        if (entry.findSessions().length == 0) {
            this.deregister(ssoId);
        }
    }
}

