/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.io.Serializable;
import java.util.HashMap;
import org.jboss.reflect.spi.AnnotatedInfo;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.util.JBossObject;

public class InheritableAnnotationHolder
extends JBossObject
implements AnnotatedInfo,
Serializable {
    private static final long serialVersionUID = 3257290210164289843L;
    protected HashMap declaredAnnotations;
    protected HashMap allAnnotations;
    protected AnnotationValue[] allAnnotationsArray;
    protected AnnotationValue[] declaredAnnotationsArray;
    protected InheritableAnnotationHolder superHolder;

    public AnnotationValue[] getDeclaredAnnotations() {
        return this.declaredAnnotationsArray;
    }

    public AnnotationValue[] getAnnotations() {
        return this.allAnnotationsArray;
    }

    public AnnotationValue getAnnotation(String name) {
        return (AnnotationValue)this.allAnnotations.get(name);
    }

    public boolean isAnnotationPresent(String name) {
        return this.allAnnotations.containsKey(name);
    }

    public void setupAnnotations(AnnotationValue[] annotations) {
        if (annotations != null && annotations.length > 0) {
            int i;
            this.declaredAnnotations = new HashMap();
            this.declaredAnnotationsArray = annotations;
            for (i = 0; i < annotations.length; ++i) {
                this.declaredAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
            }
            this.allAnnotations = new HashMap();
            if (this.superHolder != null && this.superHolder.allAnnotationsArray != null) {
                for (i = 0; i < this.superHolder.allAnnotationsArray.length; ++i) {
                    AnnotationValue av = this.superHolder.allAnnotationsArray[i];
                    if (av.getAnnotationType().isAnnotationPresent("java.lang.annotation.Inherited")) {
                        // empty if block
                    }
                    this.allAnnotations.put(av.getAnnotationType().getName(), av);
                }
            } else {
                this.allAnnotationsArray = this.declaredAnnotationsArray;
            }
            for (i = 0; i < annotations.length; ++i) {
                this.allAnnotations.put(annotations[i].getAnnotationType().getName(), annotations[i]);
            }
            this.allAnnotationsArray = this.allAnnotations.values().toArray(new AnnotationValue[this.allAnnotations.size()]);
        } else if (this.superHolder != null) {
            this.allAnnotations = this.superHolder.allAnnotations;
            this.allAnnotationsArray = this.superHolder.allAnnotationsArray;
        }
    }
}

