/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.DisplayValueOnlyCapable;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.util.HTMLEncoder;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;

public final class HtmlRendererUtils {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$HtmlRendererUtils == null ? (class$org$apache$myfaces$renderkit$html$HtmlRendererUtils = HtmlRendererUtils.class$("org.apache.myfaces.renderkit.html.HtmlRendererUtils")) : class$org$apache$myfaces$renderkit$html$HtmlRendererUtils));
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\r\n");
    private static final String HIDDEN_COMMANDLINK_FIELD_NAME = "_link_hidden_";
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$HtmlRendererUtils;

    private HtmlRendererUtils() {
    }

    public static void decodeUIInput(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(facesContext);
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        if (paramMap.containsKey(clientId)) {
            ((EditableValueHolder)component).setSubmittedValue(paramMap.get(clientId));
        } else {
            log.warn((Object)"There should always be a submitted value for an input if it is rendered, its form is submitted, and it is not disabled or read-only.");
        }
    }

    public static void decodeUISelectBoolean(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            String reqValue = (String)paramMap.get(clientId);
            if (reqValue.equalsIgnoreCase("on") || reqValue.equalsIgnoreCase("yes") || reqValue.equalsIgnoreCase("true")) {
                ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.TRUE);
            } else {
                ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.FALSE);
            }
        } else {
            ((EditableValueHolder)component).setSubmittedValue((Object)Boolean.FALSE);
        }
    }

    public static boolean isDisabledOrReadOnly(UIComponent component) {
        return HtmlRendererUtils.isDisplayValueOnly(component) || HtmlRendererUtils.isTrue(component.getAttributes().get("disabled")) || HtmlRendererUtils.isTrue(component.getAttributes().get("readOnly"));
    }

    private static boolean isTrue(Object obj) {
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }

    public static void decodeUISelectMany(FacesContext facesContext, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        Map paramValuesMap = facesContext.getExternalContext().getRequestParameterValuesMap();
        String clientId = component.getClientId(facesContext);
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        if (paramValuesMap.containsKey(clientId)) {
            String[] reqValues = (String[])paramValuesMap.get(clientId);
            ((EditableValueHolder)component).setSubmittedValue((Object)reqValues);
        } else {
            ((EditableValueHolder)component).setSubmittedValue((Object)new String[0]);
        }
    }

    public static void decodeUISelectOne(FacesContext facesContext, UIComponent component) {
        String clientId;
        if (!(component instanceof EditableValueHolder)) {
            throw new IllegalArgumentException("Component " + component.getClientId(facesContext) + " is not an EditableValueHolder");
        }
        if (HtmlRendererUtils.isDisabledOrReadOnly(component)) {
            return;
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        if (paramMap.containsKey(clientId = component.getClientId(facesContext))) {
            ((EditableValueHolder)component).setSubmittedValue(paramMap.get(clientId));
        } else {
            ((EditableValueHolder)component).setSubmittedValue(RendererUtils.NOTHING);
        }
    }

    public static void renderListbox(FacesContext facesContext, UISelectOne selectOne, boolean disabled, int size) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectOne, disabled, size, false);
    }

    public static void renderListbox(FacesContext facesContext, UISelectMany selectMany, boolean disabled, int size) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectMany, disabled, size, true);
    }

    public static void renderMenu(FacesContext facesContext, UISelectOne selectOne, boolean disabled) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectOne, disabled, 1, false);
    }

    public static void renderMenu(FacesContext facesContext, UISelectMany selectMany, boolean disabled) throws IOException {
        HtmlRendererUtils.internalRenderSelect(facesContext, (UIComponent)selectMany, disabled, 1, true);
    }

    private static void internalRenderSelect(FacesContext facesContext, UIComponent uiComponent, boolean disabled, int size, boolean selectMany) throws IOException {
        Converter converter;
        List selectItemList;
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("select", uiComponent);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        writer.writeAttribute("name", (Object)uiComponent.getClientId(facesContext), null);
        if (selectMany) {
            writer.writeAttribute("multiple", (Object)"true", null);
            selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent);
            converter = HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, uiComponent);
        } else {
            selectItemList = RendererUtils.getSelectItemList((UISelectOne)uiComponent);
            converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, uiComponent);
        }
        if (size == 0) {
            writer.writeAttribute("size", (Object)Integer.toString(selectItemList.size()), null);
        } else {
            writer.writeAttribute("size", (Object)Integer.toString(size), null);
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.SELECT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(selectMany, uiComponent, facesContext, converter);
        HtmlRendererUtils.renderSelectOptions(facesContext, uiComponent, converter, lookupSet, selectItemList);
        writer.writeText((Object)"", null);
        writer.endElement("select");
    }

    public static Set getSubmittedOrSelectedValuesAsSet(boolean selectMany, UIComponent uiComponent, FacesContext facesContext, Converter converter) {
        Set<String> lookupSet;
        if (selectMany) {
            UISelectMany uiSelectMany = (UISelectMany)uiComponent;
            lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            if (lookupSet == null) {
                lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
            }
        } else {
            UISelectOne uiSelectOne = (UISelectOne)uiComponent;
            Object lookup = uiSelectOne.getSubmittedValue();
            if (lookup == null) {
                lookup = uiSelectOne.getValue();
            }
            if (RendererUtils.NOTHING.equals(lookup)) {
                lookupSet = Collections.EMPTY_SET;
            } else {
                String lookupString = RendererUtils.getConvertedStringValue(facesContext, uiComponent, converter, lookup);
                lookupSet = Collections.singleton(lookupString);
            }
        }
        return lookupSet;
    }

    public static Converter findUISelectManyConverterFailsafe(FacesContext facesContext, UIComponent uiComponent) {
        Converter converter;
        try {
            converter = RendererUtils.findUISelectManyConverter(facesContext, (UISelectMany)uiComponent);
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + uiComponent.getClientId(facesContext)));
            converter = null;
        }
        return converter;
    }

    public static Converter findUIOutputConverterFailSafe(FacesContext facesContext, UIComponent uiComponent) {
        Converter converter;
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)((UISelectOne)uiComponent));
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + uiComponent.getClientId(facesContext)));
            converter = null;
        }
        return converter;
    }

    public static void renderSelectOptions(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List selectItemList) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Iterator it = selectItemList.iterator();
        while (it.hasNext()) {
            boolean disabled;
            SelectItem selectItem = (SelectItem)it.next();
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("optgroup", component);
                writer.writeAttribute("label", (Object)selectItem.getLabel(), null);
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                HtmlRendererUtils.renderSelectOptions(context, component, converter, lookupSet, Arrays.asList(selectItems));
                writer.endElement("optgroup");
                continue;
            }
            String itemStrValue = RendererUtils.getConvertedStringValue(context, component, converter, selectItem);
            writer.write("\t");
            writer.startElement("option", component);
            if (itemStrValue != null) {
                writer.writeAttribute("value", (Object)itemStrValue, null);
            }
            if (lookupSet.contains(itemStrValue)) {
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            if (disabled = selectItem.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            String labelClass = null;
            boolean componentDisabled = HtmlRendererUtils.isTrue(component.getAttributes().get("disabled"));
            labelClass = componentDisabled || disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
            if (labelClass != null) {
                writer.writeAttribute("class", (Object)labelClass, "labelClass");
            }
            writer.writeText((Object)selectItem.getLabel(), null);
            writer.endElement("option");
        }
    }

    public static void writePrettyLineSeparator(FacesContext facesContext) throws IOException {
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml()) {
            facesContext.getResponseWriter().write(LINE_SEPARATOR);
        }
    }

    public static void writePrettyIndent(FacesContext facesContext) throws IOException {
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isPrettyHtml()) {
            facesContext.getResponseWriter().write(9);
        }
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, String componentProperty, String attrName, Object value) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            String htmlAttrName = attrName.equals("styleClass") ? "class" : attrName;
            writer.writeAttribute(htmlAttrName, value, componentProperty);
            return true;
        }
        return false;
    }

    public static boolean renderHTMLAttribute(ResponseWriter writer, UIComponent component, String componentProperty, String htmlAttrName) throws IOException {
        Object value = component.getAttributes().get(componentProperty);
        return HtmlRendererUtils.renderHTMLAttribute(writer, componentProperty, htmlAttrName, value);
    }

    public static boolean renderHTMLAttributes(ResponseWriter writer, UIComponent component, String[] attributes) throws IOException {
        boolean somethingDone = false;
        int len = attributes.length;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes[i];
            if (!HtmlRendererUtils.renderHTMLAttribute(writer, component, attrName, attrName)) continue;
            somethingDone = true;
        }
        return somethingDone;
    }

    public static boolean renderHTMLAttributeWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String attrName, Object value, boolean startElementWritten) throws IOException {
        if (!RendererUtils.isDefaultAttributeValue(value)) {
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderHTMLAttributesWithOptionalStartElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean startElementWritten = false;
        int len = attributes.length;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes[i];
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            if (!startElementWritten) {
                writer.startElement(elementName, component);
                startElementWritten = true;
            }
            HtmlRendererUtils.renderHTMLAttribute(writer, attrName, attrName, value);
        }
        return startElementWritten;
    }

    public static boolean renderOptionalEndElement(ResponseWriter writer, UIComponent component, String elementName, String[] attributes) throws IOException {
        boolean endElementNeeded = false;
        int len = attributes.length;
        for (int i = 0; i < len; ++i) {
            String attrName = attributes[i];
            Object value = component.getAttributes().get(attrName);
            if (RendererUtils.isDefaultAttributeValue(value)) continue;
            endElementNeeded = true;
            break;
        }
        if (endElementNeeded) {
            writer.endElement(elementName);
            return true;
        }
        return false;
    }

    public static void writeIdIfNecessary(ResponseWriter writer, UIComponent component, FacesContext facesContext) throws IOException {
        if (component.getId() != null && !component.getId().startsWith("_id")) {
            writer.writeAttribute("id", (Object)component.getClientId(facesContext), null);
        }
    }

    public static void renderDisplayValueOnlyForSelects(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Converter converter;
        List selectItemList;
        boolean isSelectOne;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (uiComponent instanceof UISelectMany) {
            isSelectOne = false;
            selectItemList = RendererUtils.getSelectItemList((UISelectMany)uiComponent);
            converter = HtmlRendererUtils.findUISelectManyConverterFailsafe(facesContext, uiComponent);
        } else {
            isSelectOne = true;
            selectItemList = RendererUtils.getSelectItemList((UISelectOne)uiComponent);
            converter = HtmlRendererUtils.findUIOutputConverterFailSafe(facesContext, uiComponent);
        }
        writer.startElement(isSelectOne ? "span" : "ul", uiComponent);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        HtmlRendererUtils.renderDisplayValueOnlyAttributes(uiComponent, writer);
        Set lookupSet = HtmlRendererUtils.getSubmittedOrSelectedValuesAsSet(uiComponent instanceof UISelectMany, uiComponent, facesContext, converter);
        HtmlRendererUtils.renderSelectOptionsAsText(facesContext, uiComponent, converter, lookupSet, selectItemList, isSelectOne);
        writer.writeText((Object)"", null);
        writer.endElement(isSelectOne ? "span" : "ul");
    }

    public static void renderDisplayValueOnlyAttributes(UIComponent uiComponent, ResponseWriter writer) throws IOException {
        if (!(uiComponent instanceof DisplayValueOnlyCapable)) {
            log.error((Object)"Wrong type of uiComponent. needs DisplayValueOnlyCapable.");
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            return;
        }
        if (HtmlRendererUtils.getDisplayValueOnlyStyle(uiComponent) != null || HtmlRendererUtils.getDisplayValueOnlyStyleClass(uiComponent) != null) {
            if (HtmlRendererUtils.getDisplayValueOnlyStyle(uiComponent) != null) {
                writer.writeAttribute("style", (Object)HtmlRendererUtils.getDisplayValueOnlyStyle(uiComponent), null);
            } else if (uiComponent.getAttributes().get("style") != null) {
                writer.writeAttribute("style", uiComponent.getAttributes().get("style"), null);
            }
            if (HtmlRendererUtils.getDisplayValueOnlyStyleClass(uiComponent) != null) {
                writer.writeAttribute("class", (Object)HtmlRendererUtils.getDisplayValueOnlyStyleClass(uiComponent), null);
            } else if (uiComponent.getAttributes().get("styleClass") != null) {
                writer.writeAttribute("class", uiComponent.getAttributes().get("styleClass"), null);
            }
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES_WITHOUT_STYLE);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
        }
    }

    private static void renderSelectOptionsAsText(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List selectItemList, boolean isSelectOne) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Iterator it = selectItemList.iterator();
        while (it.hasNext()) {
            SelectItem selectItem = (SelectItem)it.next();
            if (selectItem instanceof SelectItemGroup) {
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                HtmlRendererUtils.renderSelectOptionsAsText(context, component, converter, lookupSet, Arrays.asList(selectItems), isSelectOne);
                continue;
            }
            String itemStrValue = RendererUtils.getConvertedStringValue(context, component, converter, selectItem);
            if (!lookupSet.contains(itemStrValue)) continue;
            if (!isSelectOne) {
                writer.startElement("li", component);
            }
            writer.writeText((Object)selectItem.getLabel(), null);
            if (!isSelectOne) {
                writer.endElement("li");
            }
            if (!isSelectOne) continue;
            return;
        }
    }

    public static String getDisplayValueOnlyStyleClass(UIComponent component) {
        if (component instanceof DisplayValueOnlyCapable) {
            if (((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyleClass() != null) {
                return ((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyleClass();
            }
            UIComponent parent = component;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof DisplayValueOnlyCapable) || ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyleClass() == null) continue;
                return ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyleClass();
            }
        }
        return null;
    }

    public static String getDisplayValueOnlyStyle(UIComponent component) {
        if (component instanceof DisplayValueOnlyCapable) {
            if (((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyle() != null) {
                return ((DisplayValueOnlyCapable)component).getDisplayValueOnlyStyle();
            }
            UIComponent parent = component;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof DisplayValueOnlyCapable) || ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyle() == null) continue;
                return ((DisplayValueOnlyCapable)parent).getDisplayValueOnlyStyle();
            }
        }
        return null;
    }

    public static boolean isDisplayValueOnly(UIComponent component) {
        if (component instanceof DisplayValueOnlyCapable) {
            if (((DisplayValueOnlyCapable)component).isSetDisplayValueOnly()) {
                return ((DisplayValueOnlyCapable)component).isDisplayValueOnly();
            }
            UIComponent parent = component;
            while ((parent = parent.getParent()) != null) {
                if (!(parent instanceof DisplayValueOnlyCapable) || !((DisplayValueOnlyCapable)parent).isSetDisplayValueOnly()) continue;
                return ((DisplayValueOnlyCapable)parent).isDisplayValueOnly();
            }
        }
        return false;
    }

    public static void renderDisplayValueOnly(FacesContext facesContext, UIInput input) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("span", (UIComponent)input);
        HtmlRendererUtils.writeIdIfNecessary(writer, (UIComponent)input, facesContext);
        HtmlRendererUtils.renderDisplayValueOnlyAttributes((UIComponent)input, writer);
        String strValue = RendererUtils.getStringValue(facesContext, (UIComponent)input);
        writer.write(HTMLEncoder.encode(strValue, true, true));
        writer.endElement("span");
    }

    public static void renderHiddenCommandFormParams(ResponseWriter writer, Set dummyFormParams) throws IOException {
        Iterator it = dummyFormParams.iterator();
        while (it.hasNext()) {
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"hidden", null);
            writer.writeAttribute("name", it.next(), null);
            writer.endElement("input");
        }
    }

    public static void renderClearHiddenCommandFormParamsFunction(ResponseWriter writer, String formName, Set dummyFormParams, String formTarget) throws IOException {
        String functionName = HtmlRendererUtils.getClearHiddenCommandFormParamsFunctionName(formName);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer script = new StringBuffer();
        script.append("\nfunction ");
        script.append(functionName);
        script.append("() {");
        if (dummyFormParams != null) {
            script.append("\n  var f = document.forms['");
            script.append(formName);
            script.append("'];");
            Iterator it = dummyFormParams.iterator();
            while (it.hasNext()) {
                script.append("\n  f.elements['");
                script.append((String)it.next());
                script.append("'].value='';");
            }
        }
        script.append("\n  f.target=");
        if (formTarget == null || formTarget.length() == 0) {
            script.append("'';");
        } else {
            script.append("'");
            script.append(formTarget);
            script.append("';");
        }
        script.append("\n}");
        script.append("\n");
        script.append(functionName);
        script.append("();");
        script.append("\n");
        writer.writeComment((Object)script);
        writer.endElement("script");
    }

    public static String getClearHiddenCommandFormParamsFunctionName(String formName) {
        return "clear_" + JavascriptUtils.getValidJavascriptName(formName, false);
    }

    public static String getFormName(UIComponent component, FacesContext context) {
        UIComponent parent;
        for (parent = component.getParent(); parent != null && !(parent instanceof UIForm); parent = parent.getParent()) {
        }
        if (parent != null) {
            return ((UIForm)parent).getClientId(context);
        }
        return "linkDummyForm";
    }

    public static String getHiddenCommandLinkFieldName(String formName) {
        return formName + ':' + HIDDEN_COMMANDLINK_FIELD_NAME;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class LinkParameter {
        private String _name;
        private Object _value;

        public String getName() {
            return this._name;
        }

        public void setName(String name) {
            this._name = name;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object value) {
            this._value = value;
        }
    }
}

