/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.ejb.mdb;

import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.monitor.message.ParallelLogOutputInfo;
import com.clustercontrol.monitor.util.SendMail;
import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendMailBean
implements MessageDrivenBean,
MessageListener {
    protected static Log m_log = LogFactory.getLog(SendMailBean.class);
    private static SendMail m_sender = new SendMail();
    private MessageDrivenContext messageContext = null;

    public void setMessageDrivenContext(MessageDrivenContext messageContext) throws EJBException {
        this.messageContext = messageContext;
    }

    public void ejbCreate() {
    }

    public void ejbRemove() {
        this.messageContext = null;
    }

    public void onMessage(Message message) {
        m_log.debug((Object)("Message Driven Bean got message " + message));
        if (message instanceof ObjectMessage) {
            ObjectMessage msg = (ObjectMessage)message;
            try {
                Serializable objMsg = msg.getObject();
                if (objMsg instanceof ParallelLogOutputInfo) {
                    LogOutputInfo info = ((ParallelLogOutputInfo)objMsg).getLogOutputInfo();
                    m_sender.sendMail(info.getAddress(), info, ((ParallelLogOutputInfo)objMsg).getOutputDate());
                } else {
                    m_log.debug((Object)("onMessage(): ObjectMessage is not an expected instance. " + objMsg.toString()));
                }
            }
            catch (JMSException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()));
            }
            catch (EJBException e) {
                m_log.error((Object)("onMessage():" + e.getMessage()));
            }
            catch (Exception e) {
                m_log.error((Object)("onMessage():" + e.getMessage()));
            }
        }
    }
}

