/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.ChannelContextDependency;
import org.jacorb.notification.Dependant;
import org.jacorb.notification.EventChannelDependency;
import org.jacorb.notification.FilterManager;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.MessageFactoryDependency;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.QoSAdminOperations;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.EventChannel;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterAdminOperations;
import org.omg.CosNotifyFilter.FilterNotFound;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class AbstractAdmin
implements QoSAdminOperations,
FilterAdminOperations,
FilterStage,
Dependant,
ManageableServant,
ChannelContextDependency,
Configurable,
MessageFactoryDependency,
EventChannelDependency {
    protected static final InterFilterGroupOperator DEFAULT_FILTER_GROUP_OPERATOR = InterFilterGroupOperator.AND_OP;
    protected OfferManager offerManager_;
    protected SubscriptionManager subscriptionManager_;
    protected Logger logger_ = null;
    protected final Object modifyProxiesLock_ = new Object();
    protected final Map pullServants_ = new HashMap();
    protected final Map pushServants_ = new HashMap();
    private Integer id_;
    private boolean isIDPublic_;
    private POA poa_;
    private ORB orb_;
    private InterFilterGroupOperator filterGroupOperator_;
    private FilterManager filterManager_;
    private final SynchronizedInt proxyIdPool_ = new SynchronizedInt(0);
    private QoSPropertySet qosSettings_;
    private final SynchronizedBoolean disposed_ = new SynchronizedBoolean(false);
    private final List proxyEventListener_ = new ArrayList();
    private MessageFactory messageFactory_;
    private Runnable disposeHook_;
    private ChannelContext channelContext_;
    private EventChannel eventChannel_;

    public void configure(Configuration configuration) {
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.filterManager_.configure(configuration);
        this.qosSettings_ = new QoSPropertySet(configuration, 1);
    }

    public final void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory_ = messageFactory;
    }

    public void setDisposeHook(Runnable runnable) {
        this.disposeHook_ = runnable;
    }

    public void setInterFilterGroupOperator(InterFilterGroupOperator interFilterGroupOperator) {
        this.filterGroupOperator_ = interFilterGroupOperator;
    }

    public void setID(Integer n) {
        this.id_ = n;
    }

    public void setIsIDPublic(boolean bl) {
        this.isIDPublic_ = bl;
    }

    protected POA getPOA() {
        return this.poa_;
    }

    public void setPOA(POA pOA) {
        this.poa_ = pOA;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    public void setORB(ORB oRB) {
        this.orb_ = oRB;
        this.filterManager_ = new FilterManager(oRB);
        this.configure((Configuration)((org.jacorb.orb.ORB)this.getORB()).getConfiguration());
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory_;
    }

    public POA _default_POA() {
        return this.getPOA();
    }

    int getProxyID() {
        return this.proxyIdPool_.increment();
    }

    public List getFilters() {
        return this.filterManager_.getFilters();
    }

    public int add_filter(Filter filter) {
        return this.filterManager_.add_filter(filter);
    }

    public void remove_filter(int n) throws FilterNotFound {
        this.filterManager_.remove_filter(n);
    }

    public Filter get_filter(int n) throws FilterNotFound {
        return this.filterManager_.get_filter(n);
    }

    public int[] get_all_filters() {
        return this.filterManager_.get_all_filters();
    }

    public void remove_all_filters() {
        this.filterManager_.remove_all_filters();
    }

    public final InterFilterGroupOperator MyOperator() {
        return this.filterGroupOperator_;
    }

    public final EventChannel MyChannel() {
        return this.eventChannel_;
    }

    public final void setEventChannel(EventChannel eventChannel) {
        this.eventChannel_ = eventChannel;
    }

    public final int MyID() {
        return this.getID();
    }

    public Property[] get_qos() {
        return this.qosSettings_.get_qos();
    }

    public void set_qos(Property[] propertyArray) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(propertyArray);
    }

    public void validate_qos(Property[] propertyArray, NamedPropertyRangeSeqHolder namedPropertyRangeSeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(propertyArray, namedPropertyRangeSeqHolder);
    }

    public void destroy() {
        this.dispose();
    }

    private void checkDisposalStatus() throws OBJECT_NOT_EXIST {
        if (this.disposed_.get()) {
            throw new OBJECT_NOT_EXIST();
        }
        this.disposed_.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeProxies() {
        Object object = this.modifyProxiesLock_;
        synchronized (object) {
            Disposable disposable;
            this.logger_.debug("dispose PushServants");
            Iterator iterator = this.pushServants_.values().iterator();
            while (iterator.hasNext()) {
                try {
                    disposable = (Disposable)iterator.next();
                    iterator.remove();
                    disposable.dispose();
                }
                catch (Exception exception) {
                    this.logger_.warn("Error disposing a PushServant", (Throwable)exception);
                }
            }
            this.pushServants_.clear();
            this.logger_.debug("dispose PullServants");
            iterator = this.pullServants_.values().iterator();
            while (iterator.hasNext()) {
                try {
                    disposable = (Disposable)iterator.next();
                    iterator.remove();
                    disposable.dispose();
                }
                catch (Exception exception) {
                    this.logger_.warn("Error disposing a PullServant", (Throwable)exception);
                }
            }
            this.pullServants_.clear();
        }
    }

    public void dispose() {
        this.checkDisposalStatus();
        this.deactivate();
        this.remove_all_filters();
        this.disposeProxies();
        this.disposeHook_.run();
    }

    public void deactivate() {
        this.logger_.debug("deactivate Admin");
        try {
            byte[] byArray = this.getPOA().servant_to_id(this.getServant());
            this.getPOA().deactivate_object(byArray);
        }
        catch (Exception exception) {
            this.logger_.fatalError("Couldn't deactivate Admin", (Throwable)exception);
        }
    }

    public abstract Servant getServant();

    public Integer getID() {
        return this.id_;
    }

    public boolean isDisposed() {
        return this.disposed_.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCreateProxyRequestEvent() throws AdminLimitExceeded {
        List list = this.proxyEventListener_;
        synchronized (list) {
            ProxyEvent proxyEvent = new ProxyEvent(this);
            Iterator iterator = this.proxyEventListener_.iterator();
            while (iterator.hasNext()) {
                ProxyEventListener proxyEventListener = (ProxyEventListener)iterator.next();
                proxyEventListener.actionProxyCreationRequest(proxyEvent);
            }
        }
    }

    public boolean hasLifetimeFilter() {
        return false;
    }

    public boolean hasPriorityFilter() {
        return false;
    }

    public MappingFilter getLifetimeFilter() {
        throw new UnsupportedOperationException();
    }

    public MappingFilter getPriorityFilter() {
        throw new UnsupportedOperationException();
    }

    public void setOfferManager(OfferManager offerManager) {
        this.offerManager_ = offerManager;
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager_ = subscriptionManager;
    }

    public boolean hasInterFilterGroupOperatorOR() {
        return this.filterGroupOperator_ != null && this.filterGroupOperator_.value() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractProxy getProxy(int n) throws ProxyNotFound {
        Integer n2 = new Integer(n);
        AbstractProxy abstractProxy = null;
        Object object = this.modifyProxiesLock_;
        synchronized (object) {
            abstractProxy = (AbstractProxy)this.pullServants_.get(n2);
            if (abstractProxy == null) {
                abstractProxy = (AbstractProxy)this.pushServants_.get(n2);
            }
        }
        if (abstractProxy == null) {
            throw new ProxyNotFound("The proxy with ID=" + n + " does not exist");
        }
        if (!abstractProxy.isIDPublic()) {
            throw new ProxyNotFound("The proxy with ID=" + n + " is a EventStyle proxy and therefor not accessible by ID");
        }
        return abstractProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] get_all_notify_proxies(Map map, Object object) {
        ArrayList arrayList = new ArrayList();
        Object object2 = object;
        synchronized (object2) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((AbstractProxy)entry.getValue()).isIDPublic()) continue;
                arrayList.add(entry.getKey());
            }
        }
        object2 = new int[arrayList.size()];
        for (int i = 0; i < ((Object)object2).length; ++i) {
            object2[i] = (Integer)arrayList.get(i);
        }
        return object2;
    }

    protected void configureEventStyleID(AbstractProxy abstractProxy) {
        abstractProxy.setID(new Integer(this.getProxyID()), false);
        this.channelContext_.resolveDependencies(abstractProxy);
        abstractProxy.setFilterManager(FilterManager.EMPTY_FILTER_MANAGER);
    }

    protected void configureNotifyStyleID(AbstractProxy abstractProxy) {
        abstractProxy.setID(new Integer(this.getProxyID()), true);
        this.channelContext_.resolveDependencies(abstractProxy);
    }

    protected void configureQoS(AbstractProxy abstractProxy) throws UnsupportedQoS {
        abstractProxy.set_qos(this.qosSettings_.get_qos());
    }

    protected void configureInterFilterGroupOperator(AbstractProxy abstractProxy) {
        if (this.filterGroupOperator_ != null && this.filterGroupOperator_.value() == 1) {
            abstractProxy.setInterFilterGroupOperatorOR(true);
        }
    }

    protected void configureManagers(AbstractProxy abstractProxy) {
        abstractProxy.setOfferManager(this.offerManager_);
        abstractProxy.setSubscriptionManager(this.subscriptionManager_);
    }

    public void preActivate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyEventListener(ProxyEventListener proxyEventListener) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.add(proxyEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProxyEventListener(ProxyEventListener proxyEventListener) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            this.proxyEventListener_.remove(proxyEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProxyRemoved(AbstractProxy abstractProxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator iterator = this.proxyEventListener_.iterator();
            ProxyEvent proxyEvent = new ProxyEvent(abstractProxy);
            while (iterator.hasNext()) {
                ((ProxyEventListener)iterator.next()).actionProxyDisposed(proxyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProxyCreated(AbstractProxy abstractProxy) {
        List list = this.proxyEventListener_;
        synchronized (list) {
            Iterator iterator = this.proxyEventListener_.iterator();
            ProxyEvent proxyEvent = new ProxyEvent(abstractProxy);
            while (iterator.hasNext()) {
                ((ProxyEventListener)iterator.next()).actionProxyCreated(proxyEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProxyToMap(final AbstractProxy abstractProxy, final Map map, final Object object) {
        Object object2 = object;
        synchronized (object2) {
            map.put(abstractProxy.getID(), abstractProxy);
            this.fireProxyCreated(abstractProxy);
        }
        abstractProxy.setDisposeHook(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object2 = object;
                synchronized (object2) {
                    map.remove(abstractProxy.getID());
                    AbstractAdmin.this.fireProxyRemoved(abstractProxy);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getProxies() {
        ArrayList arrayList = new ArrayList();
        Object object = this.modifyProxiesLock_;
        synchronized (object) {
            arrayList.addAll(this.pullServants_.values());
            arrayList.addAll(this.pushServants_.values());
        }
        return arrayList;
    }

    public final void setChannelContext(ChannelContext channelContext) {
        this.channelContext_ = channelContext;
    }

    public ChannelContext getChannelContext() {
        return this.channelContext_;
    }
}

