/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;

public abstract class AbstractObjectPool
implements Runnable,
Configurable {
    public static final boolean DEBUG = false;
    public static final long SLEEP = 5000L;
    public static final int LOWER_WATERMARK_DEFAULT = 30;
    public static final int SIZE_INCREASE_DEFAULT = 30;
    public static final int INITIAL_SIZE_DEFAULT = 100;
    public static final int MAXIMUM_WATERMARK_DEFAULT = 1000;
    private static final List sPoolsToLookAfter = new ArrayList();
    private static AbstractObjectPool[] asArray;
    private static boolean modified;
    private static final AbstractObjectPool[] ARRAY_TEMPLATE;
    private static Thread sCleanerThread;
    private static ListCleaner sListCleaner;
    private String name_;
    private LinkedList pool_;
    private Set active_ = Collections.synchronizedSet(new HashSet());
    private int lowerWatermark_;
    private int maxWatermark_;
    private int sizeIncrease_;
    private int initialSize_;
    protected Logger logger_;
    protected Configuration config_;
    static /* synthetic */ Class class$org$jacorb$notification$util$AbstractObjectPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AbstractObjectPool[] getAllPools() {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            if (modified) {
                asArray = sPoolsToLookAfter.toArray(ARRAY_TEMPLATE);
                modified = false;
            }
        }
        return asArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerPool(AbstractObjectPool abstractObjectPool) {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            sPoolsToLookAfter.add(abstractObjectPool);
            modified = true;
            AbstractObjectPool.startListCleaner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deregisterPool(AbstractObjectPool abstractObjectPool) {
        List list = sPoolsToLookAfter;
        synchronized (list) {
            sPoolsToLookAfter.remove(abstractObjectPool);
            modified = true;
            if (sPoolsToLookAfter.isEmpty()) {
                AbstractObjectPool.getAllPools();
                AbstractObjectPool.stopListCleaner();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ListCleaner getListCleaner() {
        Class clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
        synchronized (clazz) {
            if (sListCleaner == null) {
                sListCleaner = new ListCleaner();
            }
            return sListCleaner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopListCleaner() {
        Class clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
        synchronized (clazz) {
            if (sCleanerThread != null) {
                sListCleaner.setInactive();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startListCleaner() {
        Class clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
        synchronized (clazz) {
            if (sCleanerThread == null) {
                sCleanerThread = new Thread(AbstractObjectPool.getListCleaner());
                sCleanerThread.setName("ObjectPoolCleaner");
                sCleanerThread.setPriority(2);
                sCleanerThread.setDaemon(true);
                sCleanerThread.start();
            }
        }
    }

    public void configure(Configuration configuration) {
        this.config_ = configuration;
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.init();
        AbstractObjectPool.registerPool(this);
    }

    protected AbstractObjectPool(String string) {
        this(string, 30, 30, 100, 1000);
    }

    protected AbstractObjectPool(String string, int n, int n2, int n3, int n4) {
        this.name_ = string;
        this.pool_ = new LinkedList();
        this.lowerWatermark_ = n;
        this.sizeIncrease_ = n2;
        this.initialSize_ = n3;
        this.maxWatermark_ = n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        AbstractList abstractList = this.pool_;
        synchronized (abstractList) {
            if (this.pool_.size() > this.lowerWatermark_) {
                return;
            }
        }
        abstractList = new ArrayList(this.sizeIncrease_);
        for (int i = 0; i < this.sizeIncrease_; ++i) {
            Object object = this.createInstance();
            abstractList.add(object);
        }
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            this.pool_.addAll(abstractList);
        }
    }

    private Object createInstance() {
        Object object = this.newInstance();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            for (int i = 0; i < this.initialSize_; ++i) {
                Object object = this.createInstance();
                this.pool_.add(object);
            }
        }
    }

    public void dispose() {
        AbstractObjectPool.deregisterPool(this);
        this.pool_.clear();
        this.active_.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lendObject() {
        Object object = null;
        LinkedList linkedList = this.pool_;
        synchronized (linkedList) {
            if (!this.pool_.isEmpty()) {
                object = this.pool_.removeFirst();
            }
        }
        if (object == null) {
            object = this.createInstance();
        }
        try {
            ((Configurable)object).configure(this.config_);
        }
        catch (ClassCastException classCastException) {
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.activateObject(object);
        this.active_.add(object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        if (this.active_.remove(object)) {
            this.passivateObject(object);
            if (this.pool_.size() < this.maxWatermark_) {
                LinkedList linkedList = this.pool_;
                synchronized (linkedList) {
                    this.pool_.add(object);
                    this.pool_.notifyAll();
                }
            } else {
                this.destroyObject(object);
            }
        }
    }

    public abstract Object newInstance();

    public void passivateObject(Object object) {
    }

    public void activateObject(Object object) {
    }

    public void destroyObject(Object object) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        modified = true;
        ARRAY_TEMPLATE = new AbstractObjectPool[0];
    }

    private static class ListCleaner
    extends Thread {
        private SynchronizedBoolean active_ = new SynchronizedBoolean(true);

        private ListCleaner() {
        }

        public void setInactive() {
            this.active_.set(false);
            this.interrupt();
        }

        private void ensureIsActive() throws InterruptedException {
            if (!this.active_.get()) {
                throw new InterruptedException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class clazz;
            try {
                while (this.active_.get()) {
                    try {
                        this.runLoop();
                    }
                    catch (Exception exception) {}
                }
                Object var3_2 = null;
                clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Class clazz2 = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
                synchronized (clazz2) {
                    sCleanerThread = null;
                }
                throw throwable;
            }
            synchronized (clazz) {
                sCleanerThread = null;
            }
        }

        private void runLoop() throws InterruptedException {
            block4: while (true) {
                try {
                    ListCleaner.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.ensureIsActive();
                AbstractObjectPool[] abstractObjectPoolArray = AbstractObjectPool.getAllPools();
                int n = 0;
                while (true) {
                    if (n >= abstractObjectPoolArray.length) continue block4;
                    try {
                        abstractObjectPoolArray[n].run();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    ++n;
                }
                break;
            }
        }
    }
}

