/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.ArrayList;
import org.jacorb.notification.util.PatternWrapper;
import org.jacorb.notification.util.WCEntry;
import org.jacorb.notification.util.WildcardMap;

class EntryList {
    private static int DEFAULT_INITIAL_SIZE = 2;
    private PatternWrapper myPattern_;
    private char[] key_;
    private int start_;
    private int end_;
    private int depth_;
    private int splitted = 0;
    private WCEntry myEntry_;
    private EntryList[] entries_;

    EntryList(int n) {
        this(null, 0, 0, 0, null, n);
    }

    private EntryList(char[] cArray, int n, int n2, int n3, WCEntry wCEntry) {
        this(cArray, n, n2, n3, wCEntry, DEFAULT_INITIAL_SIZE);
    }

    private EntryList(char[] cArray, int n, int n2, int n3, WCEntry wCEntry, int n4) {
        this.myEntry_ = wCEntry;
        this.key_ = cArray;
        this.end_ = n2;
        this.start_ = n;
        this.depth_ = n3;
        this.entries_ = new EntryList[n4];
        this.initPattern(this.key_, this.start_, this.end_);
    }

    private boolean hasEntry() {
        return this.myEntry_ != null;
    }

    void clear() {
        this.entries_ = new EntryList[DEFAULT_INITIAL_SIZE];
    }

    Object put(WCEntry wCEntry) {
        char c = wCEntry.key_[0];
        this.ensureIndexIsAvailable(c);
        int n = this.computeHashIndex(c);
        if (this.entries_[n] == null) {
            this.entries_[n] = new EntryList(wCEntry.key_, 0, wCEntry.key_.length, 0, wCEntry);
            return null;
        }
        return this.entries_[n].put(wCEntry.key_, 0, wCEntry.key_.length, 0, wCEntry, false);
    }

    Object put(char[] cArray, int n, int n2, int n3, WCEntry wCEntry, boolean bl) {
        int n4 = n2 - n;
        int n5 = this.end_ - this.start_;
        int n6 = this.findCommonPrefix(cArray, n, n2);
        if (n6 == n4) {
            if (this.endsWithStar()) {
                EntryList.splitEntryList(this, n6);
            }
            Object object = null;
            if (this.myEntry_ != null) {
                object = this.myEntry_.getValue();
            }
            this.myEntry_ = wCEntry;
            return object;
        }
        if (n6 < n5) {
            EntryList.splitEntryList(this, n6);
            boolean bl2 = false;
            if (this.endsWithStar()) {
                bl2 = true;
            }
            this.put(cArray, n, n2, n3 + n6, wCEntry, bl2);
        } else {
            char c = cArray[n + n6];
            this.ensureIndexIsAvailable(c);
            int n7 = this.computeHashIndex(c);
            if (this.entries_[n7] == null) {
                this.entries_[n7] = new EntryList(cArray, n + n6, n2, this.depth_ + n6, wCEntry);
                if (bl) {
                    this.entries_[n7].addLeadingStar();
                }
            } else {
                this.entries_[n7].put(cArray, n + n6, n2, n3 + n6, wCEntry, false);
            }
        }
        return null;
    }

    Object getSingle(char[] cArray, int n, int n2) {
        EntryList entryList = this.lookup(cArray[n]);
        int n3 = n;
        while (entryList != null) {
            int n4 = n2 - n3;
            int n5 = entryList.compare(cArray, n + entryList.depth_, n + entryList.depth_ + n4, false);
            if (n5 == n4) {
                return entryList.myEntry_.getValue();
            }
            if (n5 <= 0) continue;
            char c = cArray[n + entryList.depth_ + n5];
            int n6 = entryList.depth_;
            if ((entryList = entryList.lookup(c)) == null) continue;
            n3 += entryList.depth_ - n6;
        }
        return null;
    }

    private boolean endsWithStar() {
        return this.key_[this.end_ - 1] == '*';
    }

    Object[] getMultiple(char[] cArray, int n, int n2) {
        ArrayList<Cursor> arrayList = new ArrayList<Cursor>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        EntryList entryList = this.lookup(cArray[n]);
        if (entryList != null) {
            arrayList.add(new Cursor(n, entryList));
        }
        if ((entryList = this.lookup('*')) != null) {
            Cursor cursor = new Cursor(n, entryList);
            arrayList.add(cursor);
        }
        while (!arrayList.isEmpty()) {
            char c;
            Cursor cursor = (Cursor)arrayList.get(0);
            int n3 = n2 - cursor.cursor_;
            int n4 = cursor.list_.compare(cArray, n + cursor.list_.depth_, n + cursor.list_.depth_ + n3, true);
            if (n4 >= n3) {
                if (cursor.list_.hasEntry()) {
                    arrayList2.add(cursor.list_.myEntry_.getValue());
                }
                if (n3 > 0 && cursor.list_.endsWithStar()) {
                    for (c = '\u0000'; c < cursor.list_.entries_.length; ++c) {
                        if (cursor.list_.entries_[c] == null) continue;
                        arrayList.add(new Cursor(cursor.list_.depth_ + 1, cursor.list_.entries_[c]));
                    }
                }
                if (cursor.list_.lookup('*') != null) {
                    cursor.list_ = cursor.list_.lookup('*');
                    cursor.cursor_ += n4;
                    continue;
                }
                arrayList.remove(0);
                continue;
            }
            if (n4 > 0) {
                c = cArray[n + cursor.list_.depth_ + n4];
                int n5 = cursor.list_.depth_;
                if (cursor.list_.lookup('*') != null) {
                    EntryList entryList2 = cursor.list_.lookup('*');
                    arrayList.add(new Cursor(cursor.cursor_ + entryList2.depth_ - n5, entryList2));
                }
                if ((cursor.list_ = cursor.list_.lookup(c)) != null) {
                    cursor.cursor_ += cursor.list_.depth_ - n5;
                    continue;
                }
                arrayList.remove(0);
                continue;
            }
            arrayList.remove(0);
        }
        return arrayList2.toArray();
    }

    Object remove(char[] cArray, int n, int n2) {
        return EntryList.remove(this, cArray, n, n2);
    }

    private static Object remove(EntryList entryList, char[] cArray, int n, int n2) {
        int n3;
        char c;
        int n4 = n;
        EntryList entryList2 = entryList;
        do {
            if ((n4 += (n3 = EntryList.findCommonPrefix(cArray, n4, n2, entryList2.key_, entryList2.start_, entryList2.end_))) != n2) continue;
            Object object = null;
            if (entryList2.myEntry_ != null) {
                object = entryList2.myEntry_.getValue();
                entryList2.myEntry_ = null;
            }
            return object;
        } while ((entryList2 = entryList2.lookup(c = cArray[n + n3])) != null);
        return null;
    }

    private void addLeadingStar() {
        int n = this.end_ - this.start_ + 1;
        char[] cArray = new char[n];
        System.arraycopy(this.key_, this.start_, cArray, 1, this.end_ - this.start_);
        cArray[0] = 42;
        this.initPattern(cArray, 0, n);
    }

    private void initPattern() {
        this.initPattern(this.key_, this.start_, this.end_);
    }

    private void initPattern(char[] cArray, int n, int n2) {
        this.myPattern_ = null;
        int n3 = WildcardMap.countStarsInKey(cArray, n, n2);
        if (n3 > 0) {
            char[] cArray2 = new char[n2 - n + n3 + 1];
            cArray2[0] = 94;
            int n4 = 1;
            for (int i = 0; i < n2 - n; ++i) {
                char c;
                cArray2[i + n4] = c = cArray[n + i];
                if (cArray2[i + n4] != '*') continue;
                cArray2[i + n4] = 46;
                cArray2[i + n4 + 1] = 42;
                ++n4;
            }
            String string = new String(cArray2, 0, n2 - n + n3 + 1);
            this.myPattern_ = PatternWrapper.init(string);
        }
    }

    private char key() {
        return this.key_[this.start_];
    }

    private int keyLength() {
        return this.end_ - this.start_;
    }

    private EntryList lookup(char c) {
        int n = this.computeHashIndex(c);
        if (this.entries_[n] != null && this.entries_[n].key() == c) {
            return this.entries_[n];
        }
        return null;
    }

    private void ensureIndexIsAvailable(char c) {
        int n = this.computeHashIndex(c);
        while (this.entries_[n] != null && this.entries_[n].key() != c) {
            this.doubleCapacity();
            n = this.computeHashIndex(c);
        }
        return;
    }

    private void doubleCapacity() {
        int n = this.entries_.length * 2;
        EntryList[] entryListArray = new EntryList[n];
        for (int i = 0; i < this.entries_.length; ++i) {
            if (this.entries_[i] == null) continue;
            int n2 = EntryList.computeHashIndex(this.entries_[i].key(), n);
            entryListArray[n2] = this.entries_[i];
        }
        this.entries_ = entryListArray;
    }

    private int compare(char[] cArray, int n, int n2, boolean bl) {
        if (bl && this.myPattern_ != null) {
            return EntryList.compareKeyToPattern(cArray, n, n2, this.myPattern_);
        }
        return EntryList.compareKeyToKey(cArray, n, n2, this.key_, this.start_, this.end_);
    }

    private int findCommonPrefix(char[] cArray, int n, int n2) {
        return EntryList.findCommonPrefix(cArray, n, n2, this.key_, this.start_, this.end_);
    }

    private void printToStringBuffer(StringBuffer stringBuffer, String string) {
        if (this.key_ != null) {
            stringBuffer.append(" --");
            stringBuffer.append(this.key());
            stringBuffer.append("-->\n");
            stringBuffer.append(string);
            stringBuffer.append("depth: ");
            stringBuffer.append(this.depth_);
            stringBuffer.append("\n");
            stringBuffer.append(string);
            stringBuffer.append("key: ");
            stringBuffer.append(new String(this.key_, this.start_, this.end_ - this.start_));
            stringBuffer.append("\n");
        }
        if (this.myEntry_ != null) {
            stringBuffer.append(string + this.myEntry_);
            stringBuffer.append("\n");
        }
        for (int i = 0; i < this.entries_.length; ++i) {
            stringBuffer.append(string + i);
            stringBuffer.append(":");
            if (this.entries_[i] == null) {
                stringBuffer.append("empty");
            } else {
                this.entries_[i].printToStringBuffer(stringBuffer, string + "   ");
            }
            stringBuffer.append("\n");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.printToStringBuffer(stringBuffer, "");
        return stringBuffer.toString();
    }

    private static void splitEntryList(EntryList entryList, int n) {
        EntryList entryList2 = new EntryList(entryList.key_, entryList.start_ + n, entryList.end_, entryList.depth_ + n, entryList.myEntry_, entryList.entries_.length);
        System.arraycopy(entryList.entries_, 0, entryList2.entries_, 0, entryList.entries_.length);
        entryList.entries_ = new EntryList[DEFAULT_INITIAL_SIZE];
        char c = entryList.key_[entryList.start_ + n];
        int n2 = EntryList.computeHashIndex(c, entryList.entries_.length);
        entryList.entries_[n2] = entryList2;
        entryList.myEntry_ = null;
        ++entryList.splitted;
        entryList.end_ = entryList.start_ + n;
        if (entryList.endsWithStar()) {
            entryList2.addLeadingStar();
        }
        entryList.initPattern();
    }

    private static int computeHashIndex(char c, int n) {
        return c % n;
    }

    private int computeHashIndex(char c) {
        return EntryList.computeHashIndex(c, this.entries_.length);
    }

    static int compareKeyToKey(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        int n5;
        int n6 = n2 - n;
        int n7 = n4 - n3;
        int n8 = n6 > n7 ? n7 : n6;
        for (n5 = 0; n5 < n8; ++n5) {
            if (cArray[n + n5] == cArray2[n3 + n5]) continue;
            return n5;
        }
        return n5;
    }

    private static int compareKeyToPattern(char[] cArray, int n, int n2, PatternWrapper patternWrapper) {
        String string = new String(cArray, n, n2 - n);
        return patternWrapper.match(string);
    }

    private static int findCommonPrefix(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n2 - n;
        int n8 = n4 - n3;
        int n9 = n6 = n7 >= n8 ? n8 : n7;
        for (n5 = 0; n5 < n6 && cArray[n] == cArray2[n3]; ++n5) {
            ++n;
            ++n3;
        }
        return n5;
    }

    private static class Cursor {
        int cursor_;
        EntryList list_;

        Cursor(int n, EntryList entryList) {
            this.cursor_ = n;
            this.list_ = entryList;
        }

        public String toString() {
            String string = new String(this.list_.key_, this.cursor_, this.list_.end_ - this.cursor_);
            return "Cursor: " + string;
        }
    }
}

