/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.offers;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.client.util.Constrain;
import org.jacorb.trading.client.util.QuickSort;
import org.omg.CORBA.Object;
import org.omg.CosTrading.IllegalConstraint;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPackage.NoMatchingOffers;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;

public class ConstraintDialog
extends Dialog
implements ActionListener,
Runnable {
    private Choice m_types;
    private TextField m_constraint;
    private Button m_ok;
    private Button m_cancel;
    private Label m_status;
    private Register m_register;
    private ServiceTypeRepository m_repos;
    private Vector m_listeners = new Vector();
    private String m_actionCommand;

    public ConstraintDialog(Frame frame, Register register) {
        super(frame, "Withdraw", false);
        this.m_register = register;
        Object object = register.type_repos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(object);
        this.createContents();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConstraintDialog.this.cancel();
            }
        });
        Point point = this.getParent().getLocation();
        this.setLocation(point.x + 30, point.y + 30);
    }

    protected void createContents() {
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0, 0, 0));
        panel2.add(new Label("Service type", 0));
        this.m_types = new Choice();
        this.loadTypes(this.m_types);
        panel2.add(this.m_types);
        Constrain.constrain(panel, panel2, 0, 0, 2, 1, 2, 18, 1.0, 0.0, 5, 10, 0, 10);
        Constrain.constrain(panel, new Label("Constraint", 0), 0, 1, 2, 1, 0, 18, 0.0, 0.0, 5, 10, 0, 10);
        this.m_constraint = new TextField(50);
        this.m_constraint.setEditable(true);
        Constrain.constrain(panel, this.m_constraint, 0, 2, 2, 1, 2, 18, 1.0, 0.0, 0, 10, 0, 10);
        this.m_ok = new Button("OK");
        this.m_ok.setActionCommand("ok");
        this.m_ok.addActionListener(this);
        Constrain.constrain(panel, this.m_ok, 0, 3, 1, 1, 0, 18, 0.0, 0.0, 10, 10, 0, 0, 30, 3);
        this.m_cancel = new Button("Cancel");
        this.m_cancel.setActionCommand("cancel");
        this.m_cancel.addActionListener(this);
        Constrain.constrain(panel, this.m_cancel, 1, 3, 1, 1, 0, 12, 0.0, 0.0, 10, 0, 0, 10, 10, 3);
        this.m_status = new Label("", 0);
        Constrain.constrain(panel, this.m_status, 0, 4, 2, 1, 2, 18, 1.0, 0.0, 5, 10, 5, 10);
        this.add(panel);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_listeners.removeElement(actionListener);
    }

    public void setActionCommand(String string) {
        this.m_actionCommand = string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ok")) {
            this.ok();
        } else if (actionEvent.getActionCommand().equals("cancel")) {
            this.cancel();
        }
    }

    protected void ok() {
        new Thread(this).start();
    }

    protected void cancel() {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.showStatus("Withdrawing offers...");
            this.m_ok.setEnabled(false);
            this.m_cancel.setEnabled(false);
            String string = this.m_types.getSelectedItem();
            String string2 = this.m_constraint.getText();
            this.m_register.withdraw_using_constraint(string, string2);
            this.setVisible(false);
            this.notifyListeners();
            this.clearStatus();
        }
        catch (IllegalServiceType illegalServiceType) {
            this.showStatus("Illegal service type '" + illegalServiceType.type + "'");
        }
        catch (UnknownServiceType unknownServiceType) {
            this.showStatus("Unknown service type '" + unknownServiceType.type + "'");
        }
        catch (IllegalConstraint illegalConstraint) {
            this.showStatus("Illegal constraint");
        }
        catch (NoMatchingOffers noMatchingOffers) {
            this.showStatus("No matching offers found");
        }
        finally {
            this.m_ok.setEnabled(true);
            this.m_cancel.setEnabled(true);
        }
    }

    protected void notifyListeners() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.m_actionCommand);
        Enumeration enumeration = this.m_listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    protected void showStatus(String string) {
        this.m_status.setText(string);
    }

    protected void clearStatus() {
        this.m_status.setText("");
    }

    protected void loadTypes(Choice choice) {
        choice.removeAll();
        SpecifiedServiceTypes specifiedServiceTypes = new SpecifiedServiceTypes();
        specifiedServiceTypes.__default();
        String[] stringArray = this.m_repos.list_types(specifiedServiceTypes);
        QuickSort.sort(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            choice.add(stringArray[i]);
        }
    }
}

