/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.client.typemgr;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.client.typemgr.Lex;
import org.jacorb.trading.client.typemgr.LexException;
import org.jacorb.trading.client.typemgr.ParserException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropStruct;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;

public class Parser {
    private Lex m_lex;
    private String m_currentIdent;
    private String m_currentScopedName;
    private String m_name;
    private String m_interface;
    private PropStruct m_currentProperty;
    private PropStruct[] m_properties;
    private String[] m_superTypes;

    public void parse(Reader reader) throws ParserException {
        this.m_currentProperty = new PropStruct();
        try {
            this.m_lex = new Lex(reader);
            this.m_lex.nextToken();
            if (this.m_lex.getToken() == 1) {
                throw new ParserException("no input", 0);
            }
            this.parseService();
        }
        catch (LexException lexException) {
            throw new ParserException("Lexical error: " + lexException.getMessage(), lexException.getLine());
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getInterface() {
        return this.m_interface;
    }

    public PropStruct[] getProperties() {
        return this.m_properties;
    }

    public String[] getSuperTypes() {
        return this.m_superTypes;
    }

    protected void parseService() throws ParserException, LexException {
        int n = this.m_lex.getToken();
        if (n == 10) {
            this.m_lex.nextToken();
            this.parseScopedName();
            this.m_name = this.m_currentScopedName;
            this.parseBaseTypes();
            if (this.m_lex.getToken() != 2) {
                throw new ParserException("expected '{' symbol", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
            if (this.m_lex.getToken() != 11) {
                throw new ParserException("expected 'interface' declaration", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
            this.parseScopedName();
            this.m_interface = this.m_currentScopedName;
            if (this.m_lex.getToken() != 8) {
                throw new ParserException("expected ';' after 'interface' declaration", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
            this.parsePropertyList();
            if (this.m_lex.getToken() != 3) {
                throw new ParserException("expected '}' symbol", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
            if (this.m_lex.getToken() != 8) {
                throw new ParserException("expected ';' after 'service' declaration", this.m_lex.getLine());
            }
        } else {
            throw new ParserException("expected 'service' declaration", this.m_lex.getLine());
        }
        this.m_lex.nextToken();
    }

    protected void parseBaseTypes() throws ParserException, LexException {
        Vector<String> vector = new Vector<String>();
        int n = this.m_lex.getToken();
        if (n == 6) {
            this.m_lex.nextToken();
            this.parseScopedName();
            vector.addElement(this.m_currentScopedName);
            while (this.m_lex.getToken() == 9) {
                this.m_lex.nextToken();
                this.parseScopedName();
                vector.addElement(this.m_currentScopedName);
            }
        }
        this.m_superTypes = new String[vector.size()];
        vector.copyInto(this.m_superTypes);
    }

    protected void parseScopedName() throws ParserException, LexException {
        int n = this.m_lex.getToken();
        if (n != 12 && n != 7) {
            throw new ParserException("expected scoped identifier", this.m_lex.getLine());
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n == 12 || n == 7) {
            stringBuffer.append(this.m_lex.getLexeme());
            if (n == 12) {
                bl = true;
            }
            n2 = n;
            this.m_lex.nextToken();
            n = this.m_lex.getToken();
            if (n != 7 || n2 != 7) continue;
            throw new ParserException("malformed scoped identifier", this.m_lex.getLine());
        }
        if (!bl || n2 == 7) {
            throw new ParserException("malformed scoped identifier", this.m_lex.getLine());
        }
        this.m_currentScopedName = stringBuffer.toString();
    }

    protected void parseIdent() throws ParserException, LexException {
        int n = this.m_lex.getToken();
        if (n == 12) {
            this.m_currentIdent = this.m_lex.getLexeme();
            this.m_lex.nextToken();
        }
    }

    protected void parsePropertyList() throws ParserException, LexException {
        Vector<PropStruct> vector = new Vector<PropStruct>();
        int n = this.m_lex.getToken();
        while (n != 3) {
            this.parseProperty();
            vector.addElement(new PropStruct(this.m_currentProperty.name, this.m_currentProperty.value_type, this.m_currentProperty.mode));
            n = this.m_lex.getToken();
        }
        this.m_properties = new PropStruct[vector.size()];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            this.m_properties[n2++] = (PropStruct)enumeration.nextElement();
        }
    }

    protected void parseProperty() throws ParserException, LexException {
        this.m_currentProperty.mode = PropertyMode.PROP_NORMAL;
        this.parseQualifierList();
        int n = this.m_lex.getToken();
        if (n == 15) {
            this.m_lex.nextToken();
            this.parseIDLType();
            if (this.m_lex.getToken() != 12) {
                throw new ParserException("expected property identifier after IDL type", this.m_lex.getLine());
            }
            this.parseIdent();
            this.m_currentProperty.name = this.m_currentIdent;
            if (this.m_lex.getToken() != 8) {
                throw new ParserException("expected ';' after property declaration", this.m_lex.getLine());
            }
        } else {
            throw new ParserException("invalid property declaration", this.m_lex.getLine());
        }
        this.m_lex.nextToken();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseQualifierList() throws ParserException, LexException {
        int n = this.m_lex.getToken();
        while (n == 13 || n == 14) {
            PropertyMode propertyMode = this.m_currentProperty.mode;
            if (n == 13) {
                if (propertyMode == PropertyMode.PROP_NORMAL) {
                    propertyMode = PropertyMode.PROP_MANDATORY;
                } else {
                    if (propertyMode != PropertyMode.PROP_READONLY) throw new ParserException("duplicate 'mandatory' qualifier", this.m_lex.getLine());
                    propertyMode = PropertyMode.PROP_MANDATORY_READONLY;
                }
            } else if (n == 14) {
                if (propertyMode == PropertyMode.PROP_NORMAL) {
                    propertyMode = PropertyMode.PROP_READONLY;
                } else {
                    if (propertyMode != PropertyMode.PROP_MANDATORY) throw new ParserException("duplicate 'readonly' qualifier", this.m_lex.getLine());
                    propertyMode = PropertyMode.PROP_MANDATORY_READONLY;
                }
            }
            this.m_currentProperty.mode = propertyMode;
            this.m_lex.nextToken();
            n = this.m_lex.getToken();
        }
    }

    protected void parseIDLType() throws ParserException, LexException {
        int n = this.m_lex.getToken();
        if (n == 24) {
            this.m_lex.nextToken();
            if (this.m_lex.getToken() != 4) {
                throw new ParserException("expected '<' after 'sequence'", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
            this.parseType(true);
            if (this.m_lex.getToken() != 5) {
                throw new ParserException("expected '>' after sequence type", this.m_lex.getLine());
            }
            this.m_lex.nextToken();
        } else if (n == 25) {
            this.m_currentProperty.value_type = ORB.init().get_primitive_tc(TCKind.tk_null);
            this.m_lex.nextToken();
        } else {
            this.parseType(false);
        }
    }

    protected void parseType(boolean bl) throws ParserException, LexException {
        ORB oRB = ORB.init();
        int n = this.m_lex.getToken();
        switch (n) {
            case 16: {
                this.m_lex.nextToken();
                n = this.m_lex.getToken();
                if (n == 19) {
                    TypeCode typeCode = oRB.get_primitive_tc(TCKind.tk_short);
                    this.m_currentProperty.value_type = bl ? oRB.create_sequence_tc(0, typeCode) : typeCode;
                    this.m_lex.nextToken();
                    break;
                }
                if (n == 20) {
                    TypeCode typeCode = oRB.get_primitive_tc(TCKind.tk_ulong);
                    this.m_currentProperty.value_type = bl ? oRB.create_sequence_tc(0, typeCode) : typeCode;
                    this.m_lex.nextToken();
                    break;
                }
                throw new ParserException("only short and long can be unsigned", this.m_lex.getLine());
            }
            case 18: {
                TypeCode typeCode = oRB.get_primitive_tc(TCKind.tk_char);
                this.m_currentProperty.value_type = bl ? oRB.create_sequence_tc(0, typeCode) : typeCode;
                this.m_lex.nextToken();
                break;
            }
            case 17: {
                TypeCode typeCode = oRB.get_primitive_tc(TCKind.tk_boolean);
                this.m_currentProperty.value_type = bl ? oRB.create_sequence_tc(0, typeCode) : typeCode;
                this.m_lex.nextToken();
                break;
            }
            case 19: {
                TypeCode typeCode = oRB.get_primitive_tc(TCKind.tk_short);
                this.m_currentProperty.value_type = bl ? oRB.create_sequence_tc(0, typeCode) : typeCode;
                this.m_lex.nextToken();
                break;
            }
            case 20: {
                TypeCode typeCode = oRB.get_primitive_tc(TCKind.tk_long);
                this.m_currentProperty.value_type = bl ? oRB.create_sequence_tc(0, typeCode) : typeCode;
                this.m_lex.nextToken();
                break;
            }
            case 21: {
                TypeCode typeCode = oRB.get_primitive_tc(TCKind.tk_float);
                this.m_currentProperty.value_type = bl ? oRB.create_sequence_tc(0, typeCode) : typeCode;
                this.m_lex.nextToken();
                break;
            }
            case 22: {
                TypeCode typeCode = oRB.get_primitive_tc(TCKind.tk_double);
                this.m_currentProperty.value_type = bl ? oRB.create_sequence_tc(0, typeCode) : typeCode;
                this.m_lex.nextToken();
                break;
            }
            case 23: {
                TypeCode typeCode = oRB.get_primitive_tc(TCKind.tk_string);
                this.m_currentProperty.value_type = bl ? oRB.create_sequence_tc(0, typeCode) : typeCode;
                this.m_lex.nextToken();
                break;
            }
            default: {
                throw new ParserException("unknown/unsupported IDL type '" + this.m_lex.getLexeme() + "'", this.m_lex.getLine());
            }
        }
    }
}

