/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;

public class BooleanValue
implements Value {
    private Boolean m_value;

    public BooleanValue() {
        this(false);
    }

    public BooleanValue(boolean bl) {
        this.m_value = new Boolean(bl);
    }

    public BooleanValue(Object object) {
        this.m_value = (Boolean)object;
    }

    public void setValue(Object object) {
        this.m_value = (Boolean)object;
    }

    public int getTypeId() {
        return 0;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 0) {
            throw new IllegalArgumentException();
        }
        bl = this.m_value.equals(value.getValue());
        return bl;
    }

    public boolean lessThan(Value value) {
        boolean bl = false;
        if (value.getTypeId() != 0) {
            throw new IllegalArgumentException();
        }
        Boolean bl2 = (Boolean)value.getValue();
        bl = this.m_value == false && bl2 == true;
        return bl;
    }

    public boolean lessThanEqual(Value value) {
        return this.lessThan(value) || this.equals(value);
    }

    public boolean greaterThan(Value value) {
        return !this.lessThan(value) && !this.equals(value);
    }

    public boolean greaterThanEqual(Value value) {
        return !this.lessThan(value);
    }

    public Value plus(Value value) {
        throw new ArithmeticException();
    }

    public Value minus(Value value) {
        throw new ArithmeticException();
    }

    public Value multiply(Value value) {
        throw new ArithmeticException();
    }

    public Value divide(Value value) {
        throw new ArithmeticException();
    }

    public Value negate() {
        throw new ArithmeticException();
    }

    public Value convert(int n) {
        BooleanValue booleanValue = null;
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        booleanValue = new BooleanValue(this.m_value);
        return booleanValue;
    }

    public String toString() {
        return this.m_value.toString();
    }
}

