/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.BooleanValue;
import org.jacorb.trading.constraint.CharValue;
import org.jacorb.trading.constraint.DoubleValue;
import org.jacorb.trading.constraint.FloatValue;
import org.jacorb.trading.constraint.LongValue;
import org.jacorb.trading.constraint.ShortValue;
import org.jacorb.trading.constraint.StringValue;
import org.jacorb.trading.constraint.ULongValue;
import org.jacorb.trading.constraint.UShortValue;
import org.jacorb.trading.constraint.Value;

public class ValueFactory {
    private ValueFactory() {
    }

    public static Value create(int n, Object object) {
        Value value = null;
        switch (n) {
            case 0: {
                Boolean bl = (Boolean)object;
                value = ValueFactory.createBoolean(bl);
                break;
            }
            case 1: {
                Integer n2 = (Integer)object;
                value = ValueFactory.createShort(n2);
                break;
            }
            case 2: {
                Integer n3 = (Integer)object;
                value = ValueFactory.createUShort(n3);
                break;
            }
            case 3: {
                Integer n4 = (Integer)object;
                value = ValueFactory.createLong(n4);
                break;
            }
            case 4: {
                Long l = (Long)object;
                value = ValueFactory.createULong(l);
                break;
            }
            case 5: {
                Float f = (Float)object;
                value = ValueFactory.createFloat(f.floatValue());
                break;
            }
            case 6: {
                Double d = (Double)object;
                value = ValueFactory.createDouble(d);
                break;
            }
            case 7: {
                Character c = (Character)object;
                value = ValueFactory.createChar(c.charValue());
                break;
            }
            case 8: {
                String string = (String)object;
                value = ValueFactory.createString(string);
            }
        }
        return value;
    }

    public static Value createBoolean(boolean bl) {
        return new BooleanValue(bl);
    }

    public static Value createShort(int n) {
        return new ShortValue(n);
    }

    public static Value createUShort(int n) {
        return new UShortValue(n);
    }

    public static Value createLong(int n) {
        return new LongValue(n);
    }

    public static Value createULong(long l) {
        return new ULongValue(l);
    }

    public static Value createFloat(float f) {
        return new FloatValue(f);
    }

    public static Value createDouble(double d) {
        return new DoubleValue(d);
    }

    public static Value createChar(char c) {
        return new CharValue(c);
    }

    public static Value createString(String string) {
        return new StringValue(string);
    }
}

