/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alarm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.AttributeChangeNotification;
import javax.management.Notification;
import javax.management.ObjectName;
import org.jboss.monitor.alarm.Alarm;
import org.jboss.monitor.alarm.AlarmNotification;
import org.jboss.monitor.alarm.MBeanImplAccess;
import org.jboss.system.ServiceMBeanSupport;

public class AlarmManager {
    protected MBeanImplAccess mbeanImpl;
    private Map nameMap;

    public AlarmManager(MBeanImplAccess mbeanImpl) {
        this.mbeanImpl = mbeanImpl;
        this.nameMap = new HashMap();
    }

    public AlarmManager(final ServiceMBeanSupport service) {
        this(new MBeanImplAccess(){

            public ObjectName getMBeanName() {
                return service.getServiceName();
            }

            public long getSequenceNumber() {
                return service.nextNotificationSequenceNumber();
            }

            public void emitNotification(Notification n) {
                service.sendNotification(n);
            }
        });
    }

    public void setSeverity(String type, int severity) {
        this.setSeverity(this.mbeanImpl.getMBeanName(), type, severity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeverity(ObjectName name, String type, int severity) {
        AlarmManager alarmManager = this;
        synchronized (alarmManager) {
            Map typeMap = this.getTypeMap(name);
            Severity s = (Severity)typeMap.get(type);
            if (s == null) {
                typeMap.put(type, new Severity(severity));
            } else {
                s.severity = severity;
            }
        }
    }

    public int getSeverity(String type) {
        return this.getSeverity(this.mbeanImpl.getMBeanName(), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSeverity(ObjectName name, String type) {
        AlarmManager alarmManager = this;
        synchronized (alarmManager) {
            Map typeMap = (Map)this.nameMap.get(name);
            if (typeMap == null) {
                return 0;
            }
            Severity s = (Severity)typeMap.get(type);
            if (s == null) {
                return 0;
            }
            return s.severity;
        }
    }

    public String getSeverityAsString(String type) {
        return this.getSeverityAsString(this.mbeanImpl.getMBeanName(), type);
    }

    public String getSeverityAsString(ObjectName name, String type) {
        return Alarm.SEVERITY_STRINGS[this.getSeverity(name, type)];
    }

    public void setAlarm(String type, int severity, String message, Object userData) {
        this.setAlarm(this.mbeanImpl.getMBeanName(), type, severity, message, userData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlarm(ObjectName target, String type, int severity, String message, Object userData) {
        Severity s;
        AlarmManager alarmManager = this;
        synchronized (alarmManager) {
            Map typeMap = this.getTypeMap(target);
            s = (Severity)typeMap.get(type);
            if (s == null) {
                s = new Severity(0);
                typeMap.put(type, s);
            }
        }
        int oldSeverity = s.severity;
        if (severity != oldSeverity) {
            s.severity = severity;
            if (severity == 0) {
                this.sendAlarmNotification(target, type, severity, 0, message, userData);
            } else if (oldSeverity == 0) {
                this.sendAlarmNotification(target, type, severity, 2, message, userData);
            } else {
                this.sendAlarmNotification(target, type, severity, 1, message, userData);
            }
        }
    }

    public void setAlarm(String type, int severity, String message, String key, Object value) {
        this.setAlarm(this.mbeanImpl.getMBeanName(), type, severity, message, key, value);
    }

    public void setAlarm(ObjectName target, String type, int severity, String message, String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        this.setAlarm(target, type, severity, message, map);
    }

    public void sendAlarm(String type, int severity, String message, String key, Object value) {
        this.sendAlarm(null, type, severity, message, key, value);
    }

    public void sendAlarm(ObjectName target, String type, int severity, String message, String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        this.sendAlarm(target, type, severity, message, map);
    }

    public void sendAlarm(String type, int severity, String message, Object userData) {
        this.sendAlarm(null, type, severity, message, userData);
    }

    public void sendAlarm(ObjectName target, String type, int severity, String message, Object userData) {
        this.sendAlarmNotification(target, type, severity, 3, message, userData);
    }

    protected void sendAlarmNotification(ObjectName target, String type, int severity, int alarmState, String message, Object userData) {
        AlarmNotification n = new AlarmNotification(type, this.mbeanImpl.getMBeanName(), target, severity, alarmState, this.mbeanImpl.getSequenceNumber(), System.currentTimeMillis(), message);
        n.setUserData(userData);
        this.mbeanImpl.emitNotification(n);
    }

    public void sendAttributeChangeNotification(String type, String message, Object userData, String attributeName, String attributeType, Object oldValue, Object newValue) {
        AttributeChangeNotification n = new AttributeChangeNotification(this.mbeanImpl.getMBeanName(), this.mbeanImpl.getSequenceNumber(), System.currentTimeMillis(), message, attributeName, attributeType, oldValue, newValue);
        n.setUserData(userData);
        this.mbeanImpl.emitNotification(n);
    }

    public void sendNotification(String type, String message, Object userData) {
        Notification n = new Notification(type, this.mbeanImpl.getMBeanName(), this.mbeanImpl.getSequenceNumber(), System.currentTimeMillis(), message);
        n.setUserData(userData);
        this.mbeanImpl.emitNotification(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        AlarmManager alarmManager = this;
        synchronized (alarmManager) {
            Iterator i = this.nameMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                Map typeMap = (Map)entry.getValue();
                typeMap.clear();
            }
            this.nameMap.clear();
        }
    }

    private Map getTypeMap(ObjectName name) {
        HashMap typeMap = (HashMap)this.nameMap.get(name);
        if (typeMap == null) {
            typeMap = new HashMap();
            this.nameMap.put(name, typeMap);
        }
        return typeMap;
    }

    private static class Severity {
        public int severity;

        public Severity(int severity) {
            this.severity = severity;
        }
    }
}

