/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.login;

import javax.security.auth.login.AppConfigurationEntry;
import org.jboss.logging.Logger;
import org.jboss.security.auth.login.AppConfigurationEntryHolder;
import org.jboss.security.auth.login.AuthenticationInfo;
import org.jboss.security.auth.login.ModuleOption;
import org.jboss.security.auth.login.PolicyConfig;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class LoginConfigObjectModelFactory
implements ObjectModelFactory {
    private static Logger log = Logger.getLogger((Class)LoginConfigObjectModelFactory.class);
    private boolean trace;

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        if (this.trace) {
            log.trace((Object)"completeRoot");
        }
        return root;
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        this.trace = log.isTraceEnabled();
        if (!localName.equals("policy")) {
            throw new IllegalStateException("Unexpected root element: was expecting 'policy' but got '" + localName + "'");
        }
        if (this.trace) {
            log.trace((Object)"newRoot, created PolicyConfig for policy element");
        }
        return new PolicyConfig();
    }

    public Object newChild(PolicyConfig config, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        AuthenticationInfo child = null;
        if (this.trace) {
            log.trace((Object)("newChild.PolicyConfig, localName: " + localName));
        }
        if ("application-policy".equals(localName)) {
            String name = attrs.getValue("name");
            name = StringPropertyReplacer.replaceProperties((String)name);
            child = new AuthenticationInfo(name);
            if (this.trace) {
                log.trace((Object)("newChild.PolicyConfig, AuthenticationInfo: " + name));
            }
        }
        return child;
    }

    public Object newChild(AuthenticationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        AppConfigurationEntryHolder child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AuthenticationInfo, localName: " + localName));
        }
        if ("login-module".equals(localName)) {
            AppConfigurationEntryHolder holder;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            String flag = attrs.getValue("flag");
            flag = StringPropertyReplacer.replaceProperties((String)flag.trim());
            child = holder = new AppConfigurationEntryHolder(code, flag);
            if (this.trace) {
                log.trace((Object)("newChild.AuthenticationInfo, login-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(AppConfigurationEntryHolder entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AppConfigurationEntryHolder, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.AppConfigurationEntryHolder, module-option name: " + name));
            }
        }
        return child;
    }

    public void setValue(ModuleOption option, UnmarshallingContext navigator, String namespaceUri, String localName, String value) {
        if ("module-option".equals(localName)) {
            String valueWithReplacement = StringPropertyReplacer.replaceProperties((String)value.trim());
            option.setValue(valueWithReplacement);
            if (this.trace) {
                log.trace((Object)("setValue.ModuleOption, name: " + localName));
            }
        }
    }

    public void addChild(PolicyConfig config, AuthenticationInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        config.add(authInfo);
        if (this.trace) {
            log.trace((Object)("addChild.PolicyConfig, name: " + authInfo.getName()));
        }
    }

    public void addChild(AuthenticationInfo authInfo, AppConfigurationEntryHolder entryInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        AppConfigurationEntry entry = entryInfo.getEntry();
        authInfo.addAppConfigurationEntry(entry);
        if (this.trace) {
            log.trace((Object)("addChild.AuthenticationInfo, name: " + entry.getLoginModuleName()));
        }
    }

    public void addChild(AppConfigurationEntryHolder entryInfo, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entryInfo.addOption(option);
        if (this.trace) {
            log.trace((Object)("addChild.AppConfigurationEntryHolder, name: " + option.getName()));
        }
    }

    public void addChild(ModuleOption option, Object value, UnmarshallingContext navigator, String namespaceURI, String localName) {
        option.setValue(value);
        if (this.trace) {
            log.trace((Object)("addChild.ModuleOption, name: " + option.getName()));
        }
    }
}

