/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.propertyeditor;

import java.beans.PropertyEditorSupport;
import java.security.KeyStore;
import java.security.Principal;
import java.util.Set;
import javax.naming.InitialContext;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;

public class SecurityDomainEditor
extends PropertyEditorSupport {
    private static Logger log = Logger.getLogger((Class)SecurityDomainEditor.class);
    private String domainName;

    public void setAsText(String text) {
        this.domainName = text;
        try {
            InitialContext ctx = new InitialContext();
            Object ref = ctx.lookup(text);
            SecurityDomain domain = null;
            domain = ref instanceof SecurityDomain ? (SecurityDomain)ref : new SecurityDomainProxy(this.domainName);
            this.setValue(domain);
        }
        catch (Exception e) {
            log.error((Object)("Failed to lookup SecurityDomain, " + this.domainName), (Throwable)e);
        }
    }

    public String getAsText() {
        return this.domainName;
    }

    static class SecurityDomainProxy
    implements SecurityDomain {
        SecurityDomain delegate;
        private String jndiName;

        SecurityDomainProxy(String jndiName) {
            this.jndiName = jndiName;
        }

        private synchronized void initDelegate() {
            if (this.delegate == null) {
                try {
                    InitialContext ctx = new InitialContext();
                    this.delegate = (SecurityDomain)ctx.lookup(this.jndiName);
                }
                catch (Exception e) {
                    SecurityException se = new SecurityException("Failed to lookup SecurityDomain, " + this.jndiName);
                    se.initCause(e);
                    throw se;
                }
            }
        }

        public KeyStore getKeyStore() throws SecurityException {
            this.initDelegate();
            return this.delegate.getKeyStore();
        }

        public KeyManagerFactory getKeyManagerFactory() throws SecurityException {
            this.initDelegate();
            return this.delegate.getKeyManagerFactory();
        }

        public KeyStore getTrustStore() throws SecurityException {
            this.initDelegate();
            return this.delegate.getTrustStore();
        }

        public TrustManagerFactory getTrustManagerFactory() throws SecurityException {
            this.initDelegate();
            return this.delegate.getTrustManagerFactory();
        }

        public String getSecurityDomain() {
            this.initDelegate();
            return this.delegate.getSecurityDomain();
        }

        public boolean isValid(Principal principal, Object credential) {
            return this.isValid(principal, credential, null);
        }

        public boolean isValid(Principal principal, Object credential, Subject activeSubject) {
            this.initDelegate();
            return this.delegate.isValid(principal, credential, activeSubject);
        }

        public Subject getActiveSubject() {
            this.initDelegate();
            return this.delegate.getActiveSubject();
        }

        public Principal getPrincipal(Principal principal) {
            this.initDelegate();
            return this.delegate.getPrincipal(principal);
        }

        public boolean doesUserHaveRole(Principal principal, Set roles) {
            this.initDelegate();
            return this.delegate.doesUserHaveRole(principal, roles);
        }

        public Set getUserRoles(Principal principal) {
            this.initDelegate();
            return this.delegate.getUserRoles(principal);
        }
    }
}

