/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.composite;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyDefine;
import com.clustercontrol.util.Messages;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TextCellEditor;

public class IPv4PropertyDefine
extends PropertyDefine
implements Serializable {
    private static final long serialVersionUID = 3273834893077954556L;

    public IPv4PropertyDefine() {
        this.m_cellEditor = new TextCellEditor();
    }

    public String getColumnText(Object value) {
        return value.toString();
    }

    public Object getValue(Property element) {
        return element.getValue();
    }

    public void modify(Property element, Object value) {
        boolean check = false;
        try {
            if (((String)value).length() == 0) {
                check = true;
            } else if (((String)value).matches(".{1,3}?\\..{1,3}?\\..{1,3}?\\..{1,3}?")) {
                Inet4Address.getByName((String)value);
                check = true;
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (check) {
            element.setValue(value);
        } else {
            MessageDialog.openWarning(null, (String)Messages.getString("message.hinemos.1"), (String)Messages.getString("message.repository.24"));
        }
    }

    public void initEditer() {
    }
}

