/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class PersistenceXmlLoader {
    private static Log log = LogFactory.getLog(PersistenceXmlLoader.class);

    private PersistenceXmlLoader() {
    }

    private static Document loadURL(URL configURL) throws Exception {
        InputStream is;
        InputStream inputStream = is = configURL != null ? configURL.openStream() : null;
        if (is == null) {
            throw new IOException("Failed to obtain InputStream from url: " + configURL);
        }
        DocumentBuilderFactory docBuilderFactory = null;
        docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(false);
        InputSource source = new InputSource(is);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(source);
        return doc;
    }

    public static PersistenceMetadata deploy(URL url) throws Exception {
        PersistenceMetadata metadata = new PersistenceMetadata();
        Document doc = PersistenceXmlLoader.loadURL(url);
        Element top = doc.getDocumentElement();
        NodeList children = top.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element element = (Element)children.item(i);
            String tag = element.getTagName();
            if (tag.equals("name")) {
                metadata.setName(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("non-jta-data-source")) {
                metadata.setDatasource(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("jta-data-source")) {
                metadata.setJtaDatasource(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("provider")) {
                metadata.setProvider(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("class")) {
                metadata.getClasses().add(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("mapping-file")) {
                metadata.getMappingFiles().add(XmlHelper.getElementContent(element));
                continue;
            }
            if (tag.equals("jar-file")) {
                metadata.getJarFiles().add(XmlHelper.getElementContent(element));
                continue;
            }
            if (!tag.equals("properties")) continue;
            NodeList props = element.getChildNodes();
            for (int j = 0; j < props.getLength(); ++j) {
                Element propElement;
                if (props.item(j).getNodeType() != 1 || !"property".equals((propElement = (Element)props.item(j)).getTagName())) continue;
                String propName = propElement.getAttribute("name").trim();
                String propValue = propElement.getAttribute("value").trim();
                metadata.getProps().put(propName, propValue);
            }
        }
        return metadata;
    }
}

