/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.taglib;

import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.jboss.mx.util.MBeanServerLocator;

public class FlashParametersTag
extends TagSupport {
    public static final String DEFAULT_JBOSSNET_MBEAN_NAME = "jboss.net:service=Axis";
    private String mbeanName = null;
    private Map parms = null;

    public String getMbeanName() {
        return this.mbeanName;
    }

    public void setMbeanName(String mbeanName) {
        this.mbeanName = mbeanName;
    }

    public Map getParms() {
        return this.parms;
    }

    public void setParms(Map parms) {
        this.parms = parms;
    }

    public int doStartTag() throws JspTagException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        try {
            JspWriter out = this.pageContext.getOut();
            if (null == this.mbeanName) {
                this.mbeanName = DEFAULT_JBOSSNET_MBEAN_NAME;
            }
            MBeanServer server = MBeanServerLocator.locateJBoss();
            ObjectName jbossNetObjName = new ObjectName(this.mbeanName);
            String rootContext = (String)server.getAttribute(jbossNetObjName, "RootContext");
            URL reqUrl = new URL(request.getRequestURL().toString());
            String hostUrl = reqUrl.getHost() + ":" + reqUrl.getPort();
            out.print("?hostUrl=" + hostUrl + "&rootContext=" + rootContext);
            if (null != this.parms) {
                Iterator iter = this.parms.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry curEntry = iter.next();
                    out.print("&" + curEntry.getKey().toString().trim() + "=" + curEntry.getValue().toString().trim());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JspTagException(e.toString());
        }
        return 0;
    }
}

