/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.bean.DayOfWeekConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoPK;
import com.clustercontrol.calendar.ejb.entity.CalendarAddInfoUtil;
import com.clustercontrol.calendar.ejb.entity.CalendarInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarInfoUtil;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoLocal;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoPK;
import com.clustercontrol.calendar.ejb.entity.CalendarWeekdayInfoUtil;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyCalendar {
    protected static Log m_log = LogFactory.getLog(ModifyCalendar.class);

    public void addCalendar(Property property, String userName) throws NamingException, CreateException {
        AccessLock.lock((String)"CALENDER");
        String id = null;
        try {
            ArrayList values = null;
            Date now = new Date();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"id");
            id = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"name");
            String name = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            String description = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"validTimeFrom");
            Date validTimeFrom = (Date)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"validTimeTo");
            Date validTimeTo = (Date)values.get(0);
            if (validTimeFrom.after(validTimeTo) || validTimeFrom.equals(validTimeTo)) {
                throw new IllegalArgumentException();
            }
            CalendarInfoUtil.getLocalHome().create(id, name, description, null, validTimeFrom, validTimeTo, now, now, userName, userName);
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            Object[] args = new String[]{id};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("addCalendar() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            Object[] args = new String[]{id};
            apllog.put("SYS", "001", args);
            m_log.debug((Object)("addCalendar() : " + e.getMessage()));
            throw e;
        }
    }

    public void modifyCalendar(Property property, String userName) throws NamingException, FinderException {
        AccessLock.lock((String)"CALENDER");
        String id = null;
        try {
            ArrayList values = null;
            Date now = new Date();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"id");
            id = (String)values.get(0);
            CalendarInfoLocal cal = CalendarInfoUtil.getLocalHome().findByPrimaryKey(id);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"name");
            cal.setCalendar_name((String)values.get(0));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            cal.setDescription((String)values.get(0));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"validTimeFrom");
            cal.setValid_time_from((Date)values.get(0));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"validTimeTo");
            cal.setValid_time_to((Date)values.get(0));
            cal.setUpdate_user(userName);
            cal.setUpdate_date(now);
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            Object[] args = new String[]{id};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modifyCalendar() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            Object[] args = new String[]{id};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modifyCalendar() : " + e.getMessage()));
            throw e;
        }
    }

    public void deleteCalendar(String id) throws NamingException, RemoveException, FinderException {
        AccessLock.lock((String)"CALENDER");
        try {
            Collection weekdayList;
            CalendarInfoLocal cal = CalendarInfoUtil.getLocalHome().findByPrimaryKey(id);
            Collection addList = cal.getCalendarAddInfo();
            if (addList != null && addList.size() > 0) {
                Object[] addArray = addList.toArray();
                for (int j = 0; j < addArray.length; ++j) {
                    CalendarAddInfoLocal add = (CalendarAddInfoLocal)addArray[j];
                    if (add == null) continue;
                    add.remove();
                }
            }
            if ((weekdayList = cal.getCalendarWeekdayInfo()) != null && weekdayList.size() > 0) {
                Object[] weekdayArray = weekdayList.toArray();
                for (int j = 0; j < weekdayArray.length; ++j) {
                    CalendarWeekdayInfoLocal weekday = (CalendarWeekdayInfoLocal)weekdayArray[j];
                    if (weekday == null) continue;
                    weekday.remove();
                }
            }
            cal.remove();
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            Object[] args = new String[]{id};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("deleteCalendar() : " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            Object[] args = new String[]{id};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("deleteCalendar() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            Object[] args = new String[]{id};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("deleteCalendar() : " + e.getMessage()));
            throw e;
        }
    }

    public void addWeekday(String id, Property property, String userName) throws NamingException, CreateException, FinderException {
        AccessLock.lock((String)"CALENDER");
        int weekday = 0;
        Date from = null;
        Date to = null;
        try {
            ArrayList values = null;
            Date now = new Date();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"weekday");
            weekday = DayOfWeekConstant.stringToType((String)((String)values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            String description = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"timeFrom");
            from = (Date)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"timeTo");
            to = (Date)values.get(0);
            if (from.after(to) || from.equals(to)) {
                throw new IllegalArgumentException();
            }
            Collection ct = CalendarWeekdayInfoUtil.getLocalHome().findByTimeFromTo(id, weekday, new Time(from.getTime()), new Time(to.getTime()));
            if (ct.size() > 0) {
                throw new DuplicateKeyException();
            }
            CalendarWeekdayInfoUtil.getLocalHome().create(id, weekday, new Time(from.getTime()), new Time(to.getTime()), description, now, now, userName, userName);
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, String.valueOf(weekday), formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("addWeekday() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, String.valueOf(weekday), formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("addWeekday() : " + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, String.valueOf(weekday), formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "004", args);
            m_log.debug((Object)("addWeekday() : " + e.getMessage()));
            throw e;
        }
    }

    public void modifyWeekday(String id, Integer weekday, Date from, Date to, Property property, String userName) throws NamingException, RemoveException, CreateException, FinderException {
        AccessLock.lock((String)"CALENDER");
        try {
            ArrayList values = null;
            Date now = new Date();
            CalendarWeekdayInfoLocal info = CalendarWeekdayInfoUtil.getLocalHome().findByPrimaryKey(new CalendarWeekdayInfoPK(id, (int)weekday, new Time(from.getTime()), new Time(to.getTime())));
            Date createTimeStamp = info.getReg_date();
            String createUser = info.getReg_user();
            info.remove();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"weekday");
            int newWeekday = DayOfWeekConstant.stringToType((String)((String)values.get(0)));
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            String newDescription = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"timeFrom");
            Date newFrom = (Date)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"timeTo");
            Date newTo = (Date)values.get(0);
            Collection ct = CalendarWeekdayInfoUtil.getLocalHome().findByTimeFromTo(id, newWeekday, new Time(newFrom.getTime()), new Time(newTo.getTime()));
            if (ct.size() > 0) {
                throw new DuplicateKeyException();
            }
            CalendarWeekdayInfoUtil.getLocalHome().create(id, newWeekday, new Time(newFrom.getTime()), new Time(newTo.getTime()), newDescription, createTimeStamp, now, createUser, userName);
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, weekday.toString(), formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("modifyWeekday() : " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, weekday.toString(), formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("modifyWeekday() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, weekday.toString(), formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("modifyWeekday() : " + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, weekday.toString(), formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("modifyWeekday() : " + e.getMessage()));
            throw e;
        }
    }

    public void deleteWeekday(String id, Integer weekday, Date from, Date to) throws NamingException, RemoveException, FinderException {
        AccessLock.lock((String)"CALENDER");
        try {
            CalendarWeekdayInfoLocal info = CalendarWeekdayInfoUtil.getLocalHome().findByPrimaryKey(new CalendarWeekdayInfoPK(id, weekday, new Time(from.getTime()), new Time(to.getTime())));
            info.remove();
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, String.valueOf(weekday), formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("deleteWeekday() : " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, String.valueOf(weekday), formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("deleteWeekday() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, String.valueOf(weekday), formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("deleteWeekday() : " + e.getMessage()));
            throw e;
        }
    }

    public void addAddInfo(String id, Property property, String userName) throws NamingException, CreateException, FinderException {
        AccessLock.lock((String)"CALENDER");
        Date from = null;
        Date to = null;
        try {
            ArrayList values = null;
            Date now = new Date();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            String description = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"timeFrom");
            from = (Date)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"timeTo");
            to = (Date)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"execute");
            int execute = ValidConstant.booleanToType((boolean)((Boolean)values.get(0)));
            if (from.after(to) || from.equals(to)) {
                throw new IllegalArgumentException();
            }
            Collection ct = CalendarAddInfoUtil.getLocalHome().findByTimeFromTo(id, from, to);
            if (ct.size() > 0) {
                throw new DuplicateKeyException();
            }
            CalendarAddInfoUtil.getLocalHome().create(id, from, to, execute, description, now, now, userName, userName);
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("addAddInfo() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("addAddInfo() : " + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "007", args);
            m_log.debug((Object)("addAddInfo() : " + e.getMessage()));
            throw e;
        }
    }

    public void modifyAddInfo(String id, Date from, Date to, Property property, String userName) throws NamingException, RemoveException, CreateException, FinderException {
        AccessLock.lock((String)"CALENDER");
        try {
            ArrayList values = null;
            Date now = new Date();
            CalendarAddInfoLocal info = CalendarAddInfoUtil.getLocalHome().findByPrimaryKey(new CalendarAddInfoPK(id, from, to));
            Date createTimeStamp = info.getReg_date();
            String createUser = info.getReg_user();
            info.remove();
            values = PropertyUtil.getPropertyValue((Property)property, (String)"description");
            String newDescription = (String)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"timeFrom");
            Date newFrom = (Date)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"timeTo");
            Date newTo = (Date)values.get(0);
            values = PropertyUtil.getPropertyValue((Property)property, (String)"execute");
            int newExecute = ValidConstant.booleanToType((boolean)((Boolean)values.get(0)));
            Collection ct = CalendarAddInfoUtil.getLocalHome().findByTimeFromTo(id, newFrom, newTo);
            if (ct.size() > 0) {
                throw new DuplicateKeyException();
            }
            CalendarAddInfoUtil.getLocalHome().create(id, newFrom, newTo, newExecute, newDescription, createTimeStamp, now, createUser, userName);
        }
        catch (EJBException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "009", args);
            m_log.debug((Object)("modifyAddInfo() : " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "009", args);
            m_log.debug((Object)("modifyAddInfo() : " + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "009", args);
            m_log.debug((Object)("modifyAddInfo() : " + e.getMessage()));
            throw e;
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "009", args);
            m_log.debug((Object)("modifyAddInfo() : " + e.getMessage()));
            throw e;
        }
    }

    public void deleteAddInfo(String id, Date from, Date to) throws NamingException, RemoveException, FinderException {
        AccessLock.lock((String)"CALENDER");
        try {
            CalendarAddInfoLocal info = CalendarAddInfoUtil.getLocalHome().findByPrimaryKey(new CalendarAddInfoPK(id, from, to));
            info.remove();
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("deleteAddInfo() : " + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("deleteAddInfo() : " + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("CAL", "cal");
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            Object[] args = new String[]{id, formatter.format(from), formatter.format(to)};
            apllog.put("SYS", "008", args);
            m_log.debug((Object)("deleteAddInfo() : " + e.getMessage()));
            throw e;
        }
    }
}

